/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.BaseFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.AntFilterReader;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Parameterizable;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public final class ChainReaderHelper {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    public Reader primaryReader;
    public int bufferSize = 8192;
    public Vector filterChains = new Vector();
    private Project project = null;
    static /* synthetic */ Class class$java$io$FilterReader;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$org$apache$tools$ant$types$Parameterizable;

    public void setPrimaryReader(Reader rdr) {
        this.primaryReader = rdr;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setFilterChains(Vector fchain) {
        this.filterChains = fchain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reader getAssembledReader() throws BuildException {
        Reader reader;
        ArrayList classLoadersToCleanUp;
        Reader instream;
        block9: {
            if (this.primaryReader == null) {
                throw new BuildException("primaryReader must not be null.");
            }
            instream = this.primaryReader;
            int filterReadersCount = this.filterChains.size();
            Vector finalFilters = new Vector();
            classLoadersToCleanUp = new ArrayList();
            for (int i = 0; i < filterReadersCount; ++i) {
                FilterChain filterchain = (FilterChain)this.filterChains.elementAt(i);
                Vector filterReaders = filterchain.getFilterReaders();
                int readerCount = filterReaders.size();
                for (int j = 0; j < readerCount; ++j) {
                    finalFilters.addElement(filterReaders.elementAt(j));
                }
            }
            int filtersCount = finalFilters.size();
            if (filtersCount > 0) {
                boolean success = false;
                try {
                    for (int i = 0; i < filtersCount; ++i) {
                        Object o = finalFilters.elementAt(i);
                        if (o instanceof AntFilterReader) {
                            instream = this.expandReader((AntFilterReader)finalFilters.elementAt(i), instream, classLoadersToCleanUp);
                            continue;
                        }
                        if (!(o instanceof ChainableReader)) continue;
                        this.setProjectOnObject(o);
                        instream = ((ChainableReader)o).chain(instream);
                        this.setProjectOnObject(instream);
                    }
                    success = true;
                    Object var11_14 = null;
                    if (success || classLoadersToCleanUp.size() <= 0) break block9;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    if (success) throw throwable;
                    if (classLoadersToCleanUp.size() <= 0) throw throwable;
                    ChainReaderHelper.cleanUpClassLoaders(classLoadersToCleanUp);
                    throw throwable;
                }
                ChainReaderHelper.cleanUpClassLoaders(classLoadersToCleanUp);
            }
        }
        Reader finalReader = instream;
        if (classLoadersToCleanUp.size() == 0) {
            reader = finalReader;
            return reader;
        }
        reader = new FilterReader(finalReader){

            public void close() throws IOException {
                FileUtils.close(this.in);
                ChainReaderHelper.cleanUpClassLoaders(classLoadersToCleanUp);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                try {
                    this.close();
                }
                finally {
                    super.finalize();
                }
            }
        };
        return reader;
    }

    private void setProjectOnObject(Object obj) {
        if (this.project == null) {
            return;
        }
        if (obj instanceof BaseFilterReader) {
            ((BaseFilterReader)obj).setProject(this.project);
            return;
        }
        this.project.setProjectReference(obj);
    }

    private static void cleanUpClassLoaders(List loaders) {
        Iterator it = loaders.iterator();
        while (it.hasNext()) {
            ((AntClassLoader)it.next()).cleanup();
        }
    }

    public String readFully(Reader rdr) throws IOException {
        return FileUtils.readFully(rdr, this.bufferSize);
    }

    private Reader expandReader(AntFilterReader filter, Reader ancestor, List classLoadersToCleanUp) {
        String className = filter.getClassName();
        Path classpath = filter.getClasspath();
        Project pro = filter.getProject();
        if (className != null) {
            try {
                Class<?> clazz = null;
                if (classpath == null) {
                    clazz = Class.forName(className);
                } else {
                    AntClassLoader al = pro.createClassLoader(classpath);
                    classLoadersToCleanUp.add(al);
                    clazz = Class.forName(className, true, al);
                }
                if (clazz != null) {
                    int j;
                    if (!(class$java$io$FilterReader == null ? (class$java$io$FilterReader = ChainReaderHelper.class$("java.io.FilterReader")) : class$java$io$FilterReader).isAssignableFrom(clazz)) {
                        throw new BuildException(className + " does not extend" + " java.io.FilterReader");
                    }
                    Constructor<?>[] constructors = clazz.getConstructors();
                    boolean consPresent = false;
                    for (j = 0; j < constructors.length; ++j) {
                        Class<?>[] types = constructors[j].getParameterTypes();
                        if (types.length != 1 || !types[0].isAssignableFrom(class$java$io$Reader == null ? ChainReaderHelper.class$("java.io.Reader") : class$java$io$Reader)) continue;
                        consPresent = true;
                        break;
                    }
                    if (!consPresent) {
                        throw new BuildException(className + " does not define" + " a public constructor" + " that takes in a Reader" + " as its single argument.");
                    }
                    Reader[] rdr = new Reader[]{ancestor};
                    Reader instream = (Reader)constructors[j].newInstance(rdr);
                    this.setProjectOnObject(instream);
                    if ((class$org$apache$tools$ant$types$Parameterizable == null ? (class$org$apache$tools$ant$types$Parameterizable = ChainReaderHelper.class$("org.apache.tools.ant.types.Parameterizable")) : class$org$apache$tools$ant$types$Parameterizable).isAssignableFrom(clazz)) {
                        Parameter[] params = filter.getParams();
                        ((Parameterizable)((Object)instream)).setParameters(params);
                    }
                    return instream;
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new BuildException(cnfe);
            }
            catch (InstantiationException ie) {
                throw new BuildException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new BuildException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new BuildException(ite);
            }
        }
        return ancestor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

