/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JReferenceType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class JConstantPool {
    protected boolean frozen = false;
    protected HashMap entryToIndex = new HashMap();
    protected Entry[] indexToEntry;
    protected int currIndex;
    public static final short CONSTANT_Utf8 = 1;
    public static final short CONSTANT_Integer = 3;
    public static final short CONSTANT_Float = 4;
    public static final short CONSTANT_Long = 5;
    public static final short CONSTANT_Double = 6;
    public static final short CONSTANT_Class = 7;
    public static final short CONSTANT_String = 8;
    public static final short CONSTANT_Fieldref = 9;
    public static final short CONSTANT_Methodref = 10;
    public static final short CONSTANT_InterfaceMethodref = 11;
    public static final short CONSTANT_NameAndType = 12;

    protected JConstantPool(FJBGContext context2) {
        this.indexToEntry = new Entry[8];
        this.currIndex = 1;
    }

    protected JConstantPool(FJBGContext context2, DataInputStream stream) throws IOException {
        short count2 = stream.readShort();
        this.indexToEntry = new EntryIndex[count2];
        this.currIndex = 1;
        while (this.currIndex < count2) {
            EntryIndex e;
            byte tag = stream.readByte();
            switch (tag) {
                case 1: {
                    e = new Utf8Entry(stream);
                    this.entryToIndex.put(e, new Integer(this.currIndex));
                    break;
                }
                case 3: {
                    e = new IntegerEntry(stream);
                    break;
                }
                case 4: {
                    e = new FloatEntry(stream);
                    break;
                }
                case 5: {
                    e = new LongEntry(stream);
                    break;
                }
                case 6: {
                    e = new DoubleEntry(stream);
                    break;
                }
                case 7: {
                    e = new DescriptorEntryIndex(stream);
                    break;
                }
                case 8: {
                    e = new StringEntryIndex(stream);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    e = new FieldOrMethodRefEntryIndex(tag, stream);
                    break;
                }
                case 12: {
                    e = new NameAndTypeEntryIndex(stream);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown entry in pool: " + tag);
                }
            }
            this.indexToEntry[this.currIndex] = e;
            this.currIndex += e.getSize();
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    public String getEntryType(int tag) {
        switch (tag) {
            case 1: {
                return "Utf8";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Long";
            }
            case 6: {
                return "Double";
            }
            case 7: {
                return "Class";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Field";
            }
            case 10: {
                return "Method";
            }
            case 11: {
                return "InterfaceMethod";
            }
            case 12: {
                return "NameAndType";
            }
        }
        throw new Error("invalid constant pool tag : " + tag);
    }

    public int addClass(String className) {
        return this.addDescriptor(className.replace('.', '/'));
    }

    public int addDescriptor(JReferenceType type) {
        return this.addDescriptor(type.getDescriptor());
    }

    protected int addDescriptor(String name) {
        return this.addEntry(new DescriptorEntryValue(name));
    }

    public int addClassMethodRef(String className, String methodName, String signature) {
        return this.addMethodRef(true, className, methodName, signature);
    }

    public int addInterfaceMethodRef(String className, String methodName, String signature) {
        return this.addMethodRef(false, className, methodName, signature);
    }

    public int addMethodRef(boolean isClass, String className, String methodName, String signature) {
        return this.addEntry(new FieldOrMethodRefEntryValue(isClass ? 10 : 11, className, methodName, signature));
    }

    public int addFieldRef(String className, String fieldName, String signature) {
        return this.addEntry(new FieldOrMethodRefEntryValue(9, className, fieldName, signature));
    }

    public int addInteger(int value2) {
        return this.addEntry(new IntegerEntry(value2));
    }

    public int addFloat(float value2) {
        return this.addEntry(new FloatEntry(value2));
    }

    public int addLong(long value2) {
        return this.addEntry(new LongEntry(value2));
    }

    public int addDouble(double value2) {
        return this.addEntry(new DoubleEntry(value2));
    }

    public int addString(String value2) {
        return this.addEntry(new StringEntryValue(value2));
    }

    public int addNameAndType(String name, String descriptor) {
        return this.addEntry(new NameAndTypeEntryValue(name, descriptor));
    }

    public int addUtf8(String value2) {
        return this.addEntry(new Utf8Entry(value2));
    }

    public int addUtf8(byte[] value2) {
        return this.addEntry(new Utf8Entry(value2));
    }

    protected int addEntry(EntryValue e) {
        assert (!this.frozen);
        Integer idx = (Integer)this.entryToIndex.get(e);
        if (idx != null) {
            return idx;
        }
        e.addChildren();
        int index = this.currIndex;
        this.currIndex += e.getSize();
        this.entryToIndex.put(e, new Integer(index));
        if (index >= this.indexToEntry.length) {
            Entry[] newI2E = new Entry[this.indexToEntry.length * 2];
            System.arraycopy(this.indexToEntry, 0, newI2E, 0, this.indexToEntry.length);
            this.indexToEntry = newI2E;
        }
        this.indexToEntry[index] = e;
        return index;
    }

    public Entry lookupEntry(int index) {
        assert (index > 0 && index < this.currIndex) : "invalid index: " + index;
        assert (this.indexToEntry[index] != null) : "invalid index (null contents): " + index;
        return this.indexToEntry[index];
    }

    public String lookupClass(int index) {
        DescriptorEntry entry2 = (DescriptorEntry)this.lookupEntry(index);
        return entry2.getValue();
    }

    public String lookupNameAndType(int index) {
        NameAndTypeEntry entry2 = (NameAndTypeEntry)this.lookupEntry(index);
        return entry2.getName() + ":" + entry2.getDescriptor();
    }

    public String lookupUtf8(int index) {
        Utf8Entry entry2 = (Utf8Entry)this.lookupEntry(index);
        return entry2.getValue();
    }

    public void writeTo(DataOutputStream stream) throws IOException {
        if (!this.frozen) {
            this.freeze();
        }
        stream.writeShort(this.currIndex);
        for (int i = 0; i < this.currIndex; ++i) {
            Entry entry2 = this.indexToEntry[i];
            if (entry2 == null) continue;
            stream.writeByte(entry2.getTag());
            entry2.writeContentsTo(stream);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  Constant pool:");
        for (int i = 0; i < this.currIndex; ++i) {
            Entry entry2 = this.indexToEntry[i];
            if (entry2 == null) continue;
            if (i > 0) {
                buf.append("\n");
            }
            buf.append("const #");
            buf.append(i);
            buf.append(" = ");
            buf.append(entry2);
        }
        buf.append("\n");
        return buf.toString();
    }

    protected class NameAndTypeEntryIndex
    extends NameAndTypeEntry
    implements EntryIndex {
        public NameAndTypeEntryIndex(int nameIndex, int descriptorIndex) {
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
        }

        public NameAndTypeEntryIndex(DataInputStream stream) throws IOException {
            this(stream.readShort(), stream.readShort());
        }

        public String getName() {
            if (this.name == null) {
                this.fetchChildren();
            }
            return super.getName();
        }

        public String getDescriptor() {
            if (this.descriptor == null) {
                this.fetchChildren();
            }
            return super.getDescriptor();
        }

        public void fetchChildren() {
            this.name = JConstantPool.this.lookupUtf8(this.nameIndex);
            this.descriptor = JConstantPool.this.lookupUtf8(this.descriptorIndex);
        }
    }

    protected class NameAndTypeEntryValue
    extends NameAndTypeEntry
    implements EntryValue {
        public NameAndTypeEntryValue(String name, String descriptor) {
            this.name = name.intern();
            this.descriptor = descriptor.intern();
        }

        public void addChildren() {
            this.nameIndex = JConstantPool.this.addUtf8(this.name);
            this.descriptorIndex = JConstantPool.this.addUtf8(this.descriptor);
        }
    }

    public abstract class NameAndTypeEntry
    implements Entry {
        protected String name;
        protected String descriptor;
        protected int nameIndex;
        protected int descriptorIndex;

        public int hashCode() {
            return this.name.hashCode() + this.descriptor.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof NameAndTypeEntry && ((NameAndTypeEntry)o).name == this.name && ((NameAndTypeEntry)o).descriptor == this.descriptor;
        }

        public int getTag() {
            return 12;
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public int getSize() {
            return 1;
        }

        public void writeContentsTo(DataOutputStream stream) throws IOException {
            stream.writeShort(this.nameIndex);
            stream.writeShort(this.descriptorIndex);
        }

        public String toString() {
            String natName = this.getName();
            if ("<init>".equals(natName)) {
                natName = "\"" + natName + "\"";
            }
            return "NameAndType\t#" + this.nameIndex + ":#" + this.descriptorIndex + ";//  " + natName + ":" + this.getDescriptor();
        }

        public String toComment(String ownerClassname) {
            return "";
        }
    }

    protected class FieldOrMethodRefEntryIndex
    extends FieldOrMethodRefEntry
    implements EntryIndex {
        public FieldOrMethodRefEntryIndex(int tag, int classIndex, int nameAndTypeIndex) {
            super(tag);
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        public FieldOrMethodRefEntryIndex(int tag, DataInputStream stream) throws IOException {
            this(tag, stream.readShort(), stream.readShort());
        }

        public String getClassName() {
            if (this.className == null) {
                this.fetchChildren();
            }
            return super.getClassName();
        }

        public String getFieldOrMethodName() {
            if (this.thingName == null) {
                this.fetchChildren();
            }
            return super.getFieldOrMethodName();
        }

        public String getSignature() {
            if (this.signature == null) {
                this.fetchChildren();
            }
            return super.getSignature();
        }

        public void fetchChildren() {
            this.className = JConstantPool.this.lookupClass(this.classIndex);
            NameAndTypeEntry nat = (NameAndTypeEntry)JConstantPool.this.lookupEntry(this.nameAndTypeIndex);
            this.thingName = nat.getName();
            this.signature = nat.getDescriptor();
        }
    }

    protected class FieldOrMethodRefEntryValue
    extends FieldOrMethodRefEntry
    implements EntryValue {
        public FieldOrMethodRefEntryValue(int tag, String className, String thingName, String signature) {
            super(tag);
            this.className = className.intern();
            this.thingName = thingName.intern();
            this.signature = signature.intern();
        }

        public void addChildren() {
            this.classIndex = JConstantPool.this.addClass(this.className);
            this.nameAndTypeIndex = JConstantPool.this.addNameAndType(this.thingName, this.signature);
        }
    }

    public abstract class FieldOrMethodRefEntry
    implements Entry {
        private final int tag;
        protected String className;
        protected String thingName;
        protected String signature;
        protected int classIndex;
        protected int nameAndTypeIndex;

        public FieldOrMethodRefEntry(int tag) {
            assert (tag == 9 || tag == 10 || tag == 11);
            this.tag = tag;
        }

        public int hashCode() {
            return this.tag + this.className.hashCode() + this.thingName.hashCode() + this.signature.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof FieldOrMethodRefEntry && ((FieldOrMethodRefEntry)o).tag == this.tag && ((FieldOrMethodRefEntry)o).className == this.className && ((FieldOrMethodRefEntry)o).thingName == this.thingName && ((FieldOrMethodRefEntry)o).signature == this.signature;
        }

        public int getTag() {
            return this.tag;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFieldOrMethodName() {
            return this.thingName;
        }

        public String getSignature() {
            return this.signature;
        }

        public int getSize() {
            return 1;
        }

        public void writeContentsTo(DataOutputStream stream) throws IOException {
            stream.writeShort(this.classIndex);
            stream.writeShort(this.nameAndTypeIndex);
        }

        public String toString() {
            return JConstantPool.this.getEntryType(this.tag) + "\t#" + this.classIndex + ".#" + this.nameAndTypeIndex + ";\t//  " + this.getName("") + ":" + this.signature;
        }

        public String toComment(String ownerClassName) {
            return "//" + JConstantPool.this.getEntryType(this.tag) + " " + this.getName(ownerClassName) + ":" + this.signature;
        }

        private String getName(String ownerClassName) {
            String name = this.getFieldOrMethodName();
            if ("<init>".equals(name)) {
                name = "\"" + name + "\"";
            }
            if (!this.getClassName().equals(ownerClassName)) {
                name = this.getClassName() + "." + name;
            }
            return name;
        }
    }

    protected class DescriptorEntryIndex
    extends DescriptorEntry
    implements EntryIndex {
        public DescriptorEntryIndex(int nameIndex) {
            this.nameIndex = nameIndex;
        }

        public DescriptorEntryIndex(DataInputStream stream) throws IOException {
            this(stream.readShort());
        }

        public String getValue() {
            if (this.name == null) {
                this.fetchChildren();
            }
            return super.getValue();
        }

        public void fetchChildren() {
            this.name = JConstantPool.this.lookupUtf8(this.nameIndex);
        }
    }

    protected class DescriptorEntryValue
    extends DescriptorEntry
    implements EntryValue {
        public DescriptorEntryValue(String name) {
            this.name = name.intern();
        }

        public void addChildren() {
            this.nameIndex = JConstantPool.this.addUtf8(this.name);
        }
    }

    public abstract class DescriptorEntry
    implements Entry {
        protected String name;
        protected int nameIndex;

        public int hashCode() {
            assert (this.name != null);
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof DescriptorEntry && ((DescriptorEntry)o).name == this.name;
        }

        public int getTag() {
            return 7;
        }

        public String getValue() {
            return this.name;
        }

        public int getSize() {
            return 1;
        }

        public void writeContentsTo(DataOutputStream stream) throws IOException {
            stream.writeShort(this.nameIndex);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("class\t#");
            buf.append(this.nameIndex);
            buf.append(";\t//  ");
            buf.append(this.getClassName());
            return buf.toString();
        }

        public String toComment(String ownerClassname) {
            return "//class " + this.getClassName();
        }

        private String getClassName() {
            StringBuffer buf = new StringBuffer();
            String value2 = this.getValue();
            if (value2.startsWith("[")) {
                buf.append("\"");
            }
            buf.append(value2);
            if (value2.startsWith("[")) {
                buf.append("\"");
            }
            return buf.toString();
        }
    }

    public class StringEntryIndex
    extends StringEntry
    implements EntryIndex {
        public StringEntryIndex(int valueIndex) {
            this.valueIndex = valueIndex;
        }

        public StringEntryIndex(DataInputStream stream) throws IOException {
            this(stream.readShort());
        }

        public String getValue() {
            if (this.value == null) {
                this.fetchChildren();
            }
            return super.getValue();
        }

        public void fetchChildren() {
            this.value = JConstantPool.this.lookupUtf8(this.valueIndex);
        }
    }

    public class StringEntryValue
    extends StringEntry
    implements EntryValue {
        public StringEntryValue(String value2) {
            this.value = value2.intern();
        }

        public void addChildren() {
            this.valueIndex = JConstantPool.this.addUtf8(this.value);
        }
    }

    public abstract class StringEntry
    implements Entry {
        protected String value;
        protected int valueIndex;

        public int hashCode() {
            assert (this.value != null);
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof StringEntry && ((StringEntry)o).value == this.value;
        }

        public int getTag() {
            return 8;
        }

        public String getValue() {
            return this.value;
        }

        public int getSize() {
            return 1;
        }

        public void writeContentsTo(DataOutputStream stream) throws IOException {
            stream.writeShort(this.valueIndex);
        }

        public String toString() {
            return "String\t#" + this.valueIndex + ";\t//  " + this.escaped(this.getValue());
        }

        public String toComment(String ownerClassname) {
            return "//String " + this.escaped(this.getValue());
        }

        private String escaped(String s) {
            return s.replace("\n", "\\n");
        }
    }

    public class Utf8Entry
    extends ChildlessEntry
    implements Entry {
        private final String value;
        private final byte[] bytes;

        public Utf8Entry(String value2) {
            this.value = value2.intern();
            this.bytes = null;
        }

        public Utf8Entry(DataInputStream stream) throws IOException {
            this(stream.readUTF());
        }

        public Utf8Entry(byte[] bytes2) {
            this.bytes = bytes2;
            this.value = null;
        }

        public int hashCode() {
            if (this.bytes != null) {
                return this.bytes.hashCode();
            }
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            boolean isEqual = o instanceof Utf8Entry;
            isEqual = this.bytes != null ? isEqual && ((Utf8Entry)o).bytes == this.bytes : isEqual && ((Utf8Entry)o).value == this.value;
            return isEqual;
        }

        public int getTag() {
            return 1;
        }

        public String getValue() {
            return this.value;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public int getSize() {
            return 1;
        }

        public void writeContentsTo(DataOutputStream stream) throws IOException {
            if (this.bytes != null) {
                if (this.bytes.length > 65535) {
                    throw new IOException("String literal of length " + this.bytes.length + " does not fit in Classfile");
                }
                stream.writeShort(this.bytes.length);
                stream.write(this.bytes);
            } else {
                stream.writeUTF(this.value);
            }
        }

        public String toString() {
            return "Asciz\t" + this.escaped(this.getValue()) + ";";
        }

        public String toComment(String ownerClassname) {
            return "//Asciz " + this.escaped(this.getValue());
        }

        private String escaped(String s) {
            return s.replace("\n", "\\n");
        }
    }

    public class DoubleEntry
    extends ChildlessEntry
    implements Entry {
        private final double value;

        public DoubleEntry(double value2) {
            this.value = value2;
        }

        public DoubleEntry(DataInputStream stream) throws IOException {
            this(stream.readDouble());
        }

        public int hashCode() {
            return (int)this.value;
        }

        public boolean equals(Object o) {
            return o instanceof DoubleEntry && ((DoubleEntry)o).value == this.value;
        }

        public int getTag() {
            return 6;
        }

        public double getValue() {
            return this.value;
        }

        public int getSize() {
            return 2;
        }

        public void writeContentsTo(DataOutputStream stream) throws IOException {
            stream.writeDouble(this.value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("double\t");
            buf.append(this.getValue());
            return buf.toString();
        }

        public String toComment(String ownerClassname) {
            return "//double " + this.getValue();
        }
    }

    public class LongEntry
    extends ChildlessEntry
    implements Entry {
        private final long value;

        public LongEntry(long value2) {
            this.value = value2;
        }

        public LongEntry(DataInputStream stream) throws IOException {
            this(stream.readLong());
        }

        public int hashCode() {
            return (int)this.value;
        }

        public boolean equals(Object o) {
            return o instanceof LongEntry && ((LongEntry)o).value == this.value;
        }

        public int getTag() {
            return 5;
        }

        public long getValue() {
            return this.value;
        }

        public int getSize() {
            return 2;
        }

        public void writeContentsTo(DataOutputStream stream) throws IOException {
            stream.writeLong(this.value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("long\t");
            buf.append(this.getValue());
            buf.append("l;");
            return buf.toString();
        }

        public String toComment(String ownerClassname) {
            return "//long " + this.getValue() + "l";
        }
    }

    public class FloatEntry
    extends ChildlessEntry
    implements Entry {
        private final float value;

        public FloatEntry(float value2) {
            this.value = value2;
        }

        public FloatEntry(DataInputStream stream) throws IOException {
            this(stream.readFloat());
        }

        public int hashCode() {
            return (int)this.value;
        }

        public boolean equals(Object o) {
            return o instanceof FloatEntry && ((FloatEntry)o).value == this.value;
        }

        public int getTag() {
            return 4;
        }

        public float getValue() {
            return this.value;
        }

        public int getSize() {
            return 1;
        }

        public void writeContentsTo(DataOutputStream stream) throws IOException {
            stream.writeFloat(this.value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("float\t");
            buf.append(this.getValue());
            buf.append("f");
            return buf.toString();
        }

        public String toComment(String ownerClassname) {
            return "//float " + this.getValue() + "f";
        }
    }

    public class IntegerEntry
    extends ChildlessEntry
    implements Entry {
        private final int value;

        public IntegerEntry(int value2) {
            this.value = value2;
        }

        public IntegerEntry(DataInputStream stream) throws IOException {
            this(stream.readInt());
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof IntegerEntry && ((IntegerEntry)o).value == this.value;
        }

        public int getTag() {
            return 3;
        }

        public int getValue() {
            return this.value;
        }

        public int getSize() {
            return 1;
        }

        public void writeContentsTo(DataOutputStream stream) throws IOException {
            stream.writeInt(this.value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("int\t");
            buf.append(this.getValue());
            buf.append(";");
            return buf.toString();
        }

        public String toComment(String ownerClassname) {
            return "//int " + this.getValue();
        }
    }

    protected abstract class ChildlessEntry
    implements EntryValue,
    EntryIndex {
        protected ChildlessEntry() {
        }

        public void addChildren() {
        }

        public void fetchChildren() {
        }
    }

    protected static interface EntryIndex
    extends Entry {
        public void fetchChildren();
    }

    protected static interface EntryValue
    extends Entry {
        public void addChildren();
    }

    public static interface Entry {
        public int getTag();

        public int getSize();

        public void writeContentsTo(DataOutputStream var1) throws IOException;

        public String toComment(String var1);
    }
}

