/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2010, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |    http://scala-lang.org/               **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: ExternalSources.scala 20028 2009-12-07 11:49:19Z cunei $


package scala.xml
package parsing

import java.net.URL
import java.io.File.separator

import scala.io.Source

/**
 *  @author  Burak Emir
 *  @version 1.0
 */
trait ExternalSources
{ 
  self: ExternalSources with MarkupParser with MarkupHandler =>

  /** ...
   *
   *  @param systemId ...
   *  @return         ...
   */
  def externalSource(systemId: String): Source = {
    if (systemId startsWith "http:")
      return Source fromURL new URL(systemId)
      
    val fileStr: String = input.descr match {
      case x if x startsWith "file:"  => x drop 5
      case x                          => x take ((x lastIndexOf separator) + 1)
    }
    
    Source.fromPath(fileStr + systemId)()
  }
}
