/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History {
    private List<String> history = new ArrayList<String>();
    private PrintWriter output = null;
    private int maxSize = 500;
    private int currentIndex = 0;

    public History() {
    }

    public History(File historyFile) throws IOException {
        this.setHistoryFile(historyFile);
    }

    public void setHistoryFile(File historyFile) throws IOException {
        if (historyFile.isFile()) {
            this.load(new FileInputStream(historyFile));
        }
        this.setOutput(new PrintWriter((Writer)new FileWriter(historyFile), true));
        this.flushBuffer();
    }

    public void load(InputStream in) throws IOException {
        this.load(new InputStreamReader(in));
    }

    public void load(Reader reader) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(reader);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = breader.readLine()) != null) {
            lines.add(line);
        }
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            this.addToHistory((String)i.next());
        }
    }

    public int size() {
        return this.history.size();
    }

    public void clear() {
        this.history.clear();
        this.currentIndex = 0;
    }

    public void addToHistory(String buffer) {
        if (this.history.size() != 0 && buffer.equals(this.history.get(this.history.size() - 1))) {
            return;
        }
        this.history.add(buffer);
        while (this.history.size() > this.getMaxSize()) {
            this.history.remove(0);
        }
        this.currentIndex = this.history.size();
        if (this.getOutput() != null) {
            this.getOutput().println(buffer);
            this.getOutput().flush();
        }
    }

    public void flushBuffer() throws IOException {
        if (this.getOutput() != null) {
            Iterator<String> i = this.history.iterator();
            while (i.hasNext()) {
                this.getOutput().println(i.next());
            }
            this.getOutput().flush();
        }
    }

    public boolean moveToLastEntry() {
        int lastEntry = this.history.size() - 1;
        if (lastEntry >= 0 && lastEntry != this.currentIndex) {
            this.currentIndex = this.history.size() - 1;
            return true;
        }
        return false;
    }

    public void moveToEnd() {
        this.currentIndex = this.history.size();
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setOutput(PrintWriter output) {
        this.output = output;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public String current() {
        if (this.currentIndex >= this.history.size()) {
            return "";
        }
        return this.history.get(this.currentIndex);
    }

    public boolean previous() {
        if (this.currentIndex <= 0) {
            return false;
        }
        --this.currentIndex;
        return true;
    }

    public boolean next() {
        if (this.currentIndex >= this.history.size()) {
            return false;
        }
        ++this.currentIndex;
        return true;
    }

    public List<String> getHistoryList() {
        return Collections.unmodifiableList(this.history);
    }

    public String toString() {
        return this.history.toString();
    }

    public boolean moveToFirstEntry() {
        if (this.history.size() > 0 && this.currentIndex != 0) {
            this.currentIndex = 0;
            return true;
        }
        return false;
    }
}

