/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2010, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |    http://scala-lang.org/               **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: LinearSeq.scala 21540 2010-04-13 17:36:21Z odersky $


package scala.collection
package immutable

import generic._
import mutable.Builder

/** A subtrait of `collection.LinearSeq` which represents sequences that
 *  are guaranteed immutable.
 *  $linearSeqInfo
 */
trait LinearSeq[+A] extends Seq[A] 
                            with scala.collection.LinearSeq[A] 
                            with GenericTraversableTemplate[A, LinearSeq]
                            with LinearSeqLike[A, LinearSeq[A]] {
  override def companion: GenericCompanion[LinearSeq] = LinearSeq
}

/** $factoryInfo
 *  The current default implementation of a $Coll is a `List`.
 *  @define coll immutable linear sequence
 *  @define Coll immutable.LinearSeq
 */
object LinearSeq extends SeqFactory[LinearSeq] {
  implicit def canBuildFrom[A]: CanBuildFrom[Coll, A, LinearSeq[A]] = new GenericCanBuildFrom[A]
  def newBuilder[A]: Builder[A, LinearSeq[A]] = new mutable.ListBuffer
}
