/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public abstract class GeneralBase
implements DataInput,
DataOutput {
    public void write(int b) throws IOException {
        throw new RuntimeException("No write()");
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            this.write(b[off + i]);
            ++i;
        }
    }

    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    public void writeBytes(String s) throws IOException {
        throw new RuntimeException("Function not supported");
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
            ++i;
        }
    }

    public void writeUTF(String str) throws IOException {
        GeneralBase.writeUTF(str, this);
    }

    public static int writeUTF(String str, DataOutput out) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        int i = 0;
        while (i < strlen) {
            c = charr[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i2 = 0;
        while (i2 < strlen) {
            c = charr[i2];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i2;
        }
        out.write(bytearr);
        return utflen + 2;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public int read() throws IOException {
        throw new RuntimeException("No read()");
    }

    public long skip(long n) throws IOException {
        long m = n;
        while (m > 0L) {
            if (this.read() < 0) break;
            --m;
        }
        return n - m;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int ch = this.read();
            if (ch < 0) {
                throw new EOFException();
            }
            b[off + n++] = (byte)ch;
        }
    }

    public int skipBytes(int n) throws IOException {
        int total = 0;
        int cur = 0;
        while (total < n && (cur = (int)this.skip(n - total)) > 0) {
            total += cur;
        }
        return total;
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readLine() throws IOException {
        throw new RuntimeException("Function not supported");
    }

    public static native void iowait();
}

