/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.StringBuilder;
import scala.Tuple2;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.tools.nsc.CompileSocket;
import scala.tools.nsc.CompileSocket$;
import scala.tools.nsc.FatalError;
import scala.tools.nsc.Global;
import scala.tools.nsc.OfflineCompilerCommand;
import scala.tools.nsc.Properties$;
import scala.tools.nsc.Settings;
import scala.tools.nsc.StandardCompileServer$;
import scala.tools.nsc.reporters.ConsoleReporter;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.FakePos;
import scala.tools.util.SocketServer;

public class StandardCompileServer
extends SocketServer
implements ScalaObject {
    private final File redirectDir;
    private ConsoleReporter reporter;
    private final Runtime runtime;
    private Global compiler = null;
    private boolean shutDown = false;
    private final double MaxCharge;
    private final String versionMsg = new StringBuilder().append((Object)"Fast Scala compiler ").append((Object)Properties$.MODULE$.versionString()).append((Object)" -- ").append((Object)Properties$.MODULE$.copyrightString()).toString();

    public StandardCompileServer() {
        this.MaxCharge = 0.8;
        this.runtime = Runtime.getRuntime();
        this.redirectDir = new File(this.compileSocket().tmpDir(), "output-redirects");
        this.redirectDir().mkdirs();
    }

    public final void error$1(String msg) {
        this.out().println(new Tuple2((Object)new FakePos("fsc"), (Object)new StringBuilder().append((Object)msg).append((Object)"\n  fsc -help  gives more information").toString()));
    }

    public void main(String[] args) {
        this.redirect(new $anonfun$main$1(this), "scala-compile-server-out.log");
        this.redirect(new $anonfun$main$2(this), "scala-compile-server-err.log");
        System.err.println(new StringBuilder().append((Object)"...starting server on socket ").append((Object)BoxesRunTime.boxToInteger((int)this.port())).append((Object)"...").toString());
        System.err.flush();
        this.compileSocket().setPort(this.port());
        this.run();
        this.compileSocket().deletePort(this.port());
        throw this.exit(0);
    }

    private void redirect(Function1 setter2, String filename) {
        setter2.apply((Object)new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(this.redirectDir(), filename)))));
    }

    private File redirectDir() {
        return this.redirectDir;
    }

    public void session() {
        System.out.println(new StringBuilder().append((Object)"New session, total memory = ").append((Object)BoxesRunTime.boxToLong((long)this.runtime().totalMemory())).append((Object)", max memory = ").append((Object)BoxesRunTime.boxToLong((long)this.runtime().maxMemory())).append((Object)", free memory = ").append((Object)BoxesRunTime.boxToLong((long)this.runtime().freeMemory())).toString());
        System.out.flush();
        String password = this.compileSocket().getPassword(this.port());
        String guessedPassword = this.in().readLine();
        String input = this.in().readLine();
        if (input != null) {
            String string = password;
            String string2 = guessedPassword;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                List args = new BoxedObjectArray((Object[])input.split("\u0000", -1)).toList();
                if (args.contains((Object)"-shutdown")) {
                    this.out().println("[Compile server exited]");
                    this.shutDown_$eq(true);
                    return;
                }
                if (args.contains((Object)"-reset")) {
                    this.out().println("[Compile server was reset]");
                    this.compiler_$eq(null);
                    return;
                }
                OfflineCompilerCommand command$1 = this.newOfflineCompilerCommand(args, new Settings(new $anonfun$1(this)), new $anonfun$2(this), false);
                this.reporter_$eq(new $anon$2(this, command$1));
                if (command$1.shouldStopWithInfo()) {
                    this.reporter().info(null, command$1.getInfoMessage(this.newGlobal(command$1.settings(), this.reporter())), true);
                } else if (command$1.files().isEmpty()) {
                    this.reporter().info(null, command$1.usageMsg(), true);
                } else {
                    try {
                        if (this.compiler() != null && this.settingsAreCompatible(command$1.settings(), this.compiler().settings())) {
                            this.compiler().settings_$eq(command$1.settings());
                            this.compiler().reporter_$eq(this.reporter());
                        } else {
                            if (args.contains((Object)"-verbose")) {
                                this.out().println("[Starting new compile server instance]");
                            }
                            this.compiler_$eq(this.newGlobal(command$1.settings(), this.reporter()));
                        }
                        Global c = this.compiler();
                        Global.Run run2 = c.new Global.Run();
                        run2.compile(command$1.files());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof FatalError) {
                            FatalError fatalError = (FatalError)throwable2;
                            if (command$1.settings().debug().value()) {
                                fatalError.printStackTrace(this.out());
                            }
                            this.reporter().error(null, new StringBuilder().append((Object)"fatal error: ").append((Object)fatalError.msg()).toString());
                            this.compiler_$eq(null);
                        }
                        if (throwable2 == null) {
                            throw new MatchError((Object)throwable2);
                        }
                        Throwable ex = throwable2;
                        ex.printStackTrace(this.out());
                        this.reporter().error(null, new StringBuilder().append((Object)"fatal error (server aborted): ").append((Object)ex.getMessage()).toString());
                        this.shutDown_$eq(true);
                    }
                    this.reporter().printSummary();
                    this.runtime().gc();
                    if ((double)(this.runtime().totalMemory() - this.runtime().freeMemory()) / (double)this.runtime().maxMemory() > this.MaxCharge()) {
                        this.compiler_$eq(null);
                    }
                }
            }
        }
    }

    public OfflineCompilerCommand newOfflineCompilerCommand(List arguments, Settings settings, Function1 error, boolean interactive) {
        return new OfflineCompilerCommand(arguments, settings, error, interactive);
    }

    public void timeout() {
        if (this.compileSocket().portFile(this.port()).exists()) {
            return;
        }
        throw this.fatal("port file no longer exists; skipping cleanup");
    }

    public Global newGlobal(Settings settings$1, Reporter reporter$1) {
        return new $anon$1(this, settings$1, reporter$1);
    }

    public void reporter_$eq(ConsoleReporter x$1) {
        this.reporter = x$1;
    }

    public ConsoleReporter reporter() {
        return this.reporter;
    }

    private Runtime runtime() {
        return this.runtime;
    }

    private Nothing$ exit(int code) {
        System.err.close();
        System.out.close();
        return Predef$.MODULE$.exit(code);
    }

    private boolean settingsAreCompatible(Settings s1, Settings s2) {
        Settings settings = s1;
        Settings settings2 = s2;
        return !(settings != null ? !((Object)settings).equals(settings2) : settings2 != null);
    }

    private void compiler_$eq(Global x$1) {
        this.compiler = x$1;
    }

    private Global compiler() {
        return this.compiler;
    }

    public void shutDown_$eq(boolean x$1) {
        this.shutDown = x$1;
    }

    public boolean shutDown() {
        return this.shutDown;
    }

    public double MaxCharge() {
        return this.MaxCharge;
    }

    public String versionMsg() {
        return this.versionMsg;
    }

    public CompileSocket compileSocket() {
        return CompileSocket$.MODULE$;
    }
}

