/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.ScalaObject;
import scala.StringBuilder;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxesRunTime;

public abstract class ExactNumeric
extends Numeric
implements ScalaObject {
    private final int nativeTypeId;

    public ExactNumeric(int nativeTypeId) {
        this.nativeTypeId = nativeTypeId;
        super(nativeTypeId);
    }

    public String sqlString() {
        block11: {
            String string;
            int n = this.precisionRadix();
            int n2 = this.precision();
            int n3 = this.scale();
            switch (n) {
                default: {
                    throw new UnsupportedFeature("SQL-99 does not support the precision of an exact numeric type to be defined in a radix other than 2 or 10");
                }
                case 10: {
                    if (n3 == 0) {
                        string = new StringBuilder().append((Object)"NUMERIC (").append((Object)((Object)BoxesRunTime.boxToInteger((int)n2)).toString()).append((Object)")").toString();
                        break;
                    }
                    string = new StringBuilder().append((Object)"NUMERIC (").append((Object)((Object)BoxesRunTime.boxToInteger((int)n2)).toString()).append((Object)", ").append((Object)((Object)BoxesRunTime.boxToInteger((int)n3)).toString()).append((Object)")").toString();
                    break;
                }
                case 2: {
                    if (n2 == 16) {
                        if (n3 == 0) {
                            string = "SMALLINT";
                            break;
                        }
                        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    if (n2 == 32) {
                        if (n3 == 0) {
                            string = "INTEGER";
                            break;
                        }
                        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    if (n2 == 64) {
                        if (n3 == 0) {
                            string = "BIGINT";
                            break;
                        }
                        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    if (n2 != Integer.MAX_VALUE || n3 != 0) break block11;
                    string = "BIGINT";
                }
            }
            return string;
        }
        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
    }

    public abstract int scale();

    public boolean isSubtypeOf(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ExactNumeric) {
            ExactNumeric exactNumeric;
            ExactNumeric dt = exactNumeric = (ExactNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() <= dt.precision() && this.scale() <= dt.scale() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isEquivalent(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ExactNumeric) {
            ExactNumeric exactNumeric;
            ExactNumeric dt = exactNumeric = (ExactNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() == dt.precision() && this.scale() == dt.scale() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

