/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.EtchedLineBorder;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.Debugger;
import com.izforge.izpack.installer.GUIListener;
import com.izforge.izpack.installer.IUnpacker;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.installer.UnpackerFactory;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerFrame
extends JFrame {
    private static final long serialVersionUID = 3257852069162727473L;
    private static final float JAVA_SPECIFICATION_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    private static final String ICON_RESOURCE = "Installer.image";
    private static final String ICON_RESOURCE_EXT_VARIABLE_NAME = "installerimage.ext";
    private static final String HEADING_ICON_RESOURCE = "Heading.image";
    public LocaleDatabase langpack;
    protected InstallData installdata;
    public IconsDatabase icons;
    protected JPanel panelsContainer;
    protected JPanel contentPane;
    protected JButton helpButton = null;
    protected JButton prevButton;
    protected JButton nextButton;
    protected JButton quitButton;
    protected ArrayList<Integer> visiblePanelMapping;
    protected ArrayList<GUIListener> guiListener;
    protected JLabel[] headingLabels;
    protected JPanel headingPanel;
    protected JComponent headingCounterComponent;
    private JLabel iconLabel;
    private int interruptCount = 1;
    private static final int MAX_INTERRUPT = 3;
    protected RulesEngine rules;
    private static final String CUSTOM_ICONS_RESOURCEFILE = "customicons.xml";
    private VariableSubstitutor substitutor;
    private Debugger debugger;
    private boolean imageLeft = false;
    private InstallerBase parentInstaller;
    private boolean isBack = false;
    private Object usualFTP = null;
    private Object blockFTP = null;

    public InstallerFrame(String string, InstallData installData, InstallerBase installerBase) throws Exception {
        super(string);
        this.parentInstaller = installerBase;
        this.rules = this.parentInstaller.getRules();
        this.substitutor = new VariableSubstitutor(installData.variables);
        this.guiListener = new ArrayList();
        this.visiblePanelMapping = new ArrayList();
        this.installdata = installData;
        this.langpack = installData.langpack;
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
        this.loadIcons();
        this.loadCustomIcons();
        this.loadPanels();
        this.buildGUI();
        this.showFrame();
        this.switchPanel(0);
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    private void loadPanels() throws Exception {
        List list = this.installdata.panelsOrder;
        int n = list.size();
        Class[] classArray = new Class[]{Class.forName("com.izforge.izpack.installer.InstallerFrame"), Class.forName("com.izforge.izpack.installer.InstallData")};
        Object[] objectArray = new Object[]{this, this.installdata};
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            Panel panel = (Panel)list.get(i);
            if (!OsConstraint.oneMatchesCurrentSystem(panel.osConstraints)) continue;
            String string = panel.className;
            String string2 = "com.izforge.izpack.panels.";
            if (string.indexOf(46) > -1) {
                string2 = "";
            }
            Class<?> clazz = Class.forName(string2 + string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            this.installdata.currentPanel = panel;
            Object obj = constructor.newInstance(objectArray);
            IzPanel izPanel = (IzPanel)obj;
            String string3 = panel.getValidator();
            if (string3 != null) {
                izPanel.setValidationService(DataValidatorFactory.createDataValidator(string3));
            }
            izPanel.setHelps(panel.getHelpsMap());
            this.installdata.panels.add(izPanel);
            if (izPanel.isHidden()) {
                this.visiblePanelMapping.add(n4, -1);
            } else {
                this.visiblePanelMapping.add(n4, n2);
                ++n2;
                n3 = n4;
            }
            ++n4;
            XMLElement xMLElement = new XMLElement(string);
            this.installdata.xmlData.addChild(xMLElement);
        }
        this.visiblePanelMapping.add(n4, n3);
    }

    private void loadIcons() throws Exception {
        ImageIcon imageIcon;
        URL uRL;
        XMLElement xMLElement;
        int n;
        this.icons = new IconsDatabase();
        InputStream inputStream = InstallerFrame.class.getResourceAsStream("/com/izforge/izpack/installer/icons.xml");
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        stdXMLParser.setReader(new StdXMLReader(inputStream));
        stdXMLParser.setValidator(new NonValidator());
        XMLElement xMLElement2 = (XMLElement)stdXMLParser.parse();
        Vector<XMLElement> vector = xMLElement2.getChildrenNamed("icon");
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            xMLElement = vector.get(n);
            uRL = InstallerFrame.class.getResource(xMLElement.getAttribute("res"));
            imageIcon = new ImageIcon(uRL);
            this.icons.put(xMLElement.getAttribute("id"), imageIcon);
        }
        vector = xMLElement2.getChildrenNamed("sysicon");
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            xMLElement = vector.get(n);
            uRL = InstallerFrame.class.getResource(xMLElement.getAttribute("res"));
            imageIcon = new ImageIcon(uRL);
            UIManager.put(xMLElement.getAttribute("id"), imageIcon);
        }
    }

    protected void loadCustomIcons() throws Exception {
        ImageIcon imageIcon;
        URL uRL;
        XMLElement xMLElement;
        int n;
        InputStream inputStream = null;
        try {
            inputStream = ResourceManager.getInstance().getInputStream(CUSTOM_ICONS_RESOURCEFILE);
        }
        catch (Throwable throwable) {
            Debug.trace("Resource customicons.xml not defined. No custom icons available.");
            return;
        }
        Debug.trace("Custom icons available.");
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        stdXMLParser.setReader(new StdXMLReader(inputStream));
        stdXMLParser.setValidator(new NonValidator());
        XMLElement xMLElement2 = (XMLElement)stdXMLParser.parse();
        Vector<XMLElement> vector = xMLElement2.getChildrenNamed("icon");
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            xMLElement = vector.get(n);
            uRL = InstallerFrame.class.getResource(xMLElement.getAttribute("res"));
            imageIcon = new ImageIcon(uRL);
            Debug.trace("Icon with id found: " + xMLElement.getAttribute("id"));
            this.icons.put(xMLElement.getAttribute("id"), imageIcon);
        }
        vector = xMLElement2.getChildrenNamed("sysicon");
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            xMLElement = vector.get(n);
            uRL = InstallerFrame.class.getResource(xMLElement.getAttribute("res"));
            imageIcon = new ImageIcon(uRL);
            UIManager.put(xMLElement.getAttribute("id"), imageIcon);
        }
    }

    private void buildGUI() {
        Container container;
        Accessible accessible;
        this.setDefaultCloseOperation(0);
        this.setIconImage(this.icons.getImageIcon("JFrameIcon").getImage());
        JPanel jPanel = (JPanel)this.getGlassPane();
        jPanel.addMouseListener(new MouseAdapter(){});
        jPanel.addMouseMotionListener(new MouseMotionAdapter(){});
        jPanel.addKeyListener(new KeyAdapter(){});
        jPanel.addFocusListener(new FocusAdapter(){});
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.panelsContainer = new JPanel();
        this.panelsContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.panelsContainer.setLayout(new GridLayout(1, 1));
        this.contentPane.add((Component)this.panelsContainer, "Center");
        this.installdata.curPanelNumber = 0;
        IzPanel izPanel = (IzPanel)this.installdata.panels.get(0);
        this.panelsContainer.add(izPanel);
        NavigationHandler navigationHandler = new NavigationHandler();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createTitledBorder(new EtchedLineBorder(), this.langpack.getString("installer.madewith") + " ", 0, 0, new Font("Dialog", 0, 10))));
        this.helpButton = ButtonFactory.createButton(this.langpack.getString("installer.help"), this.icons.getImageIcon("help"), this.installdata.buttonsHColor);
        jPanel2.add(this.helpButton);
        this.helpButton.setName("HelpButton");
        this.helpButton.addActionListener(new HelpHandler());
        jPanel2.add(Box.createHorizontalGlue());
        this.prevButton = ButtonFactory.createButton(this.langpack.getString("installer.prev"), this.icons.getImageIcon("stepback"), this.installdata.buttonsHColor);
        jPanel2.add(this.prevButton);
        this.prevButton.addActionListener(navigationHandler);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.nextButton = ButtonFactory.createButton(this.langpack.getString("installer.next"), this.icons.getImageIcon("stepforward"), this.installdata.buttonsHColor);
        jPanel2.add(this.nextButton);
        this.nextButton.addActionListener(navigationHandler);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.quitButton = ButtonFactory.createButton(this.langpack.getString("installer.quit"), this.icons.getImageIcon("stop"), this.installdata.buttonsHColor);
        jPanel2.add(this.quitButton);
        this.quitButton.addActionListener(navigationHandler);
        this.contentPane.add((Component)jPanel2, "South");
        if (Debug.isTRACE()) {
            this.debugger = new Debugger(this.installdata, this.icons, this.rules);
            accessible = this.debugger.getDebugPanel();
            if (this.installdata.guiPrefs.modifier.containsKey("showDebugWindow") && Boolean.valueOf(this.installdata.guiPrefs.modifier.get("showDebugWindow")).booleanValue()) {
                container = new JFrame("Debug information");
                ((JFrame)container).setContentPane((Container)((Object)accessible));
                ((Window)container).setSize(new Dimension(400, 400));
                ((Window)container).setVisible(true);
            } else {
                ((JComponent)((Object)accessible)).setPreferredSize(new Dimension(200, 400));
                this.contentPane.add((Component)((Object)accessible), "East");
            }
        }
        try {
            accessible = this.loadIcon(ICON_RESOURCE, 0, true);
            if (accessible != null) {
                container = new JPanel();
                container.setLayout(new BorderLayout());
                ((JComponent)container).setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
                this.iconLabel = new JLabel((Icon)((Object)accessible));
                this.iconLabel.setBorder(BorderFactory.createLoweredBevelBorder());
                container.add((Component)this.iconLabel, "North");
                this.contentPane.add((Component)container, "West");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadAndShowImage(0);
        this.getRootPane().setDefaultButton(this.nextButton);
        this.callGUIListener(0, jPanel2);
        this.createHeading(jPanel2);
    }

    private void callGUIListener(int n) {
        this.callGUIListener(n, null);
    }

    private void callGUIListener(int n, Object object) {
        Iterator<GUIListener> iterator = this.guiListener.iterator();
        while (iterator.hasNext()) {
            iterator.next().guiActionPerformed(n, object);
        }
    }

    private ImageIcon loadIcon(String string, int n, boolean bl) throws ResourceNotFoundException, IOException {
        ResourceManager resourceManager = ResourceManager.getInstance();
        ImageIcon imageIcon = null;
        String string2 = this.getIconResourceNameExtension();
        if (bl) {
            try {
                imageIcon = resourceManager.getImageIconResource(string);
            }
            catch (Exception exception) {
                imageIcon = resourceManager.getImageIconResource(string + "." + n + string2);
            }
        } else {
            imageIcon = resourceManager.getImageIconResource(string + "." + n + string2);
        }
        return imageIcon;
    }

    private ImageIcon loadIcon(String string, String string2, boolean bl) throws ResourceNotFoundException, IOException {
        ResourceManager resourceManager = ResourceManager.getInstance();
        ImageIcon imageIcon = null;
        String string3 = this.getIconResourceNameExtension();
        if (bl) {
            try {
                imageIcon = resourceManager.getImageIconResource(string);
            }
            catch (Exception exception) {
                imageIcon = resourceManager.getImageIconResource(string + "." + string2 + string3);
            }
        } else {
            imageIcon = resourceManager.getImageIconResource(string + "." + string2 + string3);
        }
        return imageIcon;
    }

    private String getIconResourceNameExtension() {
        try {
            String string = this.installdata.getVariable(ICON_RESOURCE_EXT_VARIABLE_NAME);
            if (string == null) {
                string = "";
            } else if (string.length() > 0 && string.charAt(0) != '.') {
                string = "." + string;
            }
            string = string.trim();
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void loadAndShowImage(int n) {
        this.loadAndShowImage(this.iconLabel, ICON_RESOURCE, n);
    }

    private void loadAndShowImage(int n, String string) {
        this.loadAndShowImage(this.iconLabel, ICON_RESOURCE, n, string);
    }

    private void loadAndShowImage(JLabel jLabel, String string, int n, String string2) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = this.loadIcon(string, string2, false);
        }
        catch (Exception exception) {
            try {
                imageIcon = this.loadIcon(string, n, false);
            }
            catch (Exception exception2) {
                try {
                    imageIcon = this.loadIcon(string, string2, true);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
        }
        if (imageIcon != null) {
            jLabel.setVisible(false);
            jLabel.setIcon(imageIcon);
            jLabel.setVisible(true);
        }
    }

    private void loadAndShowImage(JLabel jLabel, String string, int n) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = this.loadIcon(string, n, false);
        }
        catch (Exception exception) {
            try {
                imageIcon = this.loadIcon(string, n, true);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (imageIcon != null) {
            jLabel.setVisible(false);
            jLabel.setIcon(imageIcon);
            jLabel.setVisible(true);
        }
    }

    private void showFrame() {
        this.pack();
        this.setSize(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height);
        this.setResizable(this.installdata.guiPrefs.resizable);
        this.centerFrame(this);
        this.setVisible(true);
    }

    protected void switchPanel(int n) {
        this.parentInstaller.refreshDynamicVariables(this.substitutor, this.installdata);
        try {
            Serializable serializable;
            if (this.installdata.curPanelNumber < n) {
                this.isBack = true;
            }
            this.panelsContainer.setVisible(false);
            IzPanel izPanel = (IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber);
            IzPanel izPanel2 = (IzPanel)this.installdata.panels.get(n);
            this.showHelpButton(izPanel.canShowHelp());
            if (Debug.isTRACE()) {
                this.debugger.switchPanel(izPanel.getMetadata(), izPanel2.getMetadata());
            }
            Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: try switching panel from {0} to {1} ({2} to {3})", new String[]{izPanel2.getClass().getName(), izPanel.getClass().getName(), Integer.toString(n), Integer.toString(this.installdata.curPanelNumber)}, "PanelTrace", null);
            if (this.visiblePanelMapping.get(this.installdata.curPanelNumber) == 0) {
                this.prevButton.setVisible(false);
                this.lockPrevButton();
                this.unlockNextButton();
            } else if (this.visiblePanelMapping.get(this.installdata.panels.size()) == this.installdata.curPanelNumber) {
                this.prevButton.setVisible(false);
                this.nextButton.setVisible(false);
                this.lockNextButton();
            } else {
                if (this.hasNavigatePrevious(this.installdata.curPanelNumber, true) != -1) {
                    this.prevButton.setVisible(true);
                    this.unlockPrevButton();
                } else {
                    this.lockPrevButton();
                    this.prevButton.setVisible(false);
                }
                if (this.hasNavigateNext(this.installdata.curPanelNumber, true) != -1) {
                    this.nextButton.setVisible(true);
                    this.unlockNextButton();
                } else {
                    this.lockNextButton();
                    this.nextButton.setVisible(false);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JButton jButton = null;
                    String string = "next";
                    if (InstallerFrame.this.nextButton.isEnabled()) {
                        jButton = InstallerFrame.this.nextButton;
                        InstallerFrame.this.quitButton.setDefaultCapable(false);
                        InstallerFrame.this.prevButton.setDefaultCapable(false);
                        InstallerFrame.this.nextButton.setDefaultCapable(true);
                    } else if (InstallerFrame.this.quitButton.isEnabled()) {
                        jButton = InstallerFrame.this.quitButton;
                        string = "quit";
                        InstallerFrame.this.quitButton.setDefaultCapable(true);
                        InstallerFrame.this.prevButton.setDefaultCapable(false);
                        InstallerFrame.this.nextButton.setDefaultCapable(false);
                    }
                    InstallerFrame.this.getRootPane().setDefaultButton(jButton);
                    Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: setting {0} as default button", new String[]{string}, "PanelTrace", null);
                }
            });
            this.panelsContainer.remove(izPanel2);
            izPanel2.panelDeactivate();
            this.panelsContainer.add(izPanel);
            if (izPanel.getInitialFocus() != null) {
                JTextComponent jTextComponent;
                serializable = izPanel.getInitialFocus();
                if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
                    ((Component)serializable).requestFocus();
                } else {
                    SwingUtilities.invokeLater(new Runnable((Component)serializable){
                        final /* synthetic */ Component val$inFoc;
                        {
                            this.val$inFoc = component;
                        }

                        public void run() {
                            this.val$inFoc.requestFocusInWindow();
                        }
                    });
                }
                if (serializable instanceof JTextComponent && (jTextComponent = (JTextComponent)serializable).isEditable() && jTextComponent.getDocument() != null) {
                    jTextComponent.setCaretPosition(jTextComponent.getDocument().getLength());
                }
            }
            this.performHeading(izPanel);
            this.performHeadingCounter(izPanel);
            izPanel.panelActivate();
            this.panelsContainer.setVisible(true);
            serializable = izPanel.getMetadata();
            if (serializable != null && !"UNKNOWN".equals(((Panel)serializable).getPanelid())) {
                this.loadAndShowImage(this.visiblePanelMapping.get(this.installdata.curPanelNumber), ((Panel)serializable).getPanelid());
            } else {
                this.loadAndShowImage(this.visiblePanelMapping.get(this.installdata.curPanelNumber));
            }
            this.isBack = false;
            this.callGUIListener(3);
            Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: switched", null, "PanelTrace", null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeUninstallData() {
        Object object;
        Object object2;
        String string = this.installdata.getVariable("InstallerFrame.logfilePath");
        BufferedWriter bufferedWriter = null;
        if (string != null) {
            if (string.toLowerCase().startsWith("default")) {
                string = "$INSTALL_PATH/Uninstaller/install.log";
            }
            if (!((File)(object2 = new File(string = IoHelper.translatePath(string, new VariableSubstitutor(this.installdata.getVariables()))))).getParentFile().exists()) {
                ((File)object2).getParentFile().mkdirs();
            }
            object = null;
            try {
                object = new FileOutputStream((File)object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Debug.trace("Cannot create logfile!");
                Debug.error(fileNotFoundException);
            }
            if (object != null) {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
            }
        }
        try {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            object2 = this.installdata.getVariable("UNINSTALLER_CONDITION");
            if (object2 != null && !RulesEngine.getCondition((String)object2).isTrue()) {
                return;
            }
            object = UninstallData.getInstance();
            List list = ((UninstallData)object).getUninstalableFilesList();
            ZipOutputStream zipOutputStream = this.installdata.uninstallOutJar;
            if (zipOutputStream == null) {
                return;
            }
            zipOutputStream.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter bufferedWriter2 = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            bufferedWriter2.write(this.installdata.getInstallPath());
            bufferedWriter2.newLine();
            Iterator iterator = list.iterator();
            if (bufferedWriter != null) {
                while (iterator.hasNext()) {
                    object8 = (String)iterator.next();
                    bufferedWriter2.write((String)object8);
                    bufferedWriter.write((String)object8);
                    if (!iterator.hasNext()) continue;
                    bufferedWriter2.newLine();
                    bufferedWriter.newLine();
                }
                bufferedWriter2.flush();
                bufferedWriter.flush();
                bufferedWriter.close();
            } else {
                while (iterator.hasNext()) {
                    bufferedWriter2.write((String)iterator.next());
                    if (!iterator.hasNext()) continue;
                    bufferedWriter2.newLine();
                }
                bufferedWriter2.flush();
            }
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("jarlocation.log"));
            bufferedWriter2 = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            bufferedWriter2.write(((UninstallData)object).getUninstallerJarFilename());
            bufferedWriter2.newLine();
            bufferedWriter2.write(((UninstallData)object).getUninstallerPath());
            bufferedWriter2.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("executables"));
            object8 = new ObjectOutputStream(zipOutputStream);
            iterator = ((UninstallData)object).getExecutablesList().iterator();
            ((ObjectOutputStream)object8).writeInt(((UninstallData)object).getExecutablesList().size());
            while (iterator.hasNext()) {
                object7 = (ExecutableFile)iterator.next();
                ((ObjectOutputStream)object8).writeObject(object7);
            }
            ((ObjectOutputStream)object8).flush();
            zipOutputStream.closeEntry();
            object7 = ((UninstallData)object).getAdditionalData();
            if (object7 != null && !object7.isEmpty()) {
                object6 = object7.keySet().iterator();
                object5 = new HashSet();
                while (object6 != null && object6.hasNext()) {
                    int n;
                    Object object9;
                    long l;
                    Object object10;
                    Object object11;
                    object4 = (String)object6.next();
                    Object v = object7.get(object4);
                    if ("__uninstallLibs__".equals(object4)) {
                        object3 = ((List)v).iterator();
                        while (object3 != null && object3.hasNext()) {
                            object11 = (String)((List)object3.next()).get(0);
                            object10 = new byte[5120];
                            l = 0L;
                            zipOutputStream.putNextEntry(new ZipEntry("native/" + (String)object11));
                            object9 = this.getClass().getResourceAsStream("/native/" + (String)object11);
                            while ((n = ((InputStream)object9).read((byte[])object10)) != -1) {
                                zipOutputStream.write((byte[])object10, 0, n);
                                l += (long)n;
                            }
                            zipOutputStream.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(object4) || "uninstallerJars".equals(object4)) {
                        object3 = new ArrayList();
                        object11 = ((List)v).iterator();
                        while (object11.hasNext()) {
                            object10 = new byte[5120];
                            l = 0L;
                            object9 = (CustomData)object11.next();
                            if (((CustomData)object9).listenerName != null) {
                                ((ArrayList)object3).add(((CustomData)object9).listenerName);
                            }
                            for (String string2 : ((CustomData)object9).contents) {
                                if (((HashSet)object5).contains(string2)) continue;
                                ((HashSet)object5).add(string2);
                                try {
                                    zipOutputStream.putNextEntry(new ZipEntry(string2));
                                }
                                catch (ZipException zipException) {
                                    Debug.trace("ZipException in writing custom data: " + zipException.getMessage());
                                    continue;
                                }
                                InputStream inputStream = this.getClass().getResourceAsStream("/" + string2);
                                if (inputStream != null) {
                                    while ((n = inputStream.read((byte[])object10)) != -1) {
                                        zipOutputStream.write((byte[])object10, 0, n);
                                        l += (long)n;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + string2);
                                }
                                zipOutputStream.closeEntry();
                            }
                        }
                        zipOutputStream.putNextEntry(new ZipEntry((String)object4));
                        object10 = new ObjectOutputStream(zipOutputStream);
                        ((ObjectOutputStream)object10).writeObject(object3);
                        ((ObjectOutputStream)object10).flush();
                        zipOutputStream.closeEntry();
                        continue;
                    }
                    zipOutputStream.putNextEntry(new ZipEntry((String)object4));
                    if (v instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)v).writeTo(zipOutputStream);
                    } else {
                        object3 = new ObjectOutputStream(zipOutputStream);
                        ((ObjectOutputStream)object3).writeObject(v);
                        ((ObjectOutputStream)object3).flush();
                    }
                    zipOutputStream.closeEntry();
                }
            }
            object6 = ((UninstallData)object).getUninstallScripts();
            object5 = ((ArrayList)object6).iterator();
            int n = 0;
            while (object5.hasNext()) {
                zipOutputStream.putNextEntry(new ZipEntry("rootscript" + Integer.toString(n)));
                object4 = new ObjectOutputStream(zipOutputStream);
                object3 = (String)object5.next();
                ((ObjectOutputStream)object4).writeUTF((String)object3);
                ((ObjectOutputStream)object4).flush();
                zipOutputStream.closeEntry();
                ++n;
            }
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public InputStream getResource(String string) throws Exception {
        String string2 = "";
        ResourceManager resourceManager = null;
        try {
            resourceManager = ResourceManager.getInstance();
            string2 = resourceManager.resourceBasePath;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string2 + string);
        if (inputStream == null) {
            throw new ResourceNotFoundException("Warning: Resource not found: " + string);
        }
        return inputStream;
    }

    public void centerFrame(Window window) {
        Point point = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension dimension = window.getSize();
        window.setLocation(point.x - dimension.width / 2, point.y - dimension.height / 2 - 10);
    }

    public Dimension getPanelsContainerSize() {
        return this.panelsContainer.getSize();
    }

    public void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public void exit() {
        if (!(!this.installdata.canClose && (this.nextButton.isVisible() && this.nextButton.isEnabled() || this.prevButton.isVisible() && this.prevButton.isEnabled()))) {
            this.writeUninstallData();
            Housekeeper.getInstance().shutDown(0);
        } else {
            VariableSubstitutor variableSubstitutor;
            int n;
            if (Unpacker.isDiscardInterrupt() && this.interruptCount < 3) {
                ++this.interruptCount;
                return;
            }
            String string = this.langpack.getString("installer.quit.reversemessage");
            String string2 = this.langpack.getString("installer.quit.reversetitle");
            if (string.indexOf("installer.quit.reversemessage") > -1) {
                string = this.langpack.getString("installer.quit.message");
            }
            if (string2.indexOf("installer.quit.reversetitle") > -1) {
                string2 = this.langpack.getString("installer.quit.title");
            }
            if ((n = JOptionPane.showConfirmDialog(this, string = (variableSubstitutor = new VariableSubstitutor(this.installdata.getVariables())).substitute(string, null), string2 = variableSubstitutor.substitute(string2, null), 0)) == 0) {
                this.wipeAborted();
                Housekeeper.getInstance().shutDown(0);
            }
        }
    }

    protected void wipeAborted() {
        if (!Unpacker.interruptAll(40000L)) {
            return;
        }
        UninstallData uninstallData = UninstallData.getInstance();
        for (String string : uninstallData.getInstalledFilesList()) {
            File file = new File(string);
            file.delete();
        }
    }

    public void install(AbstractUIProgressHandler abstractUIProgressHandler) {
        IUnpacker iUnpacker = UnpackerFactory.getUnpacker(this.installdata.info.getUnpackerClassName(), this.installdata, abstractUIProgressHandler);
        iUnpacker.setRules(this.rules);
        Thread thread = new Thread((Runnable)iUnpacker, "IzPack - Unpacker thread");
        thread.start();
    }

    public void writeXMLTree(XMLElement xMLElement, OutputStream outputStream) throws Exception {
        XMLWriter xMLWriter = new XMLWriter(outputStream);
        for (int i = 0; i < this.installdata.panels.size(); ++i) {
            IzPanel izPanel = (IzPanel)this.installdata.panels.get(i);
            izPanel.makeXMLData(this.installdata.xmlData.getChildAtIndex(i));
        }
        xMLWriter.write(this.installdata.xmlData);
    }

    public void setQuitButtonText(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = this.langpack.getString("installer.quit");
        }
        this.quitButton.setText(string2);
    }

    public void setQuitButtonIcon(String string) {
        String string2 = this.installdata.guiPrefs.modifier.get("useButtonIcons");
        if (string2 == null || "yes".equalsIgnoreCase(string2)) {
            this.quitButton.setIcon(this.icons.getImageIcon(string));
        }
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        if (this.usualFTP == null) {
            this.usualFTP = this.getFocusTraversalPolicy();
        }
        if (this.blockFTP == null) {
            this.blockFTP = new BlockFocusTraversalPolicy();
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.blockFTP);
        this.getGlassPane().requestFocus();
        this.callGUIListener(1);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.usualFTP);
        this.callGUIListener(2);
    }

    public void lockPrevButton() {
        this.prevButton.setEnabled(false);
    }

    public void lockNextButton() {
        this.nextButton.setEnabled(false);
    }

    public void unlockPrevButton() {
        this.prevButton.setEnabled(true);
    }

    public void unlockNextButton() {
        this.unlockNextButton(true);
    }

    public void unlockNextButton(boolean bl) {
        this.nextButton.setEnabled(true);
        if (bl) {
            this.nextButton.requestFocusInWindow();
            this.getRootPane().setDefaultButton(this.nextButton);
            if (this.getFocusOwner() != null) {
                Debug.trace("Current focus owner: " + this.getFocusOwner().getName());
            }
            if (this.getRootPane().getDefaultButton() != this.nextButton) {
                Debug.trace("Next button not default button, setting...");
                this.quitButton.setDefaultCapable(false);
                this.prevButton.setDefaultCapable(false);
                this.nextButton.setDefaultCapable(true);
                this.getRootPane().setDefaultButton(this.nextButton);
            }
        }
    }

    public void skipPanel() {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            if (this.isBack) {
                this.navigatePrevious(this.installdata.curPanelNumber);
            } else {
                this.navigateNext(this.installdata.curPanelNumber, false);
            }
        }
    }

    public boolean canShow(int n) {
        IzPanel izPanel = (IzPanel)this.installdata.panels.get(n);
        Panel panel = izPanel.getMetadata();
        String string = panel.getPanelid();
        Debug.trace("Current Panel: " + string);
        if (panel.hasCondition()) {
            Debug.log("Checking panelcondition");
            return this.rules.isConditionTrue(panel.getCondition());
        }
        if (!this.rules.canShowPanel(string, this.installdata.variables)) {
            Debug.log("Skip panel with panelid=" + string);
            return false;
        }
        return true;
    }

    public void navigateNext() {
        if (!this.nextButton.isEnabled()) {
            return;
        }
        this.navigateNext(this.installdata.curPanelNumber, true);
    }

    public void navigateNext(int n, boolean bl) {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            boolean bl2;
            boolean bl3 = bl2 = bl ? ((IzPanel)this.installdata.panels.get(n)).panelValidated() : true;
            if (!bl2) {
                return;
            }
            int n2 = this.hasNavigateNext(n, false);
            if (-1 != n2) {
                this.installdata.curPanelNumber = n2;
                this.switchPanel(n);
            }
        }
    }

    public int hasNavigateNext(int n, boolean bl) {
        int n2 = -1;
        for (int i = n + 1; n2 == -1 && i < this.installdata.panels.size(); ++i) {
            if (bl && this.visiblePanelMapping.get(i) == -1 || !this.canShow(i)) continue;
            n2 = i;
        }
        return n2;
    }

    public int hasNavigatePrevious(int n, boolean bl) {
        int n2 = -1;
        for (int i = n - 1; n2 == -1 && i >= 0; --i) {
            if (bl && this.visiblePanelMapping.get(i) == -1 || !this.canShow(i)) continue;
            n2 = i;
        }
        return n2;
    }

    public void navigatePrevious() {
        if (!this.prevButton.isEnabled()) {
            return;
        }
        this.navigatePrevious(this.installdata.curPanelNumber);
    }

    public void navigatePrevious(int n) {
        int n2 = this.hasNavigatePrevious(n, false);
        if (-1 != n2) {
            this.installdata.curPanelNumber = n2;
            this.switchPanel(n);
        }
    }

    public void showHelp() {
        ((IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber)).showHelp();
    }

    public List<GUIListener> getGuiListener() {
        return this.guiListener;
    }

    public void addGuiListener(GUIListener gUIListener) {
        this.guiListener.add(gUIListener);
    }

    private void createHeadingLabels(int n, Color color) {
        float f;
        this.headingLabels = new JLabel[n + 1];
        this.headingLabels[0] = new JLabel("");
        this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(1));
        Color color2 = null;
        if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
            color2 = Color.decode(this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
            this.headingLabels[0].setForeground(color2);
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingFontSize") && (double)(f = Float.parseFloat(this.installdata.guiPrefs.modifier.get("headingFontSize"))) > 0.0 && (double)f <= 5.0) {
            float f2 = this.headingLabels[0].getFont().getSize2D();
            this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(f2 * f));
        }
        if (this.imageLeft) {
            this.headingLabels[0].setAlignmentX(1.0f);
        }
        for (int i = 1; i < n; ++i) {
            this.headingLabels[i] = new JLabel();
            if (this.imageLeft) {
                this.headingLabels[i].setAlignmentX(1.0f);
                continue;
            }
            this.headingLabels[i].setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 8));
        }
    }

    private void createHeadingCounter(Color color, JPanel jPanel, JPanel jPanel2) {
        String string = "inHeading";
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounterPos")) {
            string = this.installdata.guiPrefs.modifier.get("headingPanelCounterPos");
        }
        if (jPanel2 == null && "inHeading".equalsIgnoreCase(string)) {
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounter")) {
            Component[] componentArray;
            this.headingCounterComponent = null;
            if ("progressbar".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                componentArray = new JProgressBar();
                componentArray.setStringPainted(true);
                componentArray.setString("");
                componentArray.setValue(0);
                this.headingCounterComponent = componentArray;
                if (this.imageLeft) {
                    this.headingCounterComponent.setAlignmentX(1.0f);
                }
            } else if ("text".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                componentArray = new JLabel(" ");
                this.headingCounterComponent = componentArray;
                if (this.imageLeft) {
                    this.headingCounterComponent.setAlignmentX(1.0f);
                } else {
                    this.headingCounterComponent.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
                }
                Color color2 = null;
                if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
                    color2 = Color.decode(this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
                    componentArray.setForeground(color2);
                }
            }
            if ("inHeading".equals(string)) {
                jPanel2.add(this.headingCounterComponent);
            } else if ("inNavigationPanel".equals(string)) {
                int n;
                componentArray = jPanel.getComponents();
                for (n = 0; n < componentArray.length && !componentArray[n].equals(this.prevButton); ++n) {
                }
                if (n <= componentArray.length) {
                    jPanel.add(Box.createHorizontalGlue(), n);
                    jPanel.add((Component)this.headingCounterComponent, n);
                }
            }
        }
    }

    private JPanel createHeadingIcon(Color color) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = this.loadIcon(HEADING_ICON_RESOURCE, 0, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        int n = 8;
        if (this.installdata.guiPrefs.modifier.containsKey("headingImageBorderSize")) {
            n = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingImageBorderSize"));
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        if (color != null) {
            jPanel.setBackground(color);
        }
        JLabel jLabel = new JLabel(imageIcon);
        if (this.imageLeft) {
            jPanel.add((Component)jLabel, "West");
        } else {
            jPanel.add((Component)jLabel, "East");
        }
        this.headingLabels[this.headingLabels.length - 1] = jLabel;
        return jPanel;
    }

    private void createHeading(JPanel jPanel) {
        this.headingPanel = null;
        int n = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            n = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        Color color = null;
        int n2 = 0;
        if (this.installdata.guiPrefs.modifier.containsKey("headingBackgroundColor")) {
            color = Color.decode(this.installdata.guiPrefs.modifier.get("headingBackgroundColor"));
        }
        if (!this.isHeading(null)) {
            this.createHeadingCounter(color, jPanel, null);
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingImageOnLeft") && (this.installdata.guiPrefs.modifier.get("headingImageOnLeft").equalsIgnoreCase("yes") || this.installdata.guiPrefs.modifier.get("headingImageOnLeft").equalsIgnoreCase("true"))) {
            this.imageLeft = true;
        }
        this.createHeadingLabels(n, color);
        JPanel jPanel2 = new JPanel();
        if (color != null) {
            jPanel2.setBackground(color);
        }
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        if (this.imageLeft) {
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        }
        for (n2 = 0; n2 < n; ++n2) {
            jPanel2.add(this.headingLabels[n2]);
        }
        this.createHeadingCounter(color, jPanel, jPanel2);
        JPanel jPanel3 = this.createHeadingIcon(color);
        JPanel jPanel4 = new JPanel();
        if (color != null) {
            jPanel4.setBackground(color);
        }
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        if (this.imageLeft) {
            jPanel4.add(jPanel3);
            jPanel4.add(Box.createHorizontalGlue());
            jPanel4.add(jPanel2);
        } else {
            jPanel4.add(jPanel2);
            jPanel4.add(Box.createHorizontalGlue());
            jPanel4.add(jPanel3);
        }
        this.headingPanel = new JPanel(new BorderLayout());
        this.headingPanel.add(jPanel4);
        this.headingPanel.add((Component)new JSeparator(), "South");
        this.contentPane.add((Component)this.headingPanel, "North");
    }

    public boolean isHeading(IzPanel izPanel) {
        if (!this.installdata.guiPrefs.modifier.containsKey("useHeadingPanel") || !this.installdata.guiPrefs.modifier.get("useHeadingPanel").equalsIgnoreCase("yes")) {
            return false;
        }
        if (izPanel == null) {
            return true;
        }
        return izPanel.getI18nStringForClass("headline", null) != null;
    }

    private void performHeading(IzPanel izPanel) {
        int n;
        int n2 = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            n2 = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        if (this.headingLabels == null) {
            return;
        }
        String string = izPanel.getI18nStringForClass("headline");
        if (string == null) {
            this.headingPanel.setVisible(false);
            return;
        }
        for (n = 0; n <= n2; ++n) {
            if (this.headingLabels[n] == null) continue;
            this.headingLabels[n].setVisible(false);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string2 = izPanel.getI18nStringForClass("headinfo" + Integer.toString(n));
            if (string2 == null) {
                string2 = " ";
            }
            if (string2.endsWith(":")) {
                string2 = string2.substring(0, string2.length() - 1) + ".";
            }
            this.headingLabels[n + 1].setText(string2);
            this.headingLabels[n + 1].setVisible(true);
        }
        this.headingLabels[0].setText(string);
        this.headingLabels[0].setVisible(true);
        int n3 = this.visiblePanelMapping.get(this.installdata.curPanelNumber);
        if (this.headingLabels[n2] != null) {
            this.loadAndShowImage(this.headingLabels[n2], HEADING_ICON_RESOURCE, n3);
            this.headingLabels[n2].setVisible(true);
        }
        this.headingPanel.setVisible(true);
    }

    private void performHeadingCounter(IzPanel izPanel) {
        if (this.headingCounterComponent != null) {
            int n = this.visiblePanelMapping.get(this.installdata.curPanelNumber);
            int n2 = this.visiblePanelMapping.get(this.visiblePanelMapping.get(this.installdata.panels.size()));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.langpack.getString("installer.step")).append(" ").append(n + 1).append(" ").append(this.langpack.getString("installer.of")).append(" ").append(n2 + 1);
            if (this.headingCounterComponent instanceof JProgressBar) {
                JProgressBar jProgressBar = (JProgressBar)this.headingCounterComponent;
                jProgressBar.setMaximum(n2 + 1);
                jProgressBar.setValue(n + 1);
                jProgressBar.setString(stringBuffer.toString());
            } else {
                ((JLabel)this.headingCounterComponent).setText(stringBuffer.toString());
            }
        }
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public void setRules(RulesEngine rulesEngine) {
        this.rules = rulesEngine;
    }

    private void showHelpButton(boolean bl) {
        if (this.helpButton == null) {
            return;
        }
        this.helpButton.setVisible(bl);
    }

    private class BlockFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        private static final long serialVersionUID = 3258413928261169209L;

        private BlockFocusTraversalPolicy() {
        }

        protected boolean accept(Component component) {
            return component == InstallerFrame.this.getGlassPane();
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            InstallerFrame.this.exit();
        }
    }

    class HelpHandler
    implements ActionListener {
        HelpHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InstallerFrame.this.showHelp();
        }
    }

    class NavigationHandler
    implements ActionListener {
        NavigationHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == InstallerFrame.this.prevButton) {
                InstallerFrame.this.navigatePrevious();
            } else if (object == InstallerFrame.this.nextButton) {
                InstallerFrame.this.navigateNext();
            } else if (object == InstallerFrame.this.quitButton) {
                InstallerFrame.this.exit();
            }
        }
    }
}

