/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

public class AutomatedInstaller
extends InstallerBase {
    private TreeMap<String, Integer> panelInstanceCount;
    private AutomatedInstallData idata = new AutomatedInstallData();
    private boolean result = false;

    public AutomatedInstaller(String string) throws Exception {
        File file = new File(string);
        this.loadInstallData(this.idata);
        this.idata.xmlData = this.getXMLData(file);
        this.idata.localeISO3 = this.idata.xmlData.getAttribute("langpack", "eng");
        InputStream inputStream = this.getClass().getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        this.idata.langpack = new LocaleDatabase(inputStream);
        this.idata.setVariable("ISO3_LANG", this.idata.localeISO3);
        ResourceManager.create(this.idata);
        this.addCustomLangpack(this.idata);
        this.panelInstanceCount = new TreeMap();
        this.loadConditions(this.idata);
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
    }

    private boolean writeUninstallData() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            UninstallData uninstallData = UninstallData.getInstance();
            List list = uninstallData.getUninstalableFilesList();
            ZipOutputStream zipOutputStream = this.idata.uninstallOutJar;
            if (zipOutputStream == null) {
                return true;
            }
            System.out.println("[ Writing the uninstaller data ... ]");
            zipOutputStream.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            bufferedWriter.write(this.idata.getInstallPath());
            bufferedWriter.newLine();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                bufferedWriter.write((String)iterator.next());
                if (!iterator.hasNext()) continue;
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("jarlocation.log"));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            bufferedWriter.write(uninstallData.getUninstallerJarFilename());
            bufferedWriter.newLine();
            bufferedWriter.write(uninstallData.getUninstallerPath());
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
            iterator = uninstallData.getExecutablesList().iterator();
            objectOutputStream.writeInt(uninstallData.getExecutablesList().size());
            while (iterator.hasNext()) {
                object5 = (ExecutableFile)iterator.next();
                objectOutputStream.writeObject(object5);
            }
            objectOutputStream.flush();
            zipOutputStream.closeEntry();
            object5 = uninstallData.getAdditionalData();
            if (object5 != null && !object5.isEmpty()) {
                object4 = object5.keySet().iterator();
                object3 = new HashSet();
                while (object4 != null && object4.hasNext()) {
                    int n;
                    Object object6;
                    long l;
                    Object object7;
                    Object object8;
                    object2 = (String)object4.next();
                    Object v = object5.get(object2);
                    if ("__uninstallLibs__".equals(object2)) {
                        object = ((List)v).iterator();
                        while (object != null && object.hasNext()) {
                            object8 = (String)((List)object.next()).get(0);
                            object7 = new byte[5120];
                            l = 0L;
                            zipOutputStream.putNextEntry(new ZipEntry("native/" + (String)object8));
                            object6 = this.getClass().getResourceAsStream("/native/" + (String)object8);
                            while ((n = ((InputStream)object6).read((byte[])object7)) != -1) {
                                zipOutputStream.write((byte[])object7, 0, n);
                                l += (long)n;
                            }
                            zipOutputStream.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(object2) || "uninstallerJars".equals(object2)) {
                        object = new ArrayList();
                        object8 = ((List)v).iterator();
                        while (object8.hasNext()) {
                            object7 = new byte[5120];
                            l = 0L;
                            object6 = (CustomData)object8.next();
                            if (((CustomData)object6).listenerName != null) {
                                ((ArrayList)object).add(((CustomData)object6).listenerName);
                            }
                            for (String string : ((CustomData)object6).contents) {
                                if (((HashSet)object3).contains(string)) continue;
                                ((HashSet)object3).add(string);
                                try {
                                    zipOutputStream.putNextEntry(new ZipEntry(string));
                                }
                                catch (ZipException zipException) {
                                    Debug.trace("ZipException in writing custom data: " + zipException.getMessage());
                                    continue;
                                }
                                InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
                                if (inputStream != null) {
                                    while ((n = inputStream.read((byte[])object7)) != -1) {
                                        zipOutputStream.write((byte[])object7, 0, n);
                                        l += (long)n;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + string);
                                }
                                zipOutputStream.closeEntry();
                            }
                        }
                        zipOutputStream.putNextEntry(new ZipEntry((String)object2));
                        object7 = new ObjectOutputStream(zipOutputStream);
                        ((ObjectOutputStream)object7).writeObject(object);
                        ((ObjectOutputStream)object7).flush();
                        zipOutputStream.closeEntry();
                        continue;
                    }
                    zipOutputStream.putNextEntry(new ZipEntry((String)object2));
                    if (v instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)v).writeTo(zipOutputStream);
                    } else {
                        object = new ObjectOutputStream(zipOutputStream);
                        ((ObjectOutputStream)object).writeObject(v);
                        ((ObjectOutputStream)object).flush();
                    }
                    zipOutputStream.closeEntry();
                }
            }
            object4 = uninstallData.getUninstallScripts();
            object3 = ((ArrayList)object4).iterator();
            int n = 0;
            while (object3.hasNext()) {
                zipOutputStream.putNextEntry(new ZipEntry("rootscript" + Integer.toString(n)));
                object2 = new ObjectOutputStream(zipOutputStream);
                object = (String)object3.next();
                ((ObjectOutputStream)object2).writeUTF((String)object);
                ((ObjectOutputStream)object2).flush();
                zipOutputStream.closeEntry();
            }
            zipOutputStream.flush();
            zipOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doInstall() throws Exception {
        if (!this.checkInstallerRequirements(this.idata)) {
            Debug.log("not all installerconditions are fulfilled.");
            return;
        }
        System.out.println("[ Starting automated installation ]");
        Debug.log("[ Starting automated installation ]");
        try {
            this.result = true;
lbl8:
            // 5 sources

            for (Panel var2_3 : this.idata.panelsOrder) {
                var3_4 = "com.izforge.izpack.panels.";
                if (var2_3.className.compareTo(".") > -1) {
                    var3_4 = "";
                }
                if (!OsConstraint.oneMatchesCurrentSystem(var2_3.osConstraints)) continue;
                var4_5 = var2_3.className;
                var5_6 = var3_4 + var4_5 + "AutomationHelper";
                var6_7 = null;
                Debug.log("AutomationHelper:" + var5_6);
                try {
                    var6_7 = Class.forName(var5_6);
                }
                catch (ClassNotFoundException var7_9) {
                    Debug.log("ClassNotFoundException-skip :" + var5_6);
                    this.validatePanel(var2_3);
                    continue;
                }
                var7_8 = null;
                if (var6_7 != null) {
                    try {
                        Debug.log("Instantiate :" + var5_6);
                        var7_8 = (PanelAutomation)var6_7.newInstance();
                    }
                    catch (Exception var8_11) {
                        Debug.log("ERROR: no default constructor for " + var5_6 + ", skipping...");
                        this.validatePanel(var2_3);
                        continue;
                    }
                }
                var8_10 = this.idata.xmlData.getChildrenNamed(var4_5);
                var9_12 = 0;
                if (this.panelInstanceCount.containsKey(var4_5)) {
                    var9_12 = this.panelInstanceCount.get(var4_5);
                }
                var10_13 = var8_10.elementAt(var9_12);
                this.panelInstanceCount.put(var4_5, var9_12 + 1);
                if (var7_8 == null) ** GOTO lbl66
                try {
                    Debug.log("automationHelperInstance.runAutomated :" + var5_6 + " entered.");
                    if (var7_8.runAutomated(this.idata, var10_13)) ** GOTO lbl-1000
                    this.result = false;
                    ** GOTO lbl63
                }
                catch (Exception var11_14) {
                    Debug.log("ERROR: automated installation failed for panel " + var4_5);
                    var11_14.printStackTrace();
                    this.result = false;
                    ** GOTO lbl66
                }
            }
            ** GOTO lbl68
        }
        catch (Exception var1_2) {
            try {
                this.result = false;
                System.err.println(var1_2.toString());
                var1_2.printStackTrace();
                System.out.println("[ Automated installation FAILED! ]");
            }
            catch (Throwable var12_15) {
                Housekeeper.getInstance().shutDown(this.result != false ? 0 : 1);
                throw var12_15;
            }
lbl63:
            // 1 sources

            Housekeeper.getInstance().shutDown(this.result != false ? 0 : 1);
            return;
lbl-1000:
            // 1 sources

            {
                Debug.log("automationHelperInstance.runAutomated :" + var5_6 + " successfully done.");
            }
lbl66:
            // 3 sources

            this.validatePanel(var2_3);
            ** GOTO lbl8
lbl68:
            // 1 sources

            this.writeUninstallData();
            if (this.result) {
                System.out.println("[ Automated installation done ]");
            } else {
                System.out.println("[ Automated installation FAILED! ]");
            }
            Housekeeper.getInstance().shutDown(this.result != false ? 0 : 1);
            return;
            Housekeeper.getInstance().shutDown(this.result != false ? 0 : 1);
            return;
        }
    }

    private void validatePanel(Panel panel) throws InstallerException {
        DataValidator dataValidator;
        DataValidator.Status status;
        String string = panel.getValidator();
        if (string != null && (status = (dataValidator = DataValidatorFactory.createDataValidator(string)).validateData(this.idata)) != DataValidator.Status.OK) {
            this.result = false;
            if (status == DataValidator.Status.WARNING && dataValidator.getDefaultAnswer()) {
                System.out.println("Configuration said, it's ok to go on, if validation is not successfull");
                this.result = true;
                return;
            }
            throw new InstallerException("Validating data was not successfull");
        }
    }

    public XMLElement getXMLData(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        stdXMLParser.setReader(new StdXMLReader(fileInputStream));
        stdXMLParser.setValidator(new NonValidator());
        XMLElement xMLElement = (XMLElement)stdXMLParser.parse();
        fileInputStream.close();
        return xMLElement;
    }

    public boolean getResult() {
        return this.result;
    }
}

