/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.ScalaObject;
import scala.StringBuilder;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxesRunTime;

public abstract class ApproximateNumeric
extends Numeric
implements ScalaObject {
    private final int nativeTypeId;

    public ApproximateNumeric(int nativeTypeId) {
        this.nativeTypeId = nativeTypeId;
        super(nativeTypeId);
    }

    public String sqlString() {
        block5: {
            String string;
            int n = this.precisionRadix();
            int n2 = this.precision();
            switch (n) {
                default: {
                    throw new UnsupportedFeature("SQL-99 does not support the precision of an approximate numeric type to be defined in a radix other than 2 or 10");
                }
                case 10: {
                    string = new StringBuilder().append((Object)"FLOAT (").append((Object)((Object)BoxesRunTime.boxToInteger((int)n2)).toString()).append((Object)")").toString();
                    break;
                }
                case 2: {
                    if (n2 == 64) {
                        string = "REAL";
                        break;
                    }
                    if (n2 != 128) break block5;
                    string = "DOUBLE PRECISION";
                }
            }
            return string;
        }
        throw new UnsupportedFeature("SQL-99 does not support an approximate numeric type with a binary defined precision other than 16, 32 and 64 bits");
    }

    public boolean isSubtypeOf(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ApproximateNumeric) {
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric dt = approximateNumeric = (ApproximateNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() <= dt.precision() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isEquivalent(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ApproximateNumeric) {
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric dt = approximateNumeric = (ApproximateNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() == dt.precision() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

