/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.nest;

import java.io.File;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.tools.nsc.Settings;

public class TestFile
implements ScalaObject {
    private final File checkFile;
    private final File logFile;
    private final String fileBase;
    private final String dirpath;
    private final File dir;
    private final File file;
    private final String kind;

    public TestFile(String kind, File file) {
        this.kind = kind;
        this.file = file;
        this.dir = file.getParentFile();
        this.dirpath = this.dir().getAbsolutePath();
        this.fileBase = this.basename(file.getName());
        this.logFile = new File(this.dir(), this.fileBase() + "-" + kind + ".log");
        File chkFile = new File(this.dir(), this.fileBase() + ".check");
        this.checkFile = chkFile.isFile() ? chkFile : new File(this.dir(), this.fileBase() + "-" + kind + ".check");
    }

    public String toString() {
        return this.kind + " " + this.file();
    }

    private String basename(String name) {
        int inx = name.lastIndexOf(".");
        return inx < 0 ? name : name.substring(0, inx);
    }

    public void defineSettings(Settings settings) {
        this.baseSettings(settings);
    }

    public void baseSettings(Settings settings) {
        settings.classpath().value_$eq(this.dirpath());
        Settings.StringSetting stringSetting = settings.outdir();
        File outDir = new File(this.dir(), this.fileBase() + "-" + this.kind + ".obj");
        if (!outDir.exists()) {
            outDir.mkdir();
        }
        stringSetting.value_$eq(outDir.toString());
    }

    public File checkFile() {
        return this.checkFile;
    }

    public File logFile() {
        return this.logFile;
    }

    public String fileBase() {
        return this.fileBase;
    }

    public String dirpath() {
        return this.dirpath;
    }

    public File dir() {
        return this.dir;
    }

    public File file() {
        return this.file;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

