/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest.nest;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import scala.Console$;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.Tuple2;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.tools.partest.nest.FileManager;
import scala.tools.partest.nest.FileManager$;
import scala.tools.partest.nest.NestRunner$;
import scala.tools.partest.nest.NestUI$;
import scala.tools.partest.nest.StreamAppender;

public final class NestRunner$
implements ScalaObject {
    public static final NestRunner$ MODULE$;
    private final int errors;
    private PrintStream scala$tools$partest$nest$NestRunner$$out;
    private final PrintStream scala$tools$partest$nest$NestRunner$$con;
    private List scala$tools$partest$nest$NestRunner$$testFiles;
    private boolean failed;
    private boolean showLog;
    private boolean showDiff;
    private boolean scala$tools$partest$nest$NestRunner$$conservative;
    private boolean scala$tools$partest$nest$NestRunner$$shootoutCheck;
    private boolean scala$tools$partest$nest$NestRunner$$runCheck;
    private boolean scala$tools$partest$nest$NestRunner$$jvm5Check;
    private boolean scala$tools$partest$nest$NestRunner$$jvmCheck;
    private boolean scala$tools$partest$nest$NestRunner$$negCheck;
    private boolean scala$tools$partest$nest$NestRunner$$posCheck;
    private final int numActors;
    private final boolean isJava5;
    private final String version;

    static {
        new NestRunner$();
    }

    public NestRunner$() {
        MODULE$ = this;
        this.version = System.getProperty("java.version", "");
        this.isJava5 = this.version().matches("1.[5|6|7].*");
        this.numActors = Integer.parseInt(System.getProperty("scalatest.actors", "8"));
        this.scala$tools$partest$nest$NestRunner$$posCheck = false;
        this.scala$tools$partest$nest$NestRunner$$negCheck = false;
        this.scala$tools$partest$nest$NestRunner$$jvmCheck = false;
        this.scala$tools$partest$nest$NestRunner$$jvm5Check = false;
        this.scala$tools$partest$nest$NestRunner$$runCheck = false;
        this.scala$tools$partest$nest$NestRunner$$shootoutCheck = false;
        this.scala$tools$partest$nest$NestRunner$$conservative = false;
        this.showDiff = false;
        this.showLog = false;
        this.failed = false;
        this.scala$tools$partest$nest$NestRunner$$testFiles = Nil$.MODULE$;
        this.scala$tools$partest$nest$NestRunner$$con = new PrintStream(Console$.MODULE$.out());
        this.scala$tools$partest$nest$NestRunner$$out = this.scala$tools$partest$nest$NestRunner$$con();
        this.errors = Integer.parseInt(System.getProperty("scalatest.errors", "0"));
    }

    private final String form$1(long num) {
        return num < 10L ? "0" + BoxesRunTime.boxToLong(num) : "" + BoxesRunTime.boxToLong(num);
    }

    public Tuple2 testCheckAll() {
        List results = List$.MODULE$.apply(new BoxedObjectArray(new Tuple2[]{this.runTests("pos", this.scala$tools$partest$nest$NestRunner$$posCheck(), "Testing compiler (on files whose compilation should succeed)"), this.runTests("run", this.scala$tools$partest$nest$NestRunner$$runCheck(), "Testing JVM backend"), this.runTests("jvm", this.scala$tools$partest$nest$NestRunner$$jvmCheck(), "Testing JVM backend"), this.runTests("jvm5", this.scala$tools$partest$nest$NestRunner$$jvm5Check(), "Testing JVM backend")}));
        return (Tuple2)results.reduceLeft(new anonfun.testCheckAll.1());
    }

    public Tuple2 runTests(String kind$1, boolean check, String msg) {
        Tuple2 tuple2;
        if (check) {
            List kindFiles$1;
            List list;
            FileManager fileMgr = new FileManager();
            if (this.scala$tools$partest$nest$NestRunner$$testFiles().isEmpty()) {
                list = fileMgr.getFiles(kind$1, check);
            } else {
                NestUI$.MODULE$.verbose("testing " + this.scala$tools$partest$nest$NestRunner$$testFiles());
                list = kindFiles$1 = this.scala$tools$partest$nest$NestRunner$$testFiles();
            }
            if (kindFiles$1.isEmpty()) {
                NestUI$.MODULE$.failure("test dir empty");
                tuple2 = new Tuple2(BoxesRunTime.boxToInteger(0), BoxesRunTime.boxToInteger(0));
            } else {
                NestUI$.MODULE$.outline("\n" + msg + "\n");
                int len = kindFiles$1.length();
                int tp1 = len / this.numActors();
                int tp2 = len % this.numActors();
                Tuple2 tuple22 = new Tuple2(BoxesRunTime.boxToInteger(tp1), BoxesRunTime.boxToInteger(tp2));
                int testsEach$1 = BoxesRunTime.unboxToInt(tuple22._1());
                int lastFrag = BoxesRunTime.unboxToInt(tuple22._2());
                int last$1 = this.numActors() - 1;
                Seq workers = List$.MODULE$.range(0, this.numActors()).map(new anonfun.1(kind$1, kindFiles$1, testsEach$1, last$1));
                IntRef succs$1 = new IntRef(0);
                IntRef fails$1 = new IntRef(0);
                ((List)workers).foreach(new anonfun.runTests.1(succs$1, fails$1));
                tuple2 = new Tuple2(BoxesRunTime.boxToInteger(succs$1.elem), BoxesRunTime.boxToInteger(fails$1.elem));
            }
        } else {
            tuple2 = new Tuple2(BoxesRunTime.boxToInteger(0), BoxesRunTime.boxToInteger(0));
        }
        return tuple2;
    }

    public void main(String[] args) {
        NestUI$.MODULE$.initialize(NestUI$.MODULE$.MANY());
        if (args.length == 0) {
            NestUI$.MODULE$.usage();
        } else {
            new BoxedObjectArray(args).foreach(new anonfun.main.1());
            NestUI$.MODULE$.outline("Source directory is : " + FileManager$.MODULE$.srcDir().getAbsolutePath() + "\n");
            NestUI$.MODULE$.outline("Scala binaries in   : " + FileManager$.MODULE$.BIN_DIR() + "\n");
            String cmd = FileManager$.MODULE$.SCALAC_CMD() + " -version";
            NestUI$.MODULE$.verbose("running " + cmd);
            Process proc = Runtime.getRuntime().exec(cmd);
            InputStream in = proc.getInputStream();
            InputStream err = proc.getErrorStream();
            StringWriter writer = new StringWriter();
            StringWriter errWriter = new StringWriter();
            StreamAppender appender = new StreamAppender(new InputStreamReader(in), writer);
            StreamAppender errApp = new StreamAppender(new InputStreamReader(err), errWriter);
            appender.start();
            errApp.start();
            int exitCode = proc.waitFor();
            NestUI$.MODULE$.verbose("exit code: " + BoxesRunTime.boxToInteger(exitCode));
            appender.join();
            errApp.join();
            String scalaVersion = writer.toString() + errWriter.toString();
            NestUI$.MODULE$.outline("Scala version is    : " + scalaVersion);
            NestUI$.MODULE$.outline("Scalac options are  : " + FileManager$.MODULE$.SCALAC_OPTS() + "\n");
            long start = System.currentTimeMillis();
            Tuple2 tuple2 = this.testCheckAll();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            int successes = BoxesRunTime.unboxToInt(tuple22._1());
            int failures = BoxesRunTime.unboxToInt(tuple22._2());
            long end = System.currentTimeMillis();
            int total = successes + failures;
            long elapsedSecs = (end - start) / 1000L;
            long elapsedMins = elapsedSecs / 60L;
            long elapsedHrs = elapsedMins / 60L;
            long dispMins = elapsedMins - elapsedHrs * 60L;
            long dispSecs = elapsedSecs - elapsedMins * 60L;
            String dispElapsed = this.form$1(elapsedHrs) + ":" + this.form$1(dispMins) + ":" + this.form$1(dispSecs);
            Predef$.MODULE$.println();
            if (failures == 0) {
                NestUI$.MODULE$.success("All of " + BoxesRunTime.boxToInteger(total) + " tests were successful (elapsed time: " + dispElapsed + ")\n");
            } else {
                NestUI$.MODULE$.failure(failures + " of " + BoxesRunTime.boxToInteger(total) + " tests failed (elapsed time: " + dispElapsed + ")\n");
            }
            if (failures == this.errors()) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
    }

    private int errors() {
        return this.errors;
    }

    public final void scala$tools$partest$nest$NestRunner$$out_$eq(PrintStream x$1) {
        this.scala$tools$partest$nest$NestRunner$$out = x$1;
    }

    public final PrintStream scala$tools$partest$nest$NestRunner$$out() {
        return this.scala$tools$partest$nest$NestRunner$$out;
    }

    public final PrintStream scala$tools$partest$nest$NestRunner$$con() {
        return this.scala$tools$partest$nest$NestRunner$$con;
    }

    public final void scala$tools$partest$nest$NestRunner$$testFiles_$eq(List x$1) {
        this.scala$tools$partest$nest$NestRunner$$testFiles = x$1;
    }

    public final List scala$tools$partest$nest$NestRunner$$testFiles() {
        return this.scala$tools$partest$nest$NestRunner$$testFiles;
    }

    public void failed_$eq(boolean x$1) {
        this.failed = x$1;
    }

    public boolean failed() {
        return this.failed;
    }

    public void showLog_$eq(boolean x$1) {
        this.showLog = x$1;
    }

    public boolean showLog() {
        return this.showLog;
    }

    public void showDiff_$eq(boolean x$1) {
        this.showDiff = x$1;
    }

    public boolean showDiff() {
        return this.showDiff;
    }

    public final void scala$tools$partest$nest$NestRunner$$conservative_$eq(boolean x$1) {
        this.scala$tools$partest$nest$NestRunner$$conservative = x$1;
    }

    private boolean scala$tools$partest$nest$NestRunner$$conservative() {
        return this.scala$tools$partest$nest$NestRunner$$conservative;
    }

    public final void scala$tools$partest$nest$NestRunner$$shootoutCheck_$eq(boolean x$1) {
        this.scala$tools$partest$nest$NestRunner$$shootoutCheck = x$1;
    }

    private boolean scala$tools$partest$nest$NestRunner$$shootoutCheck() {
        return this.scala$tools$partest$nest$NestRunner$$shootoutCheck;
    }

    public final void scala$tools$partest$nest$NestRunner$$runCheck_$eq(boolean x$1) {
        this.scala$tools$partest$nest$NestRunner$$runCheck = x$1;
    }

    private boolean scala$tools$partest$nest$NestRunner$$runCheck() {
        return this.scala$tools$partest$nest$NestRunner$$runCheck;
    }

    public final void scala$tools$partest$nest$NestRunner$$jvm5Check_$eq(boolean x$1) {
        this.scala$tools$partest$nest$NestRunner$$jvm5Check = x$1;
    }

    private boolean scala$tools$partest$nest$NestRunner$$jvm5Check() {
        return this.scala$tools$partest$nest$NestRunner$$jvm5Check;
    }

    public final void scala$tools$partest$nest$NestRunner$$jvmCheck_$eq(boolean x$1) {
        this.scala$tools$partest$nest$NestRunner$$jvmCheck = x$1;
    }

    private boolean scala$tools$partest$nest$NestRunner$$jvmCheck() {
        return this.scala$tools$partest$nest$NestRunner$$jvmCheck;
    }

    public final void scala$tools$partest$nest$NestRunner$$negCheck_$eq(boolean x$1) {
        this.scala$tools$partest$nest$NestRunner$$negCheck = x$1;
    }

    private boolean scala$tools$partest$nest$NestRunner$$negCheck() {
        return this.scala$tools$partest$nest$NestRunner$$negCheck;
    }

    public final void scala$tools$partest$nest$NestRunner$$posCheck_$eq(boolean x$1) {
        this.scala$tools$partest$nest$NestRunner$$posCheck = x$1;
    }

    private boolean scala$tools$partest$nest$NestRunner$$posCheck() {
        return this.scala$tools$partest$nest$NestRunner$$posCheck;
    }

    private int numActors() {
        return this.numActors;
    }

    private boolean isJava5() {
        return this.isJava5;
    }

    private String version() {
        return this.version;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

