/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.net.URI;
import scala.Console$;
import scala.List;
import scala.Nil$;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.Tuple2;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.tools.partest.MasterActor;
import scala.tools.partest.Test;
import scala.tools.partest.TestRunner$;
import scala.tools.partest.utils.PrintMgr$;
import scala.tools.partest.utils.Properties$;

public final class TestRunner$
implements ScalaObject {
    public static final TestRunner$ MODULE$;
    private PrintStream scala$tools$partest$TestRunner$$out;
    private final PrintStream scala$tools$partest$TestRunner$$con;
    private ListBuffer scala$tools$partest$TestRunner$$testFiles;
    private final File testDir;
    private final File srcDir;
    private boolean scala$tools$partest$TestRunner$$verbose;
    private boolean scala$tools$partest$TestRunner$$conservative;
    private boolean scala$tools$partest$TestRunner$$shootoutCheck;
    private boolean scala$tools$partest$TestRunner$$runCheck;
    private boolean scala$tools$partest$TestRunner$$jvmCheck;
    private boolean scala$tools$partest$TestRunner$$negCheck;
    private boolean scala$tools$partest$TestRunner$$posCheck;
    private final boolean isJava5;
    private final String version;

    static {
        new TestRunner$();
    }

    /*
     * WARNING - void declaration
     */
    public TestRunner$() {
        void var2_6;
        File file;
        MODULE$ = this;
        this.version = System.getProperty("java.version", "");
        this.isJava5 = this.version().matches("1.[5|6|7].*");
        this.scala$tools$partest$TestRunner$$posCheck = false;
        this.scala$tools$partest$TestRunner$$negCheck = false;
        this.scala$tools$partest$TestRunner$$jvmCheck = false;
        this.scala$tools$partest$TestRunner$$runCheck = false;
        this.scala$tools$partest$TestRunner$$shootoutCheck = false;
        this.scala$tools$partest$TestRunner$$conservative = false;
        this.scala$tools$partest$TestRunner$$verbose = false;
        String dirname = System.getProperty("scalatest.cwd", "");
        if (Predef$.MODULE$.stringWrapper(dirname).isEmpty()) {
            File libDir = new File(new URI(Test.class.getResource("/").toString()));
            String path = libDir.getAbsolutePath();
            File parent = libDir.getParentFile();
            File rootDir = path.contains("quick") ? parent.getParentFile().getParentFile().getParentFile() : (path.contains("dists") ? parent.getParentFile().getParentFile() : parent);
            file = new File(rootDir, "test" + File.separator + "files");
        } else {
            file = new File(dirname);
        }
        File dir = file;
        this.srcDir = var2_6;
        this.testDir = this.srcDir().getParentFile();
        this.scala$tools$partest$TestRunner$$testFiles = new ListBuffer();
        this.scala$tools$partest$TestRunner$$con = new PrintStream(Console$.MODULE$.out());
        this.scala$tools$partest$TestRunner$$out = this.scala$tools$partest$TestRunner$$con();
    }

    private final List getFiles$1(String kind, boolean doCheck, Object object) {
        List list;
        File dir = new File(this.srcDir(), kind);
        if (dir.isDirectory()) {
            if (this.scala$tools$partest$TestRunner$$testFiles().isEmpty()) {
                list = doCheck ? new BoxedObjectArray(dir.listFiles((FilenameFilter)object)).toList() : Nil$.MODULE$;
            } else {
                String dirpath$1 = dir.getAbsolutePath();
                Seq files = this.scala$tools$partest$TestRunner$$testFiles().filter(new anonfun.1(dirpath$1));
                list = files.toList();
            }
        } else {
            Predef$.MODULE$.println("Directory \"" + dir.getPath() + "\" not found");
            list = Nil$.MODULE$;
        }
        return list;
    }

    private final void concat$1(File outputFile, Seq inputFiles) {
        FileOutputStream out$1 = new FileOutputStream(outputFile);
        inputFiles.foreach(new anonfun.concat.1.1(out$1));
        out$1.close();
    }

    private final String getBaseName$1(File f) {
        String name = f.getName();
        int inx = name.lastIndexOf(46);
        return inx < 0 ? name : name.substring(0, inx);
    }

    public void main(String[] args) {
        if (this.srcDir().isDirectory()) {
            this.printVerbose(this.srcDir().getAbsolutePath());
            if (args.length == 0) {
                this.scala$tools$partest$TestRunner$$printUsage();
            } else {
                new BoxedObjectArray(args).foreach(new anonfun.main.1());
                if (!(this.scala$tools$partest$TestRunner$$posCheck() | this.scala$tools$partest$TestRunner$$negCheck() | this.scala$tools$partest$TestRunner$$jvmCheck() | this.scala$tools$partest$TestRunner$$runCheck() | this.scala$tools$partest$TestRunner$$shootoutCheck())) {
                    this.scala$tools$partest$TestRunner$$posCheck_$eq(true);
                    this.scala$tools$partest$TestRunner$$negCheck_$eq(true);
                }
                PrintMgr$.MODULE$.initialization(PrintMgr$.MODULE$.MANY());
                this.go();
            }
            return;
        }
        Predef$.MODULE$.println("Test directory \"" + this.srcDir().getAbsolutePath() + "\" not found");
        Predef$.MODULE$.exit(1);
    }

    public final void printVerbose(String msg) {
        if (this.scala$tools$partest$TestRunner$$verbose()) {
            PrintMgr$.MODULE$.printOutline("debug  : ");
            Predef$.MODULE$.println(msg);
        }
    }

    public final void scala$tools$partest$TestRunner$$printVersion() {
        Predef$.MODULE$.println(Properties$.MODULE$.versionMsg());
        Predef$.MODULE$.exit(0);
    }

    public final void scala$tools$partest$TestRunner$$printUsage() {
        Predef$.MODULE$.println("Usage: TestRunner [<options>] [<testfile> ..] [<resfile>]");
        Predef$.MODULE$.println("    --pos          next files test a compilation success");
        Predef$.MODULE$.println("    --neg          next files test a compilation failure");
        Predef$.MODULE$.println("    --jvm          next files test the JVM backend");
        Predef$.MODULE$.println("    --run          next files test the interpreter and all backends");
        Predef$.MODULE$.println("    --shootout     ...");
        Predef$.MODULE$.println("    --conservative ...");
        Predef$.MODULE$.println("    --verbose      display progress information");
        Predef$.MODULE$.println("    --version      output version information and exit");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println("Send bugs to <scala@listes.epfl.ch>");
        Predef$.MODULE$.exit(1);
    }

    private void go() {
        List shootFiles;
        List negFiles;
        MasterActor master$1 = new MasterActor(this.testDir(), this.scala$tools$partest$TestRunner$$out());
        anon.1 filter$1 = new anon.1();
        master$1.start();
        List posFiles = this.getFiles$1("pos", this.scala$tools$partest$TestRunner$$posCheck(), filter$1);
        if (!posFiles.isEmpty()) {
            PrintMgr$.MODULE$.printOutline("\nTesting compiler (on files whose compilation should succeed)\n");
            posFiles.foreach(new anonfun.go.1(master$1));
        }
        if (!(negFiles = this.getFiles$1("neg", this.scala$tools$partest$TestRunner$$negCheck(), filter$1)).isEmpty()) {
            PrintMgr$.MODULE$.printOutline("\nTesting compiler (on files whose compilation should fail)\n");
            negFiles.foreach(new anonfun.go.2(master$1));
        }
        List list = this.getFiles$1("jvm", this.scala$tools$partest$TestRunner$$jvmCheck(), filter$1);
        List list2 = this.getFiles$1("run", this.scala$tools$partest$TestRunner$$jvmCheck(), filter$1);
        List jvmFiles = this.getFiles$1("jvm5", this.scala$tools$partest$TestRunner$$jvmCheck() && this.isJava5(), filter$1).$colon$colon$colon(list2).$colon$colon$colon(list);
        if (jvmFiles.isEmpty()) {
            List runFiles = this.getFiles$1("run", this.scala$tools$partest$TestRunner$$runCheck(), filter$1);
            if (!runFiles.isEmpty()) {
                PrintMgr$.MODULE$.printOutline("\nTesting JVM backend\n");
                runFiles.foreach(new anonfun.go.4(master$1));
            }
        } else {
            PrintMgr$.MODULE$.printOutline("\nTesting JVM backend\n");
            jvmFiles.foreach(new anonfun.go.3(master$1));
        }
        if (!(shootFiles = this.getFiles$1("shootout", this.scala$tools$partest$TestRunner$$shootoutCheck(), filter$1)).isEmpty()) {
            PrintMgr$.MODULE$.printOutline("\nTesting shootout benchmarks\n");
            shootFiles.foreach(new anonfun.go.5(master$1));
        }
        master$1.$bang(new Tuple2("start", BoxesRunTime.boxToBoolean(this.scala$tools$partest$TestRunner$$conservative())));
    }

    /*
     * WARNING - void declaration
     */
    public final File scala$tools$partest$TestRunner$$createTestFile(File file, String suffix) {
        void var3_3;
        File exceptionResult1 = null;
        try {
            File parent = file.getParentFile();
            File outDir = new File(parent, this.getBaseName$1(file) + "-" + suffix + ".obj");
            outDir.mkdir();
            File testfile = new File(outDir, "test.scala");
            File runnerfile = new File(parent, file.getName() + ".runner");
            this.concat$1(testfile, new BoxedObjectArray(new File[]{file, runnerfile}));
            exceptionResult1 = testfile;
        }
        catch (Exception exception) {
            Predef$.MODULE$.println("Couldn't create test file for \"" + file.getPath() + "\"");
            exceptionResult1 = file;
        }
        return var3_3;
    }

    public final void scala$tools$partest$TestRunner$$out_$eq(PrintStream x$1) {
        this.scala$tools$partest$TestRunner$$out = x$1;
    }

    public final PrintStream scala$tools$partest$TestRunner$$out() {
        return this.scala$tools$partest$TestRunner$$out;
    }

    public final PrintStream scala$tools$partest$TestRunner$$con() {
        return this.scala$tools$partest$TestRunner$$con;
    }

    private void scala$tools$partest$TestRunner$$testFiles_$eq(ListBuffer x$1) {
        this.scala$tools$partest$TestRunner$$testFiles = x$1;
    }

    public final ListBuffer scala$tools$partest$TestRunner$$testFiles() {
        return this.scala$tools$partest$TestRunner$$testFiles;
    }

    private File testDir() {
        return this.testDir;
    }

    private File srcDir() {
        return this.srcDir;
    }

    public final void scala$tools$partest$TestRunner$$verbose_$eq(boolean x$1) {
        this.scala$tools$partest$TestRunner$$verbose = x$1;
    }

    private boolean scala$tools$partest$TestRunner$$verbose() {
        return this.scala$tools$partest$TestRunner$$verbose;
    }

    public final void scala$tools$partest$TestRunner$$conservative_$eq(boolean x$1) {
        this.scala$tools$partest$TestRunner$$conservative = x$1;
    }

    private boolean scala$tools$partest$TestRunner$$conservative() {
        return this.scala$tools$partest$TestRunner$$conservative;
    }

    public final void scala$tools$partest$TestRunner$$shootoutCheck_$eq(boolean x$1) {
        this.scala$tools$partest$TestRunner$$shootoutCheck = x$1;
    }

    private boolean scala$tools$partest$TestRunner$$shootoutCheck() {
        return this.scala$tools$partest$TestRunner$$shootoutCheck;
    }

    public final void scala$tools$partest$TestRunner$$runCheck_$eq(boolean x$1) {
        this.scala$tools$partest$TestRunner$$runCheck = x$1;
    }

    private boolean scala$tools$partest$TestRunner$$runCheck() {
        return this.scala$tools$partest$TestRunner$$runCheck;
    }

    public final void scala$tools$partest$TestRunner$$jvmCheck_$eq(boolean x$1) {
        this.scala$tools$partest$TestRunner$$jvmCheck = x$1;
    }

    private boolean scala$tools$partest$TestRunner$$jvmCheck() {
        return this.scala$tools$partest$TestRunner$$jvmCheck;
    }

    public final void scala$tools$partest$TestRunner$$negCheck_$eq(boolean x$1) {
        this.scala$tools$partest$TestRunner$$negCheck = x$1;
    }

    private boolean scala$tools$partest$TestRunner$$negCheck() {
        return this.scala$tools$partest$TestRunner$$negCheck;
    }

    public final void scala$tools$partest$TestRunner$$posCheck_$eq(boolean x$1) {
        this.scala$tools$partest$TestRunner$$posCheck = x$1;
    }

    private boolean scala$tools$partest$TestRunner$$posCheck() {
        return this.scala$tools$partest$TestRunner$$posCheck;
    }

    private final boolean isJava5() {
        return this.isJava5;
    }

    private final String version() {
        return this.version;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

