/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_ShortcutConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Unix_Shortcut
extends Shortcut
implements Unix_ShortcutConstants {
    private static String version = "$Id: Unix_Shortcut.java,v 1.9.4.1 2006/01/03 13:53:58 jponge Exp $";
    private static String rev = "$Revision: 1.9.4.1 $";
    private static String DESKTOP_EXT = ".desktop";
    private static String template = "";
    private static final String N = "\n";
    private static final String H = "#";
    private static final String S = " ";
    private static final String C = "# ";
    private static final String QM = "\"";
    private String createdDirectory;
    private int itsShow;
    private int itsUserType;
    private int itsType;
    private int itsIconIndex;
    private String itsWorkingDirectory;
    private String itsGroupName;
    private String itsTargetPath;
    private String itsIconPath;
    private String itsDescription;
    private String itsArguments;
    private String itsName;
    private String itsFileName;
    private String itsApplnkFolder = "applnk";
    private Properties props;
    private Boolean forAll = new Boolean(false);

    public Unix_Shortcut() {
        StringBuffer hlp = new StringBuffer();
        String userLanguage = System.getProperty("user.language", "en");
        hlp.append("[Desktop Entry]\n");
        hlp.append("Comment=$Comment\n");
        hlp.append("Comment[" + userLanguage + "]=" + "$Comment" + N);
        hlp.append("Encoding=$Encoding\n");
        hlp.append("Exec=$E_QUOT$Exec$E_QUOT $Arguments\n");
        hlp.append("GenericName=$GenericName\n");
        hlp.append("GenericName[" + userLanguage + "]=" + "$GenericName" + N);
        hlp.append("Icon=$Icon\n");
        hlp.append("MimeType=$MimeType\n");
        hlp.append("Name=$Name\n");
        hlp.append("Name[" + userLanguage + "]=" + "$Name" + N);
        hlp.append("Path=$P_QUOT$Path$P_QUOT\n");
        hlp.append("ServiceTypes=$ServiceTypes\n");
        hlp.append("SwallowExec=$SwallowExec\n");
        hlp.append("SwallowTitle=$SwallowTitle\n");
        hlp.append("Terminal=$Terminal\n");
        hlp.append("TerminalOptions=$Options_For_Terminal\n");
        hlp.append("Type=$Type\n");
        hlp.append("URL=$URL\n");
        hlp.append("X-KDE-SubstituteUID=$X_KDE_SubstituteUID\n");
        hlp.append("X-KDE-Username=$X_KDE_Username\n");
        hlp.append(N);
        hlp.append("# created by " + this.getClass().getName() + S + rev + N);
        hlp.append(C + version);
        template = hlp.toString();
        this.props = new Properties();
        this.initProps();
    }

    private void initProps() {
        String[] propsArray = new String[]{"$Comment", "$$LANG_Comment", "$Encoding", "$Exec", "$Arguments", "$GenericName", "$$LANG_GenericName", "$MimeType", "$Name", "$$LANG_Name", "$Path", "$ServiceTypes", "$SwallowExec", "$SwallowTitle", "$Terminal", "$Options_For_Terminal", "$Type", "$X_KDE_SubstituteUID", "$X_KDE_Username", "$Icon", "$URL", "$E_QUOT", "$P_QUOT"};
        for (int i = 0; i < propsArray.length; ++i) {
            this.props.put(propsArray[i], "");
        }
    }

    public void initialize(int aType, String aName) throws Exception {
        this.itsType = aType;
        this.itsName = aName;
        this.props.put("$Name", aName);
    }

    public boolean supported() {
        return true;
    }

    public String getDirectoryCreated() {
        return this.createdDirectory;
    }

    public String getFileName() {
        return this.itsFileName;
    }

    public Vector getProgramGroups(int userType) {
        Vector<String> groups = new Vector<String>();
        File kdeShareApplnk = this.getKdeShareApplnkFolder(userType);
        try {
            File[] listing = kdeShareApplnk.listFiles();
            for (int i = 0; i < listing.length; ++i) {
                if (!listing[i].isDirectory()) continue;
                groups.add(listing[i].getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return groups;
    }

    public String getProgramsFolder(int current_user) {
        String result = new String();
        result = this.getKdeShareApplnkFolder(current_user).toString();
        return result;
    }

    private File getKdeShareApplnkFolder(int userType) {
        File kdeBase = this.getKdeBase(userType);
        File result = new File(kdeBase + File.separator + "share" + File.separator + this.getKdeApplinkFolderName());
        return result;
    }

    private String getKdeApplinkFolderName() {
        String applinkFolderName = "applnk";
        if (OsVersion.IS_REDHAT_LINUX) {
            applinkFolderName = "applnk-redhat";
        }
        if (OsVersion.IS_MANDRAKE_LINUX) {
            applinkFolderName = "applnk-mdk";
        }
        return applinkFolderName;
    }

    private File getKdeBase(int userType) {
        File result = null;
        if (userType == 2) {
            FileExecutor fe = new FileExecutor();
            String[] execOut = new String[2];
            int execResult = fe.executeCommand(new String[]{"/usr/bin/env", "kde-config", "--prefix"}, execOut);
            result = new File(execOut[0].trim());
        } else {
            result = new File(System.getProperty("user.home").toString() + File.separator + ".kde");
        }
        return result;
    }

    public boolean multipleUsers() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save() throws Exception {
        String FS = File.separator;
        String target = null;
        String shortCutDef = this.replace();
        boolean rootUser4All = this.getUserType() == 2;
        boolean create4All = this.getCreateForAll();
        if ("".equals(this.itsGroupName) && this.getLinkType() == 3) {
            this.itsFileName = target = System.getProperty("user.home") + FS + "Desktop" + FS + this.itsName + DESKTOP_EXT;
            File source = this.writeShortCut(target, shortCutDef);
            if (!rootUser4All || !create4All) return;
            File dest = null;
            File[] userHomesList = new File(FS + "home" + FS).listFiles();
            File aHomePath = null;
            if (userHomesList == null) return;
            for (int idx = 0; idx < userHomesList.length; ++idx) {
                if (!userHomesList[idx].isDirectory()) continue;
                try {
                    aHomePath = userHomesList[idx];
                    dest = new File(aHomePath.toString() + FS + "Desktop" + FS + source.getName());
                    Unix_Shortcut.copyTo(source, dest);
                }
                catch (Exception rex) {
                    // empty catch block
                }
                try {
                    String[] output = new String[2];
                    FileExecutor fe = new FileExecutor();
                    int result = fe.executeCommand(new String[]{"/bin/chown", aHomePath.getName(), aHomePath.toString()}, output);
                    if (result == 0) continue;
                }
                catch (RuntimeException rexx) {
                    // empty catch block
                }
            }
            return;
        }
        File kdeHomeShareApplnk = this.getKdeShareApplnkFolder(this.getUserType());
        this.itsFileName = target = kdeHomeShareApplnk.toString() + FS + this.itsGroupName + FS + this.itsName + DESKTOP_EXT;
        if (rootUser4All && !create4All) {
            return;
        }
        this.writeShortCut(target, shortCutDef);
    }

    public static void copyTo(File inFile, File outFile) throws IOException {
        char[] cbuff = new char[32768];
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        int readedBytes = 0;
        long absWrittenBytes = 0L;
        while ((readedBytes = reader.read(cbuff, 0, cbuff.length)) != -1) {
            writer.write(cbuff, 0, readedBytes);
            absWrittenBytes += (long)readedBytes;
        }
        reader.close();
        writer.close();
    }

    private File writeShortCut(String target, String shortCutDef) {
        File targetPath = new File(target.toString().substring(0, target.toString().lastIndexOf(File.separatorChar)));
        if (!targetPath.exists()) {
            targetPath.mkdirs();
            this.createdDirectory = targetPath.toString();
        }
        File targetFileName = new File(target);
        File backupFile = new File(targetPath + File.separator + "." + targetFileName.getName() + System.currentTimeMillis());
        if (targetFileName.exists()) {
            try {
                Unix_Shortcut.copyTo(targetFileName, backupFile);
                targetFileName.delete();
            }
            catch (IOException e3) {
                System.out.println("cannot create backup file " + backupFile + " of " + targetFileName);
            }
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(targetFileName);
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
        try {
            fileWriter.write(shortCutDef);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return targetFileName;
    }

    public void setArguments(String args) {
        this.itsArguments = args;
        this.props.put("$Arguments", args);
    }

    public void setDescription(String description) {
        this.itsDescription = description;
        this.props.put("$Comment", description);
    }

    public void setIconLocation(String path, int index) {
        this.itsIconPath = path;
        this.itsIconIndex = index;
        this.props.put("$Icon", path);
    }

    public void setLinkName(String aName) {
        this.itsName = aName;
        this.props.put("$Name", aName);
    }

    public void setLinkType(int aType) throws IllegalArgumentException {
        this.itsType = aType;
    }

    public void setProgramGroup(String aGroupName) {
        this.itsGroupName = aGroupName;
    }

    public void setShowCommand(int show) {
        this.itsShow = show;
    }

    public void setTargetPath(String aPath) {
        this.itsTargetPath = aPath;
        StringTokenizer whiteSpaceTester = new StringTokenizer(aPath);
        if (whiteSpaceTester.countTokens() > 1) {
            this.props.put("$E_QUOT", QM);
        }
        this.props.put("$Exec", aPath);
    }

    public void setUserType(int aUserType) {
        this.itsUserType = aUserType;
    }

    public void setWorkingDirectory(String aDirectory) {
        this.itsWorkingDirectory = aDirectory;
        StringTokenizer whiteSpaceTester = new StringTokenizer(aDirectory);
        if (whiteSpaceTester.countTokens() > 1) {
            this.props.put("$P_QUOT", QM);
        }
        this.props.put("$Path", aDirectory);
    }

    public String toString() {
        return this.itsName + N + template;
    }

    public String replace() {
        String result = template;
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            result = StringTool.replace(result, key, this.props.getProperty(key));
        }
        return result;
    }

    public static void main(String[] args) {
        Unix_Shortcut aSample = new Unix_Shortcut();
        try {
            aSample.initialize(1, "Start Tomcat");
        }
        catch (Exception exc) {
            System.err.println("Could not init Unix_Shourtcut");
        }
        aSample.replace();
        System.out.println(aSample);
        File targetFileName = new File(System.getProperty("user.home") + File.separator + "Start Tomcat" + DESKTOP_EXT);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(targetFileName);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            fileWriter.write(template);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void setEncoding(String aEncoding) {
        this.props.put("$Encoding", aEncoding);
    }

    public void setKdeSubstUID(String aKDESubstUID) {
        this.props.put("$X_KDE_SubstituteUID", aKDESubstUID);
    }

    public void setMimetype(String aMimetype) {
        this.props.put("$MimeType", aMimetype);
    }

    public void setTerminal(String trueFalseOrNothing) {
        this.props.put("$Terminal", trueFalseOrNothing);
    }

    public void setTerminalOptions(String someTerminalOptions) {
        this.props.put("$Options_For_Terminal", someTerminalOptions);
    }

    public void setType(String aType) {
        this.props.put("$Type", aType);
    }

    public void setURL(String anUrl) {
        this.props.put("$URL", anUrl);
    }

    public int getUserType() {
        return this.itsUserType;
    }
}

