/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sbaz.AvailableList;
import sbaz.AvailablePackage;
import sbaz.DependencyError;
import sbaz.Downloader;
import sbaz.Filename;
import sbaz.InstalledEntry;
import sbaz.InstalledList;
import sbaz.ManagedDirectory$;
import sbaz.Package;
import sbaz.ProposedChanges;
import sbaz.Universe;
import sbaz.Universe$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesUtility;
import scala.runtime.ScalaRunTime$;
import scala.xml.Node;
import scala.xml.XML$;

public class ManagedDirectory
implements ScalaObject {
    private static /* synthetic */ Class class$Cache0;
    private File scala_lib_jar;
    private File sbaz_jar;
    private boolean isWin;
    private Universe universe;
    private InstalledList installed;
    private AvailableList available;
    private Downloader downloader;
    private File misc_dir;
    private File meta_dir;
    private File lib_dir;
    private File directory;

    public ManagedDirectory(File directory) {
        this.directory = directory;
        this.lib_dir = new File(directory, "lib");
        this.meta_dir = new File(directory, "meta");
        this.misc_dir = new File(directory, "misc");
        if (this.lib_dir().isDirectory() || this.meta_dir().isDirectory() || this.misc_dir().isDirectory()) {
            this.downloader = new Downloader(new File(this.meta_dir(), "cache"));
            this.available = (AvailableList)this.loadXML("available", new $anonfun$0(this), new AvailableList((List)Nil$.MODULE$));
            this.installed = (InstalledList)this.loadXML("installed", new $anonfun$1(this), new InstalledList());
            this.universe = Universe$.MODULE$.fromFile(new File(this.meta_dir(), "universe"));
            this.universe().keyringFilesAreIn(this.meta_dir());
            this.isWin = System.getProperty("os.name").startsWith("Windows");
            this.sbaz_jar = new File(this.lib_dir(), "sbaz.jar");
            this.scala_lib_jar = new File(this.misc_dir(), "sbaz" + File.separator + "scala-library.jar");
            return;
        }
        throw new Error("Directory " + directory + " does not appear to be a sbaz-managed directory");
    }

    private final void lp$1(InputStream inputStream, FileOutputStream fileOutputStream) {
        byte[] dat;
        int numread;
        while ((numread = inputStream.read(dat = new byte[100])) >= 0) {
            fileOutputStream.write(dat, 0, numread);
        }
    }

    public String toString() {
        return "(" + this.directory().toString() + ": " + BoxesUtility.boxToInteger((int)this.installed().size()) + "/" + BoxesUtility.boxToInteger((int)this.available().numPackages()) + " packages)";
    }

    public void compact() {
        this.downloader().flushCache();
    }

    public void updateAvailable() {
        this.available_$eq(this.universe().retrieveAvailable());
        this.saveAvailable();
    }

    private void downloadURL(URL url, File file) {
        URLConnection connection = url.openConnection();
        InputStream inputStream$0 = connection.getInputStream();
        FileOutputStream f$0 = new FileOutputStream(file);
        this.lp$1(inputStream$0, f$0);
        f$0.close();
    }

    public final void sbaz$ManagedDirectory$$removeNoCheck(InstalledEntry entry) {
        this.removeEntryFiles(entry);
        this.installed().remove(entry.packageSpec());
        this.saveInstalled();
    }

    public void remove(InstalledEntry entry) {
        if (this.installed().anyDependOn(entry.name())) {
            throw new DependencyError("Package " + entry.name() + " is still needed");
        }
        this.sbaz$ManagedDirectory$$removeNoCheck(entry);
    }

    private void removeEntryFiles(InstalledEntry entry) {
        List fullFiles = entry.files().map((Function1)new $anonfun$16(this));
        List sortedFiles = fullFiles.sort((Function2)new $anonfun$17(this));
        sortedFiles.filter((Function1)new $anonfun$18(this)).foreach((Function1)new $anonfun$19(this));
    }

    public void install(File file) {
        this.makeChanges((Seq)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new ProposedChanges.AdditionFromFile[]{new ProposedChanges.AdditionFromFile(file)})));
    }

    public void install(AvailablePackage pack) {
        this.makeChanges((Seq)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new ProposedChanges.AdditionFromNet[]{new ProposedChanges.AdditionFromNet(pack)})));
    }

    public void installNoCheck(Package pack$0, File downloadedFile) {
        Option option;
        block3: {
            InstalledEntry newEntry;
            List zipEntsToInstall;
            ZipFile zip;
            block2: {
                zip = new ZipFile(downloadedFile);
                List zipEntsAll = this.mkList(zip.entries());
                zipEntsToInstall = zipEntsAll.filter((Function1)new $anonfun$10(this));
                zipEntsToInstall.filter((Function1)new $anonfun$11(this)).foreach((Function1)new $anonfun$12(this, pack$0));
                List installedFiles = zipEntsToInstall.map((Function1)new $anonfun$15(this));
                newEntry = new InstalledEntry(pack$0, installedFiles);
                option = this.installed().entryNamed(pack$0.name());
                if (None$.MODULE$ == option) break block2;
                if (!(option instanceof Some)) break block3;
                this.removeEntryFiles((InstalledEntry)((Some)option).x());
            }
            this.extractFiles(zip, zipEntsToInstall, this.directory());
            this.installed().add(newEntry);
            this.saveInstalled();
            zip.close();
            return;
        }
        throw new MatchError((Object)option);
    }

    public void extractFiles(ZipFile zip$0, List entries, File directory$0) {
        entries.foreach((Function1)new $anonfun$9(this, zip$0, directory$0));
    }

    public final boolean sbaz$ManagedDirectory$$isSpecial(File f) {
        return this.isWin() && (f.compareTo(this.sbaz_jar()) == 0 || f.compareTo(this.scala_lib_jar()) == 0);
    }

    private File scala_lib_jar() {
        return this.scala_lib_jar;
    }

    private File sbaz_jar() {
        return this.sbaz_jar;
    }

    private boolean isWin() {
        return this.isWin;
    }

    private List mkList(Enumeration enumeration) {
        Nil$ l = Nil$.MODULE$;
        while (enumeration.hasMoreElements()) {
            Object n;
            Object e = n = enumeration.nextElement();
            l = l.$colon$colon(e);
        }
        return l.reverse();
    }

    public void makeChanges(Seq changes) {
        if (this.installed().changesAcceptible(changes)) {
            changes.elements().filter((Function1)new $anonfun$3(this)).foreach((Function1)new $anonfun$4(this));
            changes.elements().filter((Function1)new $anonfun$5(this)).foreach((Function1)new $anonfun$6(this));
            changes.elements().foreach((Function1)new $anonfun$8(this));
            return;
        }
        throw new DependencyError();
    }

    public final Object sbaz$ManagedDirectory$$makeExecutable(File file) {
        Object object;
        try {
            Object object2 = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{"chmod", "+x", file.getPath()})), ManagedDirectory.class$Method0());
            object = Runtime.getRuntime().exec((String[])(object2 instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object2, ManagedDirectory.class$Method0()) : object2));
        }
        catch (IOException iOException) {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public final Filename sbaz$ManagedDirectory$$zipToFilename(ZipEntry ent) {
        List pathParts = new BoxedObjectArray((Object[])ent.getName().split("/")).toList().filter((Function1)new $anonfun$2(this));
        return new Filename(!ent.isDirectory(), true, pathParts);
    }

    public final File sbaz$ManagedDirectory$$download(AvailablePackage avail) {
        String basename = avail.filename();
        if (!this.downloader().is_downloaded(basename)) {
            this.downloader().download(avail.link(), basename);
        }
        return new File(this.downloader().dir(), basename);
    }

    public void setUniverse(Universe newUniverse) {
        this.clearAvailable();
        this.universe_$eq(newUniverse);
        this.saveUniverse();
    }

    private boolean clearAvailable() {
        this.available_$eq(new AvailableList((List)Nil$.MODULE$));
        return new File(this.meta_dir(), "available").delete();
    }

    private void saveUniverse() {
        this.saveXML(this.universe().toXML(), "universe");
    }

    public void universe_$eq(Universe x$1) {
        this.universe = x$1;
    }

    public Universe universe() {
        return this.universe;
    }

    private void saveInstalled() {
        this.saveXML(this.installed().toXML(), "installed");
    }

    public InstalledList installed() {
        return this.installed;
    }

    private void saveAvailable() {
        this.saveXML((Node)this.available().toXML(), "available");
    }

    public void available_$eq(AvailableList x$1) {
        this.available = x$1;
    }

    public AvailableList available() {
        return this.available;
    }

    private void saveXML(Node xml, String filename) {
        File tmpFile = new File(this.meta_dir(), filename + ".tmp");
        FileWriter str = new FileWriter(tmpFile);
        str.write(xml.toString());
        str.close();
        this.renameFile(tmpFile, new File(this.meta_dir(), filename));
    }

    private Object loadXML(String filename, Function1 decoder, Object object) {
        File file = new File(this.meta_dir(), filename);
        return file.exists() ? decoder.apply((Object)XML$.MODULE$.load(file.getAbsolutePath())) : object;
    }

    private void renameFile(File from, File to) {
        to.delete();
        from.renameTo(to);
    }

    private Downloader downloader() {
        return this.downloader;
    }

    private File misc_dir() {
        return this.misc_dir;
    }

    private File meta_dir() {
        return this.meta_dir;
    }

    private File lib_dir() {
        return this.lib_dir;
    }

    public File directory() {
        return this.directory;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }

    private static /* synthetic */ Class class$Method0() {
        if (class$Cache0 == null) {
            class$Cache0 = Class.forName("java.lang.String");
        }
        return class$Cache0;
    }
}

