/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.partest;

import java.io.File;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.tools.nsc.Settings;

public class Test
implements ScalaObject {
    private File checkFile;
    private File logFile;
    private String fileBase;
    private String dirpath;
    private File dir;
    private File file;
    private String kind;

    public Test(String kind, File file) {
        this.kind = kind;
        this.file = file;
        this.dir = file.getParentFile();
        this.dirpath = this.dir().getAbsolutePath();
        this.fileBase = this.basename(file.getName());
        this.logFile = new File(this.dir(), this.fileBase() + "-" + kind + ".log");
        File chkFile = new File(this.dir(), this.fileBase() + ".check");
        this.checkFile = chkFile.isFile() ? chkFile : new File(this.dir(), this.fileBase() + "-" + kind + ".check");
    }

    public File checkFile() {
        return this.checkFile;
    }

    public File logFile() {
        return this.logFile;
    }

    public String fileBase() {
        return this.fileBase;
    }

    private String basename(String name) {
        int inx = name.lastIndexOf(".");
        return inx < 0 ? name : name.substring(0, inx);
    }

    public void defineSettings(Settings settings) {
        this.baseSettings(settings);
    }

    public void baseSettings(Settings settings) {
        settings.classpath().value_$eq(this.dirpath());
        Settings.StringSetting stringSetting = settings.outdir();
        File outDir = new File(this.dir(), this.fileBase() + "-" + this.kind() + ".obj");
        outDir.mkdir();
        stringSetting.value_$eq(outDir.toString());
        settings.deprecation().value_$eq(true);
        settings.nowarnings().value_$eq(false);
        settings.encoding().value_$eq("iso-8859-1");
    }

    public String dirpath() {
        return this.dirpath;
    }

    public File dir() {
        return this.dir;
    }

    public File file() {
        return this.file;
    }

    public String kind() {
        return this.kind;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

