/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple2;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxesUtility;

public abstract class ApproximateNumeric
extends Numeric
implements ScalaObject {
    private int nativeTypeId;

    public ApproximateNumeric(int nativeTypeId) {
        this.nativeTypeId = nativeTypeId;
        super(nativeTypeId);
    }

    public String sqlString() {
        String string;
        Tuple2 tuple2 = new Tuple2(BoxesUtility.boxToInteger(this.precisionRadix()), BoxesUtility.boxToInteger(this.precision()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int n = BoxesUtility.unboxToInt(tuple2._2());
        block0 : switch (BoxesUtility.unboxToInt(tuple2._1())) {
            default: {
                throw new UnsupportedFeature("SQL-99 does not support the precision of an approximate numeric type to be defined in a radix other than 2 or 10");
            }
            case 2: {
                switch (n) {
                    default: {
                        throw new UnsupportedFeature("SQL-99 does not support an approximate numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    case 64: {
                        string = "REAL";
                        break block0;
                    }
                    case 128: 
                }
                string = "DOUBLE PRECISION";
                break;
            }
            case 10: {
                string = "FLOAT (" + ((Object)BoxesUtility.boxToInteger(n)).toString() + ")";
            }
        }
        return string;
    }

    public boolean isSubtypeOf(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ApproximateNumeric) {
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric dt = approximateNumeric = (ApproximateNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() <= dt.precision() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isEquivalent(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ApproximateNumeric) {
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric dt = approximateNumeric = (ApproximateNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() == dt.precision() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

