/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Some;
import scala.actors.remote.JavaSerializer;
import scala.actors.remote.NetKernel;
import scala.actors.remote.Node;
import scala.actors.remote.Serializer;
import scala.actors.remote.Service;
import scala.actors.remote.Service$class;
import scala.actors.remote.TcpServiceWorker;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesUtility;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TcpService
extends Thread
implements Service,
ScalaObject {
    private NetKernel kernel;
    private HashMap connections;
    private Node internalNode;
    private JavaSerializer serializer;
    private int port;

    public TcpService(int port) {
        this.port = port;
        Service$class.$init$(this);
        this.serializer = new JavaSerializer(this);
        this.internalNode = new Node(InetAddress.getLocalHost().getHostAddress(), port);
        this.connections = new HashMap();
    }

    public Serializer serializer() {
        return this.serializer();
    }

    public void nodeDown(Node mnode) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.connections().$minus$eq(mnode);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReachable(Node node) {
        if (this.isConnected(node)) return true;
        try {
            this.connect(node);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public void disconnectNode(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Option option = this.connections().get(n);
            if (option != None$.MODULE$) {
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                this.connections().$minus$eq(n);
                ((TcpServiceWorker)((Some)option).x()).halt();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public TcpServiceWorker connect(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Socket sock = new Socket(n.address(), n.port());
            TcpServiceWorker worker = new TcpServiceWorker(this, sock);
            worker.sendNode(n);
            worker.start();
            this.addConnection(n, worker);
            return worker;
        }
    }

    public boolean isConnected(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            return BoxesUtility.unboxToBoolean(BoxesUtility.boxToBoolean(!this.connections().get(n).isEmpty()));
        }
    }

    public Option getConnection(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            return this.connections().get(n);
        }
    }

    public void addConnection(Node node, TcpServiceWorker worker) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.connections().$plus$eq(node).$minus$greater(worker);
            return;
        }
    }

    private HashMap connections() {
        return this.connections;
    }

    public void run() {
        try {
            ServerSocket socket = new ServerSocket(this.port);
            while (true) {
                Socket nextClient = socket.accept();
                TcpServiceWorker worker = new TcpServiceWorker(this, nextClient);
                worker.readNode();
                worker.start();
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void send(Node node, byte[] data) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Option option = this.getConnection(node);
            if (option != None$.MODULE$) {
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                ((TcpServiceWorker)((Some)option).x()).transmit(data);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                TcpServiceWorker newWorker = this.connect(node);
                newWorker.transmit(data);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public Node node() {
        return this.internalNode();
    }

    private Node internalNode() {
        return this.internalNode;
    }

    public JavaSerializer serializer() {
        return this.serializer;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }

    public final void kernel_$eq(NetKernel x$1) {
        this.kernel = x$1;
    }

    public final NetKernel kernel() {
        return this.kernel;
    }
}

