/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.concurrent.ops$;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesUtility;
import scala.runtime.Nothing$;
import scala.tools.nsc.CompileServer$;
import scala.tools.nsc.CompileSocket$;
import scala.tools.nsc.FatalError;
import scala.tools.nsc.Global;
import scala.tools.nsc.Properties$;
import scala.tools.nsc.Settings;
import scala.tools.nsc.reporters.ConsoleReporter;
import scala.tools.nsc.util.FakePos;
import scala.tools.util.SocketServer;

public final class CompileServer$
extends SocketServer
implements ScalaObject {
    public static final CompileServer$ MODULE$;
    private File redirectDir;
    private ConsoleReporter reporter;
    private Runtime runtime;
    private boolean scala$tools$nsc$CompileServer$$progress;
    private boolean scala$tools$nsc$CompileServer$$inSession;
    private Global compiler;
    private boolean shutDown;
    private double MaxCharge;
    private String versionMsg;

    static {
        CompileServer$ compileServer$ = new CompileServer$();
    }

    public CompileServer$() {
        MODULE$ = this;
        this.versionMsg = "Fast Scala compiler " + Properties$.MODULE$.versionString() + " -- " + Properties$.MODULE$.copyrightString();
        this.MaxCharge = 0.8;
        this.shutDown = false;
        this.compiler = null;
        this.scala$tools$nsc$CompileServer$$inSession = false;
        this.scala$tools$nsc$CompileServer$$progress = false;
        this.runtime = Runtime.getRuntime();
        this.redirectDir = new File(CompileSocket$.MODULE$.tmpDir(), "output-redirects");
        this.redirectDir().mkdirs();
    }

    public final void error$0(String msg) {
        this.reporter().error(new FakePos("fsc"), msg + "\n  fsc -help  gives more information");
    }

    public void main(String[] args) {
        this.redirect(new anonfun.4(), "scala-compile-server-out.log");
        this.redirect(new anonfun.5(), "scala-compile-server-err.log");
        System.err.println("...starting server on socket " + BoxesUtility.boxToInteger(this.port()) + "...");
        System.err.flush();
        this.spawnWatchDog();
        CompileSocket$.MODULE$.setPort(this.port());
        this.run();
        CompileSocket$.MODULE$.deletePort(this.port());
        this.exit(0);
    }

    public void redirect(Function1 setter, String filename) {
        setter.apply(new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(this.redirectDir(), filename)))));
    }

    public File redirectDir() {
        return this.redirectDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void session() {
        System.out.println("New session, total memory = " + BoxesUtility.boxToLong(this.runtime().totalMemory()) + ", max memory = " + BoxesUtility.boxToLong(this.runtime().maxMemory()) + ", free memory = " + BoxesUtility.boxToLong(this.runtime().freeMemory()));
        String password = CompileSocket$.MODULE$.getPassword(this.port());
        String guessedPassword = this.in().readLine();
        String input = this.in().readLine();
        if (input == null) return;
        String string = password;
        String string2 = guessedPassword;
        if (string != null) {
            if (!string.equals(string2)) {
                return;
            }
        } else if (string2 != null) return;
        try {
            block19: {
                block15: {
                    block16: {
                        anon.2 command$0;
                        block17: {
                            block18: {
                                this.scala$tools$nsc$CompileServer$$inSession_$eq(true);
                                this.scala$tools$nsc$CompileServer$$progress_$eq(true);
                                List args$0 = new BoxedObjectArray(input.split("\u0000")).toList();
                                if (args$0.contains("-shutdown")) {
                                    this.out().println("[Scala compile server exited]");
                                    this.shutDown_$eq(true);
                                    this.scala$tools$nsc$CompileServer$$inSession_$eq(false);
                                    return;
                                }
                                if (args$0.contains("-reset")) {
                                    this.out().println("[Scala compile server was reset]");
                                    this.compiler_$eq(null);
                                    this.scala$tools$nsc$CompileServer$$inSession_$eq(false);
                                    return;
                                }
                                command$0 = new anon.2(args$0);
                                this.reporter_$eq(new anon.1(command$0));
                                if (command$0.settings().version().value()) break block16;
                                if (command$0.settings().help().value()) break block17;
                                if (command$0.files().isEmpty()) break block18;
                                try {
                                    if (this.compiler() != null && this.settingsAreCompatible(command$0.settings(), this.compiler().settings())) {
                                        this.compiler().settings_$eq(command$0.settings());
                                        this.compiler().reporter_$eq(this.reporter());
                                    } else {
                                        if (args$0.contains("-verbose")) {
                                            this.out().println("[Starting new Scala compile server instance]");
                                        }
                                        this.compiler_$eq(new anon.0(command$0));
                                    }
                                    Global c = this.compiler();
                                    Global.Run run = new Global.Run(c);
                                    run.compile(command$0.files());
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2 = throwable;
                                    if (!(throwable2 instanceof FatalError)) {
                                        if (throwable2 == null) throw new MatchError((Object)throwable2);
                                        Throwable ex = throwable2;
                                        ex.printStackTrace(this.out());
                                        this.reporter().error(null, "fatal error (server aborted): " + ex.getMessage());
                                        this.shutDown_$eq(true);
                                        break block15;
                                    }
                                    FatalError fatalError = (FatalError)throwable2;
                                    String string3 = fatalError.msg();
                                    FatalError ex = fatalError;
                                    String msg = string3;
                                    if (command$0.settings().debug().value()) {
                                        ex.printStackTrace(this.out());
                                    }
                                    this.reporter().error(null, "fatal error: " + msg);
                                    this.compiler_$eq(null);
                                }
                                break block15;
                            }
                            this.reporter().info(null, command$0.usageMsg(), true);
                            break block19;
                        }
                        this.reporter().info(null, command$0.usageMsg(), true);
                        break block19;
                    }
                    this.reporter().info(null, this.versionMsg(), true);
                    break block19;
                }
                this.reporter().printSummary();
                this.runtime().gc();
                if (!((double)(this.runtime().totalMemory() - this.runtime().freeMemory()) / (double)this.runtime().maxMemory() <= this.MaxCharge())) {
                    this.compiler_$eq(null);
                }
            }
            this.scala$tools$nsc$CompileServer$$inSession_$eq(false);
            return;
        }
        catch (Throwable throwable) {
            this.scala$tools$nsc$CompileServer$$inSession_$eq(false);
            throw throwable;
        }
    }

    public void reporter_$eq(ConsoleReporter x$1) {
        this.reporter = x$1;
    }

    public ConsoleReporter reporter() {
        return this.reporter;
    }

    private Runtime runtime() {
        return this.runtime;
    }

    private void spawnWatchDog() {
        ops$.MODULE$.spawn(new anonfun.0());
    }

    private Nothing$ exit(int code) {
        System.err.close();
        System.out.close();
        return Predef$.MODULE$.exit(code);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean settingsAreCompatible(Settings s1, Settings s2) {
        String string = s1.encoding().value();
        String string2 = s2.encoding().value();
        if (string != null) {
            if (!string.equals(string2)) {
                return false;
            }
        } else if (string2 != null) return false;
        String string3 = s1.classpath().value();
        string2 = s2.classpath().value();
        if (string3 != null) {
            if (!string3.equals(string2)) {
                return false;
            }
        } else if (string2 != null) return false;
        String string4 = s1.sourcepath().value();
        string2 = s2.sourcepath().value();
        if (string4 != null) {
            if (!string4.equals(string2)) {
                return false;
            }
        } else if (string2 != null) return false;
        String string5 = s1.outdir().value();
        string2 = s2.outdir().value();
        if (string5 != null) {
            if (!string5.equals(string2)) {
                return false;
            }
        } else if (string2 != null) return false;
        String string6 = s1.bootclasspath().value();
        string2 = s2.bootclasspath().value();
        if (string6 != null) {
            if (!string6.equals(string2)) {
                return false;
            }
        } else if (string2 != null) return false;
        String string7 = s1.extdirs().value();
        string2 = s2.extdirs().value();
        if (string7 != null) {
            if (string7.equals(string2)) return true;
            return false;
        } else if (string2 == null) return true;
        return false;
    }

    public final void scala$tools$nsc$CompileServer$$progress_$eq(boolean x$1) {
        this.scala$tools$nsc$CompileServer$$progress = x$1;
    }

    public final boolean scala$tools$nsc$CompileServer$$progress() {
        return this.scala$tools$nsc$CompileServer$$progress;
    }

    private void scala$tools$nsc$CompileServer$$inSession_$eq(boolean x$1) {
        this.scala$tools$nsc$CompileServer$$inSession = x$1;
    }

    public final boolean scala$tools$nsc$CompileServer$$inSession() {
        return this.scala$tools$nsc$CompileServer$$inSession;
    }

    private void compiler_$eq(Global x$1) {
        this.compiler = x$1;
    }

    private Global compiler() {
        return this.compiler;
    }

    public void shutDown_$eq(boolean x$1) {
        this.shutDown = x$1;
    }

    public boolean shutDown() {
        return this.shutDown;
    }

    public double MaxCharge() {
        return this.MaxCharge;
    }

    public String versionMsg() {
        return this.versionMsg;
    }
}

