/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.Installer;
import com.izforge.izpack.util.OsVersion;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class Debug {
    public static final String DLOG = "LOG";
    public static final String DSTACKTRACE = "STACKTRACE";
    public static final String DTRACE = "TRACE";
    public static final String IZPACK_LOGFILE = "izpack.logfile";
    private static boolean TRACE;
    private static boolean STACKTRACE;
    private static boolean LOG;
    public static String LOGFILE_PREFIX;
    public static String LOGFILE_EXTENSION;
    public static String LOGFILENAME;
    private static BufferedWriter fw;
    private static PrintWriter logfile;

    public static void trace(Object s) {
        if (TRACE) {
            System.out.println(s);
            if (STACKTRACE && s instanceof Throwable) {
                ((Throwable)s).printStackTrace();
            }
            System.out.flush();
        }
    }

    public static void error(Object s) {
        Debug.trace(s);
        System.err.println(s);
        System.err.flush();
        Debug.log(s);
    }

    public static void log(Object o) {
        if (LOG) {
            logfile = Debug.getLogFile();
            if (logfile == null) {
                logfile = Debug.createLogFile();
            }
            if (logfile != null) {
                if (o == null) {
                    o = "null";
                }
                logfile.println(o);
                if (o instanceof Throwable) {
                    ((Throwable)o).printStackTrace(logfile);
                }
                logfile.flush();
            } else {
                System.err.println("Cannot write into logfile: (" + logfile + ") <- '" + o + "'");
            }
        }
    }

    private static PrintWriter createLogFile() {
        String tempDir = System.getProperty("java.io.tmpdir");
        File tempDirFile = new File(tempDir);
        try {
            tempDirFile.mkdirs();
        }
        catch (RuntimeException e1) {
            e1.printStackTrace();
        }
        String logfilename = LOGFILENAME;
        System.out.println("creating Logfile: '" + logfilename + "' in: '" + tempDir + "'");
        File out = new File(tempDir, logfilename);
        if (tempDirFile.canWrite()) {
            try {
                fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), "UTF-8"));
                logfile = Debug.setLogFile(new PrintWriter(fw));
            }
            catch (Exception e) {
                logfile = null;
                e.printStackTrace();
            }
        } else {
            logfile = null;
            System.err.println("Fatal: cannot write File: '" + logfilename + "' into: " + tempDirFile);
        }
        return logfile;
    }

    public static boolean tracing() {
        return TRACE;
    }

    public static boolean stackTracing() {
        return STACKTRACE;
    }

    public static boolean isLOG() {
        return LOG;
    }

    public static void setLOG(boolean aFlag) {
        System.out.println("LOG = " + aFlag);
        LOG = aFlag;
    }

    public static boolean isSTACKTRACE() {
        return STACKTRACE;
    }

    public static void setSTACKTRACE(boolean aFlag) {
        System.out.println("STACKTRACE = " + aFlag);
        STACKTRACE = aFlag;
    }

    public static boolean isTRACE() {
        return TRACE;
    }

    public static void setTRACE(boolean aFlag) {
        System.out.println("TRACE = " + aFlag);
        TRACE = aFlag;
    }

    public static PrintWriter getLogFile() {
        logfile = (PrintWriter)System.getProperties().get(IZPACK_LOGFILE);
        return logfile;
    }

    public static synchronized PrintWriter setLogFile(PrintWriter aLogFile) {
        System.getProperties().put(IZPACK_LOGFILE, aLogFile);
        logfile = (PrintWriter)System.getProperties().get(IZPACK_LOGFILE);
        if (logfile == null) {
            System.err.println("Set::logfile == null");
        }
        return logfile;
    }

    static {
        LOGFILE_PREFIX = "IzPack_Logfile_at_";
        LOGFILE_EXTENSION = ".txt";
        LOGFILENAME = LOGFILE_PREFIX + System.currentTimeMillis() + LOGFILE_EXTENSION;
        boolean st = false;
        try {
            st = Boolean.getBoolean(DSTACKTRACE);
        }
        catch (Exception ex) {
            // empty catch block
        }
        STACKTRACE = st;
        boolean log = false;
        try {
            log = Boolean.getBoolean(DLOG);
        }
        catch (Exception ex) {
            // empty catch block
        }
        LOG = log;
        boolean t = false;
        try {
            t = STACKTRACE ? true : Boolean.getBoolean(DTRACE);
        }
        catch (Exception ex) {
            // empty catch block
        }
        TRACE = t;
        if (LOG) {
            System.out.println("LOG enabled.");
            logfile = Debug.createLogFile();
            Debug.log(Installer.class.getName() + " LogFile created at " + new Date(System.currentTimeMillis()));
            Debug.log("System.Properties:");
            Properties sysProps = System.getProperties();
            Enumeration<Object> spe = sysProps.keys();
            while (spe.hasMoreElements()) {
                String aKey = (String)spe.nextElement();
                Debug.log(aKey + "  =  " + sysProps.getProperty(aKey));
            }
            Debug.log("\n==========================================\n");
            Debug.log("\n " + Installer.class.getName() + " installs on: \n");
            Debug.log(OsVersion.getOsDetails());
            Debug.log("\n==========================================\n");
        }
        if (TRACE) {
            System.out.println("TRACE enabled.");
        }
        if (STACKTRACE) {
            System.out.println("STACKTRACE enabled.");
        }
    }
}

