/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLLicencePanel
extends IzPanel
implements HyperlinkListener,
ActionListener {
    private static final long serialVersionUID = 3256728385458746416L;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    private JLabel infoLabel;
    private JEditorPane textArea;
    private JRadioButton yesRadio;
    private JRadioButton noRadio;

    public HTMLLicencePanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        this.setLayout(this.layout);
        this.loadLicence();
        this.infoLabel = LabelFactory.create(parent.langpack.getString("LicencePanel.info"), parent.icons.getImageIcon("history"), 11);
        parent.buildConstraints(this.gbConstraints, 0, 0, 2, 1, 1.0, 0.0);
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 17;
        this.layout.addLayoutComponent(this.infoLabel, this.gbConstraints);
        this.add(this.infoLabel);
        try {
            this.textArea = new JEditorPane();
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(this);
            JScrollPane scroller = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadLicence());
            parent.buildConstraints(this.gbConstraints, 0, 1, 2, 1, 1.0, 1.0);
            this.gbConstraints.anchor = 10;
            this.gbConstraints.fill = 1;
            this.layout.addLayoutComponent(scroller, this.gbConstraints);
            this.add(scroller);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        ButtonGroup group = new ButtonGroup();
        this.yesRadio = new JRadioButton(parent.langpack.getString("LicencePanel.agree"), false);
        group.add(this.yesRadio);
        parent.buildConstraints(this.gbConstraints, 0, 2, 1, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 17;
        this.gbConstraints.fill = 0;
        this.layout.addLayoutComponent(this.yesRadio, this.gbConstraints);
        this.add(this.yesRadio);
        this.yesRadio.addActionListener(this);
        this.noRadio = new JRadioButton(parent.langpack.getString("LicencePanel.notagree"), true);
        group.add(this.noRadio);
        parent.buildConstraints(this.gbConstraints, 0, 3, 1, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 17;
        this.gbConstraints.fill = 0;
        this.gbConstraints.insets = new Insets(0, 5, 5, 5);
        this.layout.addLayoutComponent(this.noRadio, this.gbConstraints);
        this.add(this.noRadio);
        this.noRadio.addActionListener(this);
        this.setInitialFocus(this.textArea);
    }

    private URL loadLicence() {
        String resNamePrifix = "HTMLLicencePanel.licence";
        try {
            return ResourceManager.getInstance().getURL(resNamePrifix);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.textArea.setPage(e.getURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }
}

