/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.Array$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.Reporter;
import scala.reflect.internal.util.NoPosition$;
import scala.reflect.io.AbstractFile;
import scala.reflect.io.PlainFile;
import scala.reflect.io.VirtualFile;
import scala.reflect.io.ZipArchive;
import scala.tools.nsc.io.SourceReader$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u000b\u0017\u0001}A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t_\u0001\u0011\t\u0011)A\u0005a!)\u0001\b\u0001C\u0001s!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002#\u0001A\u0003%\u0001\tC\u0004F\u0001\u0001\u0007I\u0011\u0002$\t\u000f)\u0003\u0001\u0019!C\u0005\u0017\"1\u0011\u000b\u0001Q!\n\u001dCQA\u0015\u0001\u0005\nMCQ\u0001\u001c\u0001\u0005\u00025DQ\u0001\u001c\u0001\u0005\u0002qDa\u0001\u001c\u0001\u0005\u0012\u0005\r\u0001B\u00027\u0001\t#\t)\u0002C\u0004\u0002\u001a\u0001!I!a\u0007\b\u000f\u0005}a\u0003#\u0001\u0002\"\u00191QC\u0006E\u0001\u0003GAa\u0001\u000f\t\u0005\u0002\u0005\u0015\u0002bBA\u0014!\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003w\u0001B\u0011AA\u001f\u0011\u001d\t\u0019\u0005\u0005C\u0005\u0003\u000b\u0012AbU8ve\u000e,'+Z1eKJT!a\u0006\r\u0002\u0005%|'BA\r\u001b\u0003\rq7o\u0019\u0006\u00037q\tQ\u0001^8pYNT\u0011!H\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"E5\tA$\u0003\u0002$9\t1\u0011I\\=SK\u001a\fq\u0001Z3d_\u0012,'\u000f\u0005\u0002'[5\tqE\u0003\u0002)S\u000591\r[1sg\u0016$(B\u0001\u0016,\u0003\rq\u0017n\u001c\u0006\u0002Y\u0005!!.\u0019<b\u0013\tqsE\u0001\bDQ\u0006\u00148/\u001a;EK\u000e|G-\u001a:\u0002\u0011I,\u0007o\u001c:uKJ\u0004\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\u0011%tG/\u001a:oC2T!!\u000e\u000f\u0002\u000fI,g\r\\3di&\u0011qG\r\u0002\t%\u0016\u0004xN\u001d;fe\u00061A(\u001b8jiz\"2A\u000f\u001f>!\tY\u0004!D\u0001\u0017\u0011\u0015!3\u00011\u0001&\u0011\u0015y3\u00011\u00011\u0003\u0015\u0011\u0017\u0010^3t+\u0005\u0001\u0005CA!C\u001b\u0005I\u0013BA\"*\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\u0007Ef$Xm\u001d\u0011\u0002\u000b\rD\u0017M]:\u0016\u0003\u001d\u0003\"!\u0011%\n\u0005%K#AC\"iCJ\u0014UO\u001a4fe\u0006I1\r[1sg~#S-\u001d\u000b\u0003\u0019>\u0003\"!I'\n\u00059c\"\u0001B+oSRDq\u0001U\u0004\u0002\u0002\u0003\u0007q)A\u0002yIE\naa\u00195beN\u0004\u0013a\u0005:fa>\u0014H/\u00128d_\u0012LgnZ#se>\u0014Hc\u0001'UC\")Q+\u0003a\u0001-\u0006Aa-\u001b7f]\u0006lW\r\u0005\u0002X=:\u0011\u0001\f\u0018\t\u00033ri\u0011A\u0017\u0006\u00037z\ta\u0001\u0010:p_Rt\u0014BA/\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005uc\u0002\"\u00022\n\u0001\u0004\u0019\u0017!A3\u0011\u0005\u0011LgBA3h\u001d\tIf-C\u0001\u001e\u0013\tAG$A\u0004qC\u000e\\\u0017mZ3\n\u0005)\\'!C#yG\u0016\u0004H/[8o\u0015\tAG$\u0001\u0003sK\u0006$GC\u00018u!\r\ts.]\u0005\u0003ar\u0011Q!\u0011:sCf\u0004\"!\t:\n\u0005Md\"\u0001B\"iCJDQ!\u001e\u0006A\u0002Y\fAAZ5mKB\u0011q/\u001f\b\u0003waL!\u0001\u001b\f\n\u0005i\\(!\u0002&GS2,'B\u00015\u0017)\tqW\u0010C\u0003v\u0017\u0001\u0007a\u0010\u0005\u0002x\u007f&\u0019\u0011\u0011A>\u0003\u0019\u0005\u00137\u000f\u001e:bGR4\u0015\u000e\\3\u0015\u00079\f)\u0001C\u0004\u0002\b1\u0001\r!!\u0003\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004*\u0003!\u0019\u0007.\u00198oK2\u001c\u0018\u0002BA\n\u0003\u001b\u00111CU3bI\u0006\u0014G.\u001a\"zi\u0016\u001c\u0005.\u00198oK2$2A\\A\f\u0011\u0015qT\u00021\u0001A\u0003%!XM]7j]\u0006$X\rF\u0002o\u0003;AQ!\u0012\bA\u0002\u001d\u000bAbU8ve\u000e,'+Z1eKJ\u0004\"a\u000f\t\u0014\u0005A\u0001CCAA\u0011\u0003\u0019!WmY8eKRIq)a\u000b\u0002.\u0005=\u0012\u0011\u0007\u0005\u0006II\u0001\r!\n\u0005\u0006}I\u0001\r\u0001\u0011\u0005\u0006\u000bJ\u0001\ra\u0012\u0005\b\u0003g\u0011\u0002\u0019AA\u001b\u0003))g\u000eZ(g\u0013:\u0004X\u000f\u001e\t\u0004C\u0005]\u0012bAA\u001d9\t9!i\\8mK\u0006t\u0017!\u00024mkNDG#B$\u0002@\u0005\u0005\u0003\"\u0002\u0013\u0014\u0001\u0004)\u0003\"B#\u0014\u0001\u00049\u0015\u0001E5oGJ,\u0017m]3DCB\f7-\u001b;z)\r9\u0015q\t\u0005\u0007\u0003\u0013\"\u0002\u0019A$\u0002\r\t,hMZ3s\u0001")
public class SourceReader {
    private final CharsetDecoder decoder;
    private final Reporter reporter;
    private final ByteBuffer bytes;
    private CharBuffer chars;

    public static CharBuffer flush(CharsetDecoder charsetDecoder, CharBuffer charBuffer) {
        return SourceReader$.MODULE$.flush(charsetDecoder, charBuffer);
    }

    public static CharBuffer decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
        return SourceReader$.MODULE$.decode(charsetDecoder, byteBuffer, charBuffer, bl);
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private void chars_$eq(CharBuffer x$1) {
        this.chars = x$1;
    }

    private void reportEncodingError(String filename, Exception e) {
        String advice = "Please try specifying another one using the -encoding option";
        this.reporter.error(NoPosition$.MODULE$, new StringBuilder(33).append("IO error while decoding ").append(filename).append(" with ").append(this.decoder.charset()).append(": ").append(e.getMessage()).append("\n").append(advice).toString());
    }

    public char[] read(File file) {
        char[] cArray;
        try (FileChannel c = new FileInputStream(file).getChannel();){
            try {
                cArray = this.read(c);
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                throw new InterruptedException();
            }
            catch (Exception e) {
                this.reportEncodingError(String.valueOf(file), e);
                cArray = (char[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Char());
            }
        }
        return cArray;
    }

    public char[] read(AbstractFile file) {
        try {
            char[] cArray;
            if (file instanceof PlainFile) {
                PlainFile plainFile = (PlainFile)file;
                cArray = this.read(plainFile.file());
            } else if (file instanceof ZipArchive.Entry) {
                char[] cArray2;
                try (ReadableByteChannel c = Channels.newChannel(((ZipArchive.Entry)file).input());){
                    cArray2 = this.read(c);
                }
                cArray = cArray2;
            } else if (file instanceof VirtualFile) {
                VirtualFile virtualFile = (VirtualFile)file;
                cArray = this.read(ByteBuffer.wrap(virtualFile.unsafeToByteArray()));
            } else {
                char[] cArray3;
                try (ReadableByteChannel c = Channels.newChannel(file.input());){
                    cArray3 = this.read(c);
                }
                cArray = cArray3;
            }
            return cArray;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            this.reportEncodingError(String.valueOf(file), e);
            return (char[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Char());
        }
    }

    public char[] read(ReadableByteChannel input) {
        CharsetDecoder decoder = this.decoder.reset();
        ByteBuffer bytes = this.bytes();
        bytes.clear();
        CharBuffer chars = this.chars();
        chars.clear();
        boolean endOfInput = false;
        while (!endOfInput) {
            endOfInput = input.read(bytes) < 0;
            bytes.flip();
            chars = SourceReader$.MODULE$.decode(decoder, bytes, chars, endOfInput);
        }
        return this.terminate(SourceReader$.MODULE$.flush(decoder, chars));
    }

    public char[] read(ByteBuffer bytes) {
        CharsetDecoder decoder = this.decoder.reset();
        CharBuffer chars = this.chars();
        chars.clear();
        return this.terminate(SourceReader$.MODULE$.flush(decoder, SourceReader$.MODULE$.decode(decoder, bytes, chars, true)));
    }

    /*
     * WARNING - void declaration
     */
    private char[] terminate(CharBuffer chars) {
        void var2_2;
        char[] result = new char[chars.length()];
        chars.get(result);
        this.chars_$eq(chars);
        return var2_2;
    }

    public SourceReader(CharsetDecoder decoder, Reporter reporter) {
        this.decoder = decoder;
        this.reporter = reporter;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }
}

