/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.Actor;
import akka.actor.ActorCell;
import akka.actor.ActorInterruptedException;
import akka.actor.ActorRef;
import akka.actor.ChildRestartStats;
import akka.actor.Failed;
import akka.actor.InternalActorRef;
import akka.actor.PostRestartException;
import akka.actor.PreRestartException;
import akka.actor.dungeon.ChildrenContainer;
import akka.actor.dungeon.ChildrenContainer$Termination$;
import akka.dispatch.ChildTerminated;
import akka.dispatch.NullMessage$;
import akka.dispatch.SystemMessage;
import akka.event.Logging;
import akka.event.Logging$;
import akka.event.Logging$Error$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public abstract class FaultHandling$class {
    private static void suspendNonRecursive(ActorCell $this) {
        $this.dispatcher().suspend($this);
    }

    private static void resumeNonRecursive(ActorCell $this) {
        $this.dispatcher().resume($this);
    }

    private static boolean isFailed(ActorCell $this) {
        return $this.akka$actor$dungeon$FaultHandling$$_failed() != null;
    }

    private static void setFailed(ActorCell $this, ActorRef perpetrator) {
        $this.akka$actor$dungeon$FaultHandling$$_failed_$eq(perpetrator);
    }

    private static void clearFailed(ActorCell $this) {
        $this.akka$actor$dungeon$FaultHandling$$_failed_$eq(null);
    }

    private static ActorRef perpetrator(ActorCell $this) {
        return $this.akka$actor$dungeon$FaultHandling$$_failed();
    }

    public static void faultRecreate(ActorCell $this, Throwable cause) {
        block10: {
            Actor failedActor;
            block12: {
                block11: {
                    block9: {
                        if ($this.actor() != null) break block9;
                        $this.system().eventStream().publish(Logging$Error$.MODULE$.apply($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"changing Recreate into Create after ").append((Object)cause).toString()));
                        $this.faultCreate();
                        break block10;
                    }
                    if (!$this.isNormal()) break block11;
                    failedActor = $this.actor();
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(failedActor), "restarting"));
                    }
                    if (failedActor == null) break block12;
                    None$ optionalMessage = $this.currentMessage() != null ? new Some($this.currentMessage().message()) : None$.MODULE$;
                    try {
                        if (failedActor.context() != null) {
                            failedActor.preRestart(cause, (Option<Object>)optionalMessage);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            PreRestartException ex = new PreRestartException($this.self(), e, cause, (Option<Object>)optionalMessage);
                            $this.publish(new Logging.Error(ex, $this.self().path().toString(), $this.clazz(failedActor), e.getMessage()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        finally {
                            $this.clearActorFields(failedActor);
                        }
                    }
                }
                $this.faultResume(null);
                break block10;
            }
            Predef$.MODULE$.assert($this.mailbox().isSuspended(), (Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ActorCell $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"mailbox must be suspended during restart, status=").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.mailbox().status())).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            if (!$this.setChildrenTerminationReason(new ChildrenContainer.Recreation(cause))) {
                FaultHandling$class.finishRecreate($this, cause, failedActor);
            }
        }
    }

    public static void faultSuspend(ActorCell $this) {
        FaultHandling$class.suspendNonRecursive($this);
        $this.suspendChildren($this.suspendChildren$default$1());
    }

    public static void faultResume(ActorCell $this, Throwable causedByFailure) {
        if ($this.actor() == null) {
            $this.system().eventStream().publish(Logging$Error$.MODULE$.apply($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"changing Resume into Create after ").append((Object)causedByFailure).toString()));
            $this.faultCreate();
        } else if ($this.actor().context() == null && causedByFailure != null) {
            $this.system().eventStream().publish(Logging$Error$.MODULE$.apply($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"changing Resume into Restart after ").append((Object)causedByFailure).toString()));
            $this.faultRecreate(causedByFailure);
        } else {
            ActorRef perp = FaultHandling$class.perpetrator($this);
            FaultHandling$class.resumeNonRecursive($this);
            $this.resumeChildren(causedByFailure, perp);
        }
        return;
        finally {
            if (causedByFailure != null) {
                FaultHandling$class.clearFailed($this);
            }
        }
    }

    public static void faultCreate(ActorCell $this) {
        Predef$.MODULE$.assert($this.mailbox().isSuspended(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"mailbox must be suspended during failed creation, status=").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.mailbox().status())).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ActorRef actorRef = FaultHandling$class.perpetrator($this);
        InternalActorRef internalActorRef = $this.self();
        Predef$.MODULE$.assert(!(actorRef != null ? !((Object)actorRef).equals(internalActorRef) : internalActorRef != null));
        $this.setReceiveTimeout((Duration)Duration$.MODULE$.Undefined());
        $this.cancelReceiveTimeout();
        $this.children().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final void apply(ActorRef actor) {
                this.$outer.stop(actor);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (!$this.setChildrenTerminationReason(new ChildrenContainer.Creation())) {
            FaultHandling$class.finishCreate($this);
        }
    }

    private static void finishCreate(ActorCell $this) {
        try {
            FaultHandling$class.resumeNonRecursive($this);
            $this.create($this.uid());
            return;
        }
        finally {
            FaultHandling$class.clearFailed($this);
        }
    }

    public static void terminate(ActorCell $this) {
        $this.setReceiveTimeout((Duration)Duration$.MODULE$.Undefined());
        $this.cancelReceiveTimeout();
        $this.children().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final void apply(ActorRef actor) {
                this.$outer.stop(actor);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        boolean wasTerminating = $this.isTerminating();
        if ($this.setChildrenTerminationReason(ChildrenContainer$Termination$.MODULE$)) {
            if (!wasTerminating) {
                FaultHandling$class.suspendNonRecursive($this);
                FaultHandling$class.setFailed($this, $this.self());
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz($this.actor()), "stopping"));
                }
            }
        } else {
            $this.setTerminated();
            FaultHandling$class.finishTerminate($this);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final void handleInvokeFailure(ActorCell $this, Iterable childrenNotToSuspend, Throwable t, String message) {
        block9: {
            $this.publish(new Logging.Error(t, $this.self().path().toString(), $this.clazz($this.actor()), message));
            if (FaultHandling$class.isFailed($this)) break block9;
            try {
                FaultHandling$class.suspendNonRecursive($this);
                var11_4 = $this.currentMessage();
                if (var11_4 == null) ** GOTO lbl-1000
                var12_5 = var11_4.message();
                child = var11_4.sender();
                if (var12_5 instanceof Failed) {
                    FaultHandling$class.setFailed($this, child);
                    var14_7 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ActorRef[]{child}));
                } else lbl-1000:
                // 2 sources

                {
                    FaultHandling$class.setFailed($this, $this.self());
                    var14_7 = Predef$.MODULE$.Set().empty();
                }
                skip = var14_7;
                $this.suspendChildren((Set<ActorRef>)((Set)skip.$plus$plus((GenTraversableOnce)childrenNotToSuspend)));
                var15_9 = t;
                if (var15_9 instanceof InterruptedException) {
                    $this.parent().tell(new Failed(new ActorInterruptedException(t), $this.uid()), $this.self());
                    Thread.interrupted();
                    throw t;
                }
                $this.parent().tell(new Failed(t, $this.uid()), $this.self());
                var16_10 = BoxedUnit.UNIT;
            }
            catch (Throwable var4_11) {
                var5_12 = var4_11;
                var6_13 = NonFatal$.MODULE$.unapply(var5_12);
                if (var6_13.isEmpty()) {
                    throw var4_11;
                }
                e = (Throwable)var6_13.get();
                $this.publish(new Logging.Error(e, $this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"emergency stop: exception in failure handling for ").append(t.getClass()).append((Object)Logging$.MODULE$.stackTraceFor(t)).toString()));
                $this.children().foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ActorCell $outer;

                    public final void apply(ActorRef actor) {
                        this.$outer.stop(actor);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                var8_15 = BoxedUnit.UNIT;
            }
        }
        return;
        {
            finally {
                FaultHandling$class.finishTerminate($this);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void finishTerminate(ActorCell $this) {
        void var1_1;
        Actor a = $this.actor();
        try {
            try {
                if (a != null) {
                    a.postStop();
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                $this.publish(new Logging.Error(e, $this.self().path().toString(), $this.clazz(a), e.getMessage()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        catch (Throwable throwable) {
            try {
                $this.dispatcher().detach($this);
            }
            finally {
                try {
                    $this.parent().sendSystemMessage(new ChildTerminated($this.self()));
                }
                finally {
                    try {
                        NullMessage$ x$1 = NullMessage$.MODULE$;
                        ActorRef x$2 = $this.parent().$bang$default$2(x$1);
                        $this.parent().$bang(x$1, x$2);
                    }
                    finally {
                        try {
                            $this.tellWatchersWeDied(a);
                        }
                        finally {
                            try {
                                $this.unwatchWatchedActors(a);
                            }
                            finally {
                                if ($this.system().settings().DebugLifecycle()) {
                                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                                }
                                $this.clearActorFields(a);
                                $this.actor_$eq(null);
                            }
                        }
                    }
                }
            }
            throw throwable;
        }
        try {
            $this.dispatcher().detach($this);
        }
        catch (Throwable throwable) {
            try {
                $this.parent().sendSystemMessage(new ChildTerminated($this.self()));
            }
            catch (Throwable throwable3) {
                try {
                    NullMessage$ x$1 = NullMessage$.MODULE$;
                    ActorRef x$2 = $this.parent().$bang$default$2(x$1);
                    $this.parent().$bang(x$1, x$2);
                }
                catch (Throwable throwable4) {
                    try {
                        $this.tellWatchersWeDied((Actor)var1_1);
                    }
                    catch (Throwable throwable5) {
                        try {
                            $this.unwatchWatchedActors((Actor)var1_1);
                            throw throwable5;
                        }
                        finally {
                            if ($this.system().settings().DebugLifecycle()) {
                                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                            }
                            $this.clearActorFields((Actor)var1_1);
                            $this.actor_$eq(null);
                        }
                    }
                    try {
                        $this.unwatchWatchedActors((Actor)var1_1);
                        throw throwable4;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                        }
                        $this.clearActorFields((Actor)var1_1);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.tellWatchersWeDied((Actor)var1_1);
                }
                catch (Throwable throwable6) {
                    try {
                        $this.unwatchWatchedActors((Actor)var1_1);
                        throw throwable6;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                        }
                        $this.clearActorFields((Actor)var1_1);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.unwatchWatchedActors((Actor)var1_1);
                    throw throwable3;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                    }
                    $this.clearActorFields((Actor)var1_1);
                    $this.actor_$eq(null);
                }
            }
            try {
                NullMessage$ x$1 = NullMessage$.MODULE$;
                ActorRef x$2 = $this.parent().$bang$default$2(x$1);
                $this.parent().$bang(x$1, x$2);
            }
            catch (Throwable throwable7) {
                try {
                    $this.tellWatchersWeDied((Actor)var1_1);
                }
                catch (Throwable throwable8) {
                    try {
                        $this.unwatchWatchedActors((Actor)var1_1);
                        throw throwable8;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                        }
                        $this.clearActorFields((Actor)var1_1);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.unwatchWatchedActors((Actor)var1_1);
                    throw throwable7;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                    }
                    $this.clearActorFields((Actor)var1_1);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.tellWatchersWeDied((Actor)var1_1);
            }
            catch (Throwable throwable9) {
                try {
                    $this.unwatchWatchedActors((Actor)var1_1);
                    throw throwable9;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                    }
                    $this.clearActorFields((Actor)var1_1);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.unwatchWatchedActors((Actor)var1_1);
                throw throwable;
            }
            finally {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                }
                $this.clearActorFields((Actor)var1_1);
                $this.actor_$eq(null);
            }
        }
        try {
            $this.parent().sendSystemMessage(new ChildTerminated($this.self()));
        }
        catch (Throwable throwable) {
            try {
                NullMessage$ x$1 = NullMessage$.MODULE$;
                ActorRef x$2 = $this.parent().$bang$default$2(x$1);
                $this.parent().$bang(x$1, x$2);
            }
            catch (Throwable throwable10) {
                try {
                    $this.tellWatchersWeDied((Actor)var1_1);
                }
                catch (Throwable throwable11) {
                    try {
                        $this.unwatchWatchedActors((Actor)var1_1);
                        throw throwable11;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                        }
                        $this.clearActorFields((Actor)var1_1);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.unwatchWatchedActors((Actor)var1_1);
                    throw throwable10;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                    }
                    $this.clearActorFields((Actor)var1_1);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.tellWatchersWeDied((Actor)var1_1);
            }
            catch (Throwable throwable12) {
                try {
                    $this.unwatchWatchedActors((Actor)var1_1);
                    throw throwable12;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                    }
                    $this.clearActorFields((Actor)var1_1);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.unwatchWatchedActors((Actor)var1_1);
                throw throwable;
            }
            finally {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                }
                $this.clearActorFields((Actor)var1_1);
                $this.actor_$eq(null);
            }
        }
        try {
            NullMessage$ x$1 = NullMessage$.MODULE$;
            ActorRef x$2 = $this.parent().$bang$default$2(x$1);
            $this.parent().$bang(x$1, x$2);
        }
        catch (Throwable throwable) {
            try {
                $this.tellWatchersWeDied((Actor)var1_1);
            }
            catch (Throwable throwable13) {
                try {
                    $this.unwatchWatchedActors((Actor)var1_1);
                    throw throwable13;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                    }
                    $this.clearActorFields((Actor)var1_1);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.unwatchWatchedActors((Actor)var1_1);
                throw throwable;
            }
            finally {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                }
                $this.clearActorFields((Actor)var1_1);
                $this.actor_$eq(null);
            }
        }
        try {
            $this.tellWatchersWeDied(a);
        }
        catch (Throwable throwable) {
            try {
                $this.unwatchWatchedActors((Actor)var1_1);
                throw throwable;
            }
            finally {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
                }
                $this.clearActorFields((Actor)var1_1);
                $this.actor_$eq(null);
            }
        }
        try {
            $this.unwatchWatchedActors(a);
            if ($this.system().settings().DebugLifecycle()) {
                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
            }
            $this.clearActorFields(a);
            $this.actor_$eq(null);
            return;
        }
        catch (Throwable throwable) {
            if ($this.system().settings().DebugLifecycle()) {
                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(var1_1), "stopped"));
            }
            $this.clearActorFields((Actor)var1_1);
            $this.actor_$eq(null);
            throw throwable;
        }
    }

    private static void finishRecreate(ActorCell $this, Throwable cause, Actor failedActor) {
        block8: {
            Iterable<ActorRef> survivors = $this.children();
            try {
                Actor freshActor;
                block7: {
                    FaultHandling$class.resumeNonRecursive($this);
                    freshActor = $this.newActor();
                    $this.actor_$eq(freshActor);
                    if (freshActor == failedActor) {
                        $this.setActorFields(freshActor, $this, $this.self());
                    }
                    freshActor.postRestart(cause);
                    if (!$this.system().settings().DebugLifecycle()) break block7;
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(freshActor), "restarted"));
                }
                survivors.foreach((Function1)new Serializable($this, cause, freshActor){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ActorCell $outer;
                    private final Throwable cause$1;
                    private final Actor freshActor$1;

                    public final void apply(ActorRef child) {
                        try {
                            ((InternalActorRef)child).restart(this.cause$1);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            this.$outer.publish(new Logging.Error(e, this.$outer.self().path().toString(), this.$outer.clazz(this.freshActor$1), new StringBuilder().append((Object)"restarting ").append((Object)child).toString()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.cause$1 = cause$1;
                        this.freshActor$1 = freshActor$1;
                    }
                });
                break block8;
                finally {
                    FaultHandling$class.clearFailed($this);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                $this.clearActorFields($this.actor());
                $this.handleInvokeFailure(survivors, new PostRestartException((ActorRef)$this.self(), e, cause), e.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final void handleFailure(ActorCell $this, ActorRef child, Throwable cause, int uid) {
        Option<ChildRestartStats> option;
        block6: {
            block4: {
                block5: {
                    Some some;
                    boolean bl;
                    block2: {
                        block3: {
                            bl = false;
                            some = null;
                            option = $this.getChildByRef(child);
                            if (!(option instanceof Some)) break block2;
                            bl = true;
                            some = (Some)option;
                            ChildRestartStats stats2 = (ChildRestartStats)some.x();
                            if (stats2.uid() != uid) break block2;
                            if (!$this.actor().supervisorStrategy().handleFailure($this, child, cause, stats2, $this.getAllChildStats())) break block3;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        throw cause;
                    }
                    if (!bl) break block5;
                    ChildRestartStats stats3 = (ChildRestartStats)some.x();
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"dropping Failed(").append((Object)cause).append((Object)") from old child ").append((Object)child).append((Object)" (uid=").append((Object)BoxesRunTime.boxToInteger((int)stats3.uid())).append((Object)" != ").append((Object)BoxesRunTime.boxToInteger((int)uid)).append((Object)")").toString()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                None$ none$ = None$.MODULE$;
                Option<ChildRestartStats> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"dropping Failed(").append((Object)cause).append((Object)") from unknown child ").append((Object)child).toString()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final SystemMessage handleChildTerminated(ActorCell $this, ActorRef child) {
        ChildrenContainer.SuspendReason c;
        Option<ChildrenContainer.SuspendReason> status = $this.removeChildAndGetStateChange(child);
        if ($this.actor() != null) {
            try {
                $this.actor().supervisorStrategy().handleChildTerminated($this, child, $this.children());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                $this.handleInvokeFailure((Iterable<ActorRef>)Nil$.MODULE$, e, "handleChildTerminated failed");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        boolean bl = false;
        Some some = null;
        Option<ChildrenContainer.SuspendReason> option = status;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ChildrenContainer.SuspendReason c2 = (ChildrenContainer.SuspendReason)some.x();
            if (c2 instanceof ChildrenContainer.Recreation) {
                ChildrenContainer.Recreation recreation = (ChildrenContainer.Recreation)c2;
                Throwable cause = recreation.cause();
                FaultHandling$class.finishRecreate($this, cause, $this.actor());
                return recreation.dequeueAll();
            }
        }
        if (bl && (c = (ChildrenContainer.SuspendReason)some.x()) instanceof ChildrenContainer.Creation) {
            ChildrenContainer.Creation creation = (ChildrenContainer.Creation)c;
            FaultHandling$class.finishCreate($this);
            return creation.dequeueAll();
        }
        if (!bl) return null;
        ChildrenContainer.SuspendReason suspendReason = (ChildrenContainer.SuspendReason)some.x();
        ChildrenContainer$Termination$ childrenContainer$Termination$ = ChildrenContainer$Termination$.MODULE$;
        ChildrenContainer.SuspendReason suspendReason2 = suspendReason;
        if (childrenContainer$Termination$ == null) {
            if (suspendReason2 != null) {
                return null;
            }
        } else if (!childrenContainer$Termination$.equals(suspendReason2)) return null;
        FaultHandling$class.finishTerminate($this);
        return null;
    }

    public static void $init$(ActorCell $this) {
        $this.akka$actor$dungeon$FaultHandling$$_failed_$eq(null);
    }
}

