/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.ActorCell;
import akka.actor.ActorRef;
import akka.actor.dungeon.AbstractActorCell;
import akka.dispatch.Create;
import akka.dispatch.Envelope$;
import akka.dispatch.Mailbox;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.NullMessage$;
import akka.dispatch.Recreate;
import akka.dispatch.Resume;
import akka.dispatch.Supervise;
import akka.dispatch.Suspend;
import akka.dispatch.SystemMessage;
import akka.dispatch.Terminate;
import akka.event.Logging;
import akka.util.Unsafe;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public abstract class Dispatch$class {
    public static final Mailbox mailbox(ActorCell $this) {
        return (Mailbox)Unsafe.instance.getObjectVolatile($this, AbstractActorCell.mailboxOffset);
    }

    public static final Mailbox swapMailbox(ActorCell $this, Mailbox newMailbox) {
        while (true) {
            Mailbox oldMailbox;
            if (!Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.mailboxOffset, oldMailbox = $this.mailbox(), newMailbox)) continue;
            return oldMailbox;
        }
    }

    public static final boolean hasMessages(ActorCell $this) {
        return $this.mailbox().hasMessages();
    }

    public static final int numberOfMessages(ActorCell $this) {
        return $this.mailbox().numberOfMessages();
    }

    public static final MessageDispatcher getDispatcher(ActorCell $this) {
        return $this.dispatcher();
    }

    public static final boolean isTerminated(ActorCell $this) {
        return $this.mailbox().isClosed();
    }

    public static final ActorCell init(ActorCell $this, int uid, boolean sendSupervise) {
        $this.swapMailbox($this.dispatcher().createMailbox($this));
        $this.mailbox().setActor($this);
        $this.mailbox().systemEnqueue($this.self(), new Create(uid));
        if (sendSupervise) {
            $this.parent().sendSystemMessage(new Supervise($this.self(), false, uid));
            NullMessage$ x$1 = NullMessage$.MODULE$;
            ActorRef x$2 = $this.parent().$bang$default$2(x$1);
            $this.parent().$bang(x$1, x$2);
        }
        return $this;
    }

    public static final ActorCell start(ActorCell $this) {
        $this.dispatcher().attach($this);
        return $this;
    }

    private static PartialFunction handleException(ActorCell $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x7;
                if (A1 instanceof InterruptedException) {
                    InterruptedException interruptedException = (InterruptedException)A1;
                    this.$outer.system().eventStream().publish(new Logging.Error(interruptedException, this.$outer.self().path().toString(), this.$outer.clazz(this.$outer.actor()), "interrupted during message send"));
                    Thread.currentThread().interrupt();
                    object = BoxedUnit.UNIT;
                } else {
                    Option option = NonFatal$.MODULE$.unapply(A1);
                    if (option.isEmpty()) {
                        object = function1.apply(x7);
                    } else {
                        Throwable e = (Throwable)option.get();
                        this.$outer.system().eventStream().publish(new Logging.Error(e, this.$outer.self().path().toString(), this.$outer.clazz(this.$outer.actor()), "swallowing exception during message send"));
                        object = BoxedUnit.UNIT;
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x7) {
                Option option;
                Throwable throwable = x7;
                boolean bl = throwable instanceof InterruptedException ? true : !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static final void suspend(ActorCell $this) {
        Throwable throwable2;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Suspend());
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr1 = Dispatch$class.handleException($this);
                if (!catchExpr1.isDefinedAt((Object)throwable2)) break block2;
                catchExpr1.apply((Object)throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static final void resume(ActorCell $this, Throwable causedByFailure) {
        Throwable throwable2;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Resume(causedByFailure));
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr2 = Dispatch$class.handleException($this);
                if (!catchExpr2.isDefinedAt((Object)throwable2)) break block2;
                catchExpr2.apply((Object)throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static final void restart(ActorCell $this, Throwable cause) {
        Throwable throwable2;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Recreate(cause));
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr3 = Dispatch$class.handleException($this);
                if (!catchExpr3.isDefinedAt((Object)throwable2)) break block2;
                catchExpr3.apply((Object)throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static final void stop(ActorCell $this) {
        Throwable throwable2;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Terminate());
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr4 = Dispatch$class.handleException($this);
                if (!catchExpr4.isDefinedAt((Object)throwable2)) break block2;
                catchExpr4.apply((Object)throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static void tell(ActorCell $this, Object message, ActorRef sender) {
        Throwable throwable2;
        block2: {
            try {
                $this.dispatcher().dispatch($this, Envelope$.MODULE$.apply(message, sender == null ? $this.system().deadLetters() : sender, $this.system()));
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr5 = Dispatch$class.handleException($this);
                if (!catchExpr5.isDefinedAt((Object)throwable2)) break block2;
                catchExpr5.apply((Object)throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static void sendSystemMessage(ActorCell $this, SystemMessage message) {
        Throwable throwable2;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, message);
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr6 = Dispatch$class.handleException($this);
                if (!catchExpr6.isDefinedAt((Object)throwable2)) break block2;
                catchExpr6.apply((Object)throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static void $init$(ActorCell $this) {
        $this.akka$actor$dungeon$Dispatch$_setter_$dispatcher_$eq($this.system().dispatchers().lookup($this.props().dispatcher()));
    }
}

