/*
 * Decompiled with CFR 0.152.
 */
package akka.util.internal;

import akka.event.LoggingAdapter;
import akka.util.Unsafe;
import akka.util.internal.ConcurrentIdentityHashMap;
import akka.util.internal.ReusableIterator;
import akka.util.internal.Timeout;
import akka.util.internal.Timer;
import akka.util.internal.TimerTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class HashedWheelTimer
implements Timer {
    private final Worker worker = new Worker();
    final Thread workerThread;
    boolean shutdown = false;
    final long tickDuration;
    final Set<HashedWheelTimeout>[] wheel;
    final ReusableIterator<HashedWheelTimeout>[] iterators;
    final int mask;
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    final boolean isWindows;
    volatile int wheelCursor;
    private LoggingAdapter logger;

    public HashedWheelTimer(LoggingAdapter loggingAdapter, ThreadFactory threadFactory, Duration duration, int n) {
        boolean bl = this.isWindows = System.getProperty("os.name", "").toLowerCase().indexOf("win") >= 0;
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory");
        }
        if (duration == null) {
            throw new NullPointerException("duration");
        }
        if (duration.toNanos() <= 0L) {
            throw new IllegalArgumentException("duration must be greater than 0 ns: " + duration.toNanos());
        }
        if (n <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + n);
        }
        this.logger = loggingAdapter;
        this.wheel = HashedWheelTimer.createWheel(n);
        this.iterators = HashedWheelTimer.createIterators(this.wheel);
        this.mask = this.wheel.length - 1;
        this.tickDuration = duration.toNanos();
        if (this.tickDuration == Long.MAX_VALUE || this.tickDuration >= Long.MAX_VALUE / (long)this.wheel.length) {
            throw new IllegalArgumentException("tickDuration is too long: " + this.tickDuration + ' ' + (Object)((Object)duration.unit()));
        }
        this.workerThread = threadFactory.newThread(this.worker);
    }

    private static Set<HashedWheelTimeout>[] createWheel(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + n);
        }
        if (n > 0x40000000) {
            throw new IllegalArgumentException("ticksPerWheel may not be greater than 2^30: " + n);
        }
        Set[] setArray = new Set[HashedWheelTimer.normalizeTicksPerWheel(n)];
        for (int i = 0; i < setArray.length; ++i) {
            setArray[i] = Collections.newSetFromMap(new ConcurrentIdentityHashMap(16, 0.95f, 4));
        }
        return setArray;
    }

    private static ReusableIterator<HashedWheelTimeout>[] createIterators(Set<HashedWheelTimeout>[] setArray) {
        ReusableIterator[] reusableIteratorArray = new ReusableIterator[setArray.length];
        for (int i = 0; i < setArray.length; ++i) {
            reusableIteratorArray[i] = (ReusableIterator)setArray[i].iterator();
        }
        return reusableIteratorArray;
    }

    private static int normalizeTicksPerWheel(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        this.lock.readLock().lock();
        try {
            if (this.shutdown) {
                throw new IllegalStateException("cannot be started once stopped");
            }
            if (!this.workerThread.isAlive()) {
                this.workerThread.start();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<Timeout> stop() {
        if (Thread.currentThread() == this.workerThread) {
            throw new IllegalStateException(HashedWheelTimer.class.getSimpleName() + ".stop() cannot be called from " + TimerTask.class.getSimpleName());
        }
        this.lock.writeLock().lock();
        try {
            if (this.shutdown) {
                Set<Timeout> set = Collections.emptySet();
                return set;
            }
            this.shutdown = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        boolean bl = false;
        while (this.workerThread.isAlive()) {
            this.workerThread.interrupt();
            try {
                this.workerThread.join(100L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        HashSet<HashedWheelTimeout> hashSet = new HashSet<HashedWheelTimeout>();
        for (Set<HashedWheelTimeout> set : this.wheel) {
            hashSet.addAll(set);
            set.clear();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public HashedWheelTimeout createTimeout(TimerTask timerTask, long l) {
        return new HashedWheelTimeout(this, timerTask, l);
    }

    @Override
    public Timeout newTimeout(TimerTask timerTask, FiniteDuration finiteDuration) {
        long l = System.nanoTime();
        if (timerTask == null) {
            throw new NullPointerException("task");
        }
        if (finiteDuration == null) {
            throw new NullPointerException("delay");
        }
        if (!this.workerThread.isAlive()) {
            this.start();
        }
        HashedWheelTimeout hashedWheelTimeout = this.createTimeout(timerTask, l + finiteDuration.toNanos());
        this.scheduleTimeout(hashedWheelTimeout, finiteDuration.toNanos());
        return hashedWheelTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleTimeout(HashedWheelTimeout hashedWheelTimeout, long l) {
        long l2 = (l + this.tickDuration - 1L) / this.tickDuration;
        if (l2 < 0L) {
            l2 = l / this.tickDuration;
        }
        if (l2 == 0L) {
            l2 = 1L;
        }
        long l3 = l2 / (long)this.wheel.length;
        this.lock.readLock().lock();
        try {
            int n;
            if (this.shutdown) {
                throw new IllegalStateException("cannot enqueue after shutdown");
            }
            hashedWheelTimeout.stopIndex = n = (int)((long)this.wheelCursor + l2 & (long)this.mask);
            hashedWheelTimeout.remainingRounds = l3;
            this.wheel[n].add(hashedWheelTimeout);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static final class HashedWheelTimeout
    implements Timeout {
        private static final long _stateOffset;
        private static final int ST_INIT = 0;
        private static final int ST_CANCELLED = 1;
        private static final int ST_EXPIRED = 2;
        private final HashedWheelTimer parent;
        private final TimerTask task;
        final long deadline;
        volatile int stopIndex;
        volatile long remainingRounds;
        private volatile int _state = 0;

        HashedWheelTimeout(HashedWheelTimer hashedWheelTimer, TimerTask timerTask, long l) {
            this.parent = hashedWheelTimer;
            this.task = timerTask;
            this.deadline = l;
        }

        @Override
        public Timer getTimer() {
            return this.parent;
        }

        @Override
        public TimerTask getTask() {
            return this.task;
        }

        private final int state() {
            return Unsafe.instance.getIntVolatile(this, _stateOffset);
        }

        private final boolean updateState(int n, int n2) {
            return Unsafe.instance.compareAndSwapInt(this, _stateOffset, n, n2);
        }

        @Override
        public void cancel() {
            if (this.updateState(0, 1)) {
                this.parent.wheel[this.stopIndex].remove(this);
            }
        }

        @Override
        public boolean isCancelled() {
            return this.state() == 1;
        }

        @Override
        public boolean isExpired() {
            return this.state() != 0;
        }

        public void expire() {
            if (this.updateState(0, 2)) {
                try {
                    this.task.run(this);
                }
                catch (Throwable throwable) {
                    this.parent.logger.warning("An exception was thrown by " + TimerTask.class.getSimpleName() + ".", throwable);
                }
            }
        }

        public String toString() {
            long l = System.nanoTime();
            long l2 = this.deadline - l;
            StringBuilder stringBuilder = new StringBuilder(192);
            stringBuilder.append("HashedWheelTimeout");
            stringBuilder.append('(');
            stringBuilder.append("deadline: ");
            if (l2 > 0L) {
                stringBuilder.append(l2);
                stringBuilder.append(" ns later, ");
            } else if (l2 < 0L) {
                stringBuilder.append(-l2);
                stringBuilder.append(" ns ago, ");
            } else {
                stringBuilder.append("now, ");
            }
            if (this.isCancelled()) {
                stringBuilder.append(", cancelled");
            }
            return stringBuilder.append(')').toString();
        }

        static {
            try {
                _stateOffset = Unsafe.instance.objectFieldOffset(HashedWheelTimeout.class.getDeclaredField("_state"));
            }
            catch (Throwable throwable) {
                throw new ExceptionInInitializerError(throwable);
            }
        }
    }

    private final class Worker
    implements Runnable {
        private long startTime;
        private long tick;

        Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean shutdown() {
            HashedWheelTimer.this.lock.readLock().lock();
            try {
                boolean bl = HashedWheelTimer.this.shutdown;
                return bl;
            }
            finally {
                HashedWheelTimer.this.lock.readLock().unlock();
            }
        }

        @Override
        public void run() {
            this.startTime = System.nanoTime();
            this.tick = 1L;
            while (!this.shutdown()) {
                long l = this.waitForNextTick();
                if (l <= Long.MIN_VALUE) continue;
                this.notifyExpiredTimeouts(this.fetchExpiredTimeouts(l));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayList<HashedWheelTimeout> fetchExpiredTimeouts(long l) {
            HashedWheelTimer.this.lock.writeLock().lock();
            try {
                int n = HashedWheelTimer.this.wheelCursor = HashedWheelTimer.this.wheelCursor + 1 & HashedWheelTimer.this.mask;
                ArrayList<HashedWheelTimeout> arrayList = this.fetchExpiredTimeouts(HashedWheelTimer.this.iterators[n], l);
                return arrayList;
            }
            finally {
                HashedWheelTimer.this.lock.writeLock().unlock();
            }
        }

        private ArrayList<HashedWheelTimeout> fetchExpiredTimeouts(ReusableIterator<HashedWheelTimeout> reusableIterator, long l) {
            ArrayList<HashedWheelTimeout> arrayList = new ArrayList<HashedWheelTimeout>();
            ArrayList<Object> arrayList2 = null;
            reusableIterator.rewind();
            while (reusableIterator.hasNext()) {
                HashedWheelTimeout hashedWheelTimeout = (HashedWheelTimeout)reusableIterator.next();
                if (hashedWheelTimeout.remainingRounds <= 0L) {
                    reusableIterator.remove();
                    if (hashedWheelTimeout.deadline - l <= 0L) {
                        arrayList.add(hashedWheelTimeout);
                        continue;
                    }
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<Object>();
                    }
                    arrayList2.add(hashedWheelTimeout);
                    continue;
                }
                --hashedWheelTimeout.remainingRounds;
            }
            if (arrayList2 != null) {
                for (HashedWheelTimeout hashedWheelTimeout : arrayList2) {
                    HashedWheelTimer.this.scheduleTimeout(hashedWheelTimeout, hashedWheelTimeout.deadline - l);
                }
            }
            return arrayList;
        }

        private void notifyExpiredTimeouts(ArrayList<HashedWheelTimeout> arrayList) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                arrayList.get(i).expire();
            }
            arrayList.clear();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long waitForNextTick() {
            long l = this.startTime + HashedWheelTimer.this.tickDuration * this.tick;
            while (true) {
                long l2;
                long l3;
                if ((l3 = (l - (l2 = System.nanoTime()) + 999999L) / 1000000L) <= 0L) {
                    ++this.tick;
                    if (l2 != Long.MIN_VALUE) return l2;
                    return -9223372036854775807L;
                }
                if (HashedWheelTimer.this.isWindows) {
                    l3 = l3 / 10L * 10L;
                }
                try {
                    Thread.sleep(l3);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (this.shutdown()) return Long.MIN_VALUE;
                    continue;
                }
                break;
            }
        }
    }
}

