/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.util;

import java.util.concurrent.TimeUnit;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.util.Deadline;
import scala.concurrent.util.Duration;
import scala.concurrent.util.Duration$;
import scala.concurrent.util.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.matching.Regex;

public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$;
    private final Regex RE;
    private final Regex REinf;
    private final Regex REminf;
    private final FiniteDuration Zero;
    private final Duration Undefined;
    private final Duration Inf;
    private final Duration MinusInf;

    static {
        new Duration$();
    }

    public Duration timeLeft(Deadline d) {
        return d.timeLeft();
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, this.timeUnit(unit));
    }

    public Duration apply(String s2) {
        Option<Duration> option = this.unapply(s2);
        if (option.isEmpty()) {
            String string2 = new StringBuilder().append((Object)"format error ").append((Object)s2).toString();
            package$ package$2 = package$.MODULE$;
            throw new RuntimeException(string2);
        }
        return option.get();
    }

    private Regex RE() {
        return this.RE;
    }

    private Regex REinf() {
        return this.REinf;
    }

    private Regex REminf() {
        return this.REminf;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        return d.finite_$qmark() ? new Some<Tuple2<Long, TimeUnit>>(new Tuple2<Long, TimeUnit>(BoxesRunTime.boxToLong(d.length()), d.unit())) : None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Duration> unapply(String s2) {
        void var5_7;
        Option<List<String>> o9 = this.RE().unapplySeq(s2);
        if (!o9.isEmpty() && o9.get() != null && ((LinearSeqOptimized)o9.get()).lengthCompare(8) == 0) {
            Some<FiniteDuration> some;
            if (((LinearSeqOptimized)o9.get()).apply(1) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o9.get()).apply(0)), TimeUnit.DAYS));
            } else if (((LinearSeqOptimized)o9.get()).apply(2) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o9.get()).apply(0)), TimeUnit.HOURS));
            } else if (((LinearSeqOptimized)o9.get()).apply(3) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o9.get()).apply(0)), TimeUnit.MINUTES));
            } else if (((LinearSeqOptimized)o9.get()).apply(4) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o9.get()).apply(0)), TimeUnit.SECONDS));
            } else if (((LinearSeqOptimized)o9.get()).apply(5) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o9.get()).apply(0)), TimeUnit.MILLISECONDS));
            } else if (((LinearSeqOptimized)o9.get()).apply(6) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o9.get()).apply(0)), TimeUnit.MICROSECONDS));
            } else {
                if (((LinearSeqOptimized)o9.get()).apply(7) == null) throw package$.MODULE$.error("made some error in regex (should not be possible)");
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o9.get()).apply(0)), TimeUnit.NANOSECONDS));
            }
            Some<FiniteDuration> some2 = some;
            return var5_7;
        } else {
            Option<List<String>> o11 = this.REinf().unapplySeq(s2);
            if (!o11.isEmpty() && o11.get() != null && ((LinearSeqOptimized)o11.get()).lengthCompare(0) == 0) {
                Some<Duration> some = new Some<Duration>(this.Inf());
                return var5_7;
            } else {
                Option<List<String>> o13 = this.REminf().unapplySeq(s2);
                if (!o13.isEmpty() && o13.get() != null && ((LinearSeqOptimized)o13.get()).lengthCompare(0) == 0) {
                    Some<Duration> some = new Some<Duration>(this.MinusInf());
                    return var5_7;
                } else {
                    None$ none$ = None$.MODULE$;
                }
            }
        }
        return var5_7;
    }

    public FiniteDuration fromNanos(double nanos) {
        return this.fromNanos((long)(nanos + 0.5));
    }

    public FiniteDuration fromNanos(long nanos) {
        return nanos % 86400000000000L == 0L ? this.apply(nanos / 86400000000000L, TimeUnit.DAYS) : (nanos % 3600000000000L == 0L ? this.apply(nanos / 3600000000000L, TimeUnit.HOURS) : (nanos % 60000000000L == 0L ? this.apply(nanos / 60000000000L, TimeUnit.MINUTES) : (nanos % 1000000000L == 0L ? this.apply(nanos / 1000000000L, TimeUnit.SECONDS) : (nanos % 1000000L == 0L ? this.apply(nanos / 1000000L, TimeUnit.MILLISECONDS) : (nanos % 1000L == 0L ? this.apply(nanos / 1000L, TimeUnit.MICROSECONDS) : this.apply(nanos, TimeUnit.NANOSECONDS))))));
    }

    public TimeUnit timeUnit(String unit) {
        String string2;
        block9: {
            TimeUnit timeUnit;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        string2 = unit.toLowerCase();
                                        boolean bl = !("d" != null ? !"d".equals(string2) : string2 != null) ? true : (!("day" != null ? !"day".equals(string2) : string2 != null) ? true : !("days" != null ? !"days".equals(string2) : string2 != null));
                                        if (!bl) break block2;
                                        timeUnit = TimeUnit.DAYS;
                                        break block3;
                                    }
                                    boolean bl = !("h" != null ? !"h".equals(string2) : string2 != null) ? true : (!("hour" != null ? !"hour".equals(string2) : string2 != null) ? true : !("hours" != null ? !"hours".equals(string2) : string2 != null));
                                    if (!bl) break block4;
                                    timeUnit = TimeUnit.HOURS;
                                    break block3;
                                }
                                boolean bl = !("min" != null ? !"min".equals(string2) : string2 != null) ? true : (!("minute" != null ? !"minute".equals(string2) : string2 != null) ? true : !("minutes" != null ? !"minutes".equals(string2) : string2 != null));
                                if (!bl) break block5;
                                timeUnit = TimeUnit.MINUTES;
                                break block3;
                            }
                            boolean bl = !("s" != null ? !"s".equals(string2) : string2 != null) ? true : (!("sec" != null ? !"sec".equals(string2) : string2 != null) ? true : (!("second" != null ? !"second".equals(string2) : string2 != null) ? true : !("seconds" != null ? !"seconds".equals(string2) : string2 != null)));
                            if (!bl) break block6;
                            timeUnit = TimeUnit.SECONDS;
                            break block3;
                        }
                        boolean bl = !("ms" != null ? !"ms".equals(string2) : string2 != null) ? true : (!("milli" != null ? !"milli".equals(string2) : string2 != null) ? true : (!("millis" != null ? !"millis".equals(string2) : string2 != null) ? true : (!("millisecond" != null ? !"millisecond".equals(string2) : string2 != null) ? true : !("milliseconds" != null ? !"milliseconds".equals(string2) : string2 != null))));
                        if (!bl) break block7;
                        timeUnit = TimeUnit.MILLISECONDS;
                        break block3;
                    }
                    boolean bl = !("\u00b5s" != null ? !"\u00b5s".equals(string2) : string2 != null) ? true : (!("micro" != null ? !"micro".equals(string2) : string2 != null) ? true : (!("micros" != null ? !"micros".equals(string2) : string2 != null) ? true : (!("microsecond" != null ? !"microsecond".equals(string2) : string2 != null) ? true : !("microseconds" != null ? !"microseconds".equals(string2) : string2 != null))));
                    if (!bl) break block8;
                    timeUnit = TimeUnit.MICROSECONDS;
                    break block3;
                }
                boolean bl = !("ns" != null ? !"ns".equals(string2) : string2 != null) ? true : (!("nano" != null ? !"nano".equals(string2) : string2 != null) ? true : (!("nanos" != null ? !"nanos".equals(string2) : string2 != null) ? true : (!("nanosecond" != null ? !"nanosecond".equals(string2) : string2 != null) ? true : !("nanoseconds" != null ? !"nanoseconds".equals(string2) : string2 != null))));
                if (!bl) break block9;
                timeUnit = TimeUnit.NANOSECONDS;
            }
            return timeUnit;
        }
        throw new MatchError((Object)string2);
    }

    public FiniteDuration Zero() {
        return this.Zero;
    }

    public Duration Undefined() {
        return this.Undefined;
    }

    public Duration Inf() {
        return this.Inf;
    }

    public Duration MinusInf() {
        return this.MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration parse(String s2) {
        return this.unapply(s2).get();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Duration$() {
        MODULE$ = this;
        Predef$ predef$ = Predef$.MODULE$;
        this.RE = new StringOps("^\\s*([\\+|-]?\\d+(?:\\.\\d+)?)\\s*(?:(d|day|days)|(h|hour|hours)|(min|minute|minutes)|(s|sec|second|seconds)|(ms|milli|millis|millisecond|milliseconds)|(\u00b5s|micro|micros|microsecond|microseconds)|(ns|nano|nanos|nanosecond|nanoseconds))\\s*$").r();
        Predef$ predef$2 = Predef$.MODULE$;
        this.REinf = new StringOps("^\\s*(?:\\+|Plus)?Inf\\s*$").r();
        Predef$ predef$3 = Predef$.MODULE$;
        this.REminf = new StringOps("^\\s*(?:-|Minus)Inf\\s*").r();
        this.Zero = new FiniteDuration(0L, TimeUnit.NANOSECONDS);
        this.Undefined = new anon.1();
        this.Inf = new anon.2();
        this.MinusInf = new anon.3();
    }
}

