/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.util;

import java.util.concurrent.TimeUnit;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcJL$sp;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.util.Deadline;
import scala.concurrent.util.Duration;
import scala.concurrent.util.Duration$;
import scala.concurrent.util.FiniteDuration;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$;
    private final Regex RE;
    private final Regex REinf;
    private final Regex REminf;
    private final FiniteDuration Zero;
    private final Duration Undefined;
    private final Duration Inf;
    private final Duration MinusInf;

    static {
        new Duration$();
    }

    public Duration timeLeft(Deadline d) {
        return d.timeLeft();
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, this.timeUnit(unit));
    }

    public Duration apply(String s$1) {
        return (Duration)this.unapply(s$1).getOrElse(new Serializable(s$1){
            public static final long serialVersionUID;
            private final String s$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return package$.MODULE$.error(new StringBuilder().append((Object)"format error ").append((Object)this.s$1).toString());
            }
            {
                this.s$1 = string2;
            }
        });
    }

    private Regex RE() {
        return this.RE;
    }

    private Regex REinf() {
        return this.REinf;
    }

    private Regex REminf() {
        return this.REminf;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        return d.finite_$qmark() ? new Some<Tuple2$mcJL$sp<TimeUnit>>(new Tuple2$mcJL$sp<TimeUnit>(d.length(), d.unit())) : None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Duration> unapply(String s) {
        void var4_8;
        String string2 = s;
        Option<List<String>> o8 = this.RE().unapplySeq(string2);
        if (!o8.isEmpty() && o8.get() != null && ((LinearSeqOptimized)o8.get()).lengthCompare(8) == 0) {
            Some<FiniteDuration> some;
            if (((LinearSeqOptimized)o8.get()).apply(1) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.DAYS));
            } else if (((LinearSeqOptimized)o8.get()).apply(2) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.HOURS));
            } else if (((LinearSeqOptimized)o8.get()).apply(3) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.MINUTES));
            } else if (((LinearSeqOptimized)o8.get()).apply(4) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.SECONDS));
            } else if (((LinearSeqOptimized)o8.get()).apply(5) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.MILLISECONDS));
            } else if (((LinearSeqOptimized)o8.get()).apply(6) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.MICROSECONDS));
            } else {
                if (((LinearSeqOptimized)o8.get()).apply(7) == null) throw package$.MODULE$.error("made some error in regex (should not be possible)");
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.NANOSECONDS));
            }
            Some<FiniteDuration> some2 = some;
            return var4_8;
        } else {
            Option<List<String>> o10 = this.REinf().unapplySeq(string2);
            if (!o10.isEmpty() && o10.get() != null && ((LinearSeqOptimized)o10.get()).lengthCompare(0) == 0) {
                Some<Duration> some = new Some<Duration>(this.Inf());
                return var4_8;
            } else {
                Option<List<String>> o12 = this.REminf().unapplySeq(string2);
                if (!o12.isEmpty() && o12.get() != null && ((LinearSeqOptimized)o12.get()).lengthCompare(0) == 0) {
                    Some<Duration> some = new Some<Duration>(this.MinusInf());
                    return var4_8;
                } else {
                    None$ none$ = None$.MODULE$;
                }
            }
        }
        return var4_8;
    }

    public FiniteDuration fromNanos(double nanos) {
        return this.fromNanos((long)(nanos + 0.5));
    }

    public FiniteDuration fromNanos(long nanos) {
        return nanos % 86400000000000L == 0L ? this.apply(nanos / 86400000000000L, TimeUnit.DAYS) : (nanos % 3600000000000L == 0L ? this.apply(nanos / 3600000000000L, TimeUnit.HOURS) : (nanos % 60000000000L == 0L ? this.apply(nanos / 60000000000L, TimeUnit.MINUTES) : (nanos % 1000000000L == 0L ? this.apply(nanos / 1000000000L, TimeUnit.SECONDS) : (nanos % 1000000L == 0L ? this.apply(nanos / 1000000L, TimeUnit.MILLISECONDS) : (nanos % 1000L == 0L ? this.apply(nanos / 1000L, TimeUnit.MICROSECONDS) : this.apply(nanos, TimeUnit.NANOSECONDS))))));
    }

    public TimeUnit timeUnit(String unit) {
        String string2;
        block66: {
            TimeUnit timeUnit;
            block60: {
                boolean bl;
                block65: {
                    boolean bl2;
                    block64: {
                        boolean bl3;
                        block63: {
                            boolean bl4;
                            block62: {
                                boolean bl5;
                                block61: {
                                    boolean bl6;
                                    block59: {
                                        boolean bl7;
                                        String string3 = string2 = unit.toLowerCase();
                                        if (!("d" != null ? !"d".equals(string3) : string3 != null)) {
                                            String x2 = string2;
                                            bl7 = true;
                                        } else {
                                            String string4 = string2;
                                            if (!("day" != null ? !"day".equals(string4) : string4 != null)) {
                                                String x3 = string2;
                                                bl7 = true;
                                            } else {
                                                String string5 = string2;
                                                if (!("days" != null ? !"days".equals(string5) : string5 != null)) {
                                                    String x4 = string2;
                                                    bl7 = true;
                                                } else {
                                                    bl7 = false;
                                                }
                                            }
                                        }
                                        if (!bl7) break block59;
                                        timeUnit = TimeUnit.DAYS;
                                        break block60;
                                    }
                                    String string6 = string2;
                                    if (!("h" != null ? !"h".equals(string6) : string6 != null)) {
                                        String x5 = string2;
                                        bl6 = true;
                                    } else {
                                        String string7 = string2;
                                        if (!("hour" != null ? !"hour".equals(string7) : string7 != null)) {
                                            String x6 = string2;
                                            bl6 = true;
                                        } else {
                                            String string8 = string2;
                                            if (!("hours" != null ? !"hours".equals(string8) : string8 != null)) {
                                                String x7 = string2;
                                                bl6 = true;
                                            } else {
                                                bl6 = false;
                                            }
                                        }
                                    }
                                    if (!bl6) break block61;
                                    timeUnit = TimeUnit.HOURS;
                                    break block60;
                                }
                                String string9 = string2;
                                if (!("min" != null ? !"min".equals(string9) : string9 != null)) {
                                    String x8 = string2;
                                    bl5 = true;
                                } else {
                                    String string10 = string2;
                                    if (!("minute" != null ? !"minute".equals(string10) : string10 != null)) {
                                        String x9 = string2;
                                        bl5 = true;
                                    } else {
                                        String string11 = string2;
                                        if (!("minutes" != null ? !"minutes".equals(string11) : string11 != null)) {
                                            String x10 = string2;
                                            bl5 = true;
                                        } else {
                                            bl5 = false;
                                        }
                                    }
                                }
                                if (!bl5) break block62;
                                timeUnit = TimeUnit.MINUTES;
                                break block60;
                            }
                            String string12 = string2;
                            if (!("s" != null ? !"s".equals(string12) : string12 != null)) {
                                String x11 = string2;
                                bl4 = true;
                            } else {
                                String string13 = string2;
                                if (!("sec" != null ? !"sec".equals(string13) : string13 != null)) {
                                    String x12 = string2;
                                    bl4 = true;
                                } else {
                                    String string14 = string2;
                                    if (!("second" != null ? !"second".equals(string14) : string14 != null)) {
                                        String x13 = string2;
                                        bl4 = true;
                                    } else {
                                        String string15 = string2;
                                        if (!("seconds" != null ? !"seconds".equals(string15) : string15 != null)) {
                                            String x14 = string2;
                                            bl4 = true;
                                        } else {
                                            bl4 = false;
                                        }
                                    }
                                }
                            }
                            if (!bl4) break block63;
                            timeUnit = TimeUnit.SECONDS;
                            break block60;
                        }
                        String string16 = string2;
                        if (!("ms" != null ? !"ms".equals(string16) : string16 != null)) {
                            String x15 = string2;
                            bl3 = true;
                        } else {
                            String string17 = string2;
                            if (!("milli" != null ? !"milli".equals(string17) : string17 != null)) {
                                String x16 = string2;
                                bl3 = true;
                            } else {
                                String string18 = string2;
                                if (!("millis" != null ? !"millis".equals(string18) : string18 != null)) {
                                    String x17 = string2;
                                    bl3 = true;
                                } else {
                                    String string19 = string2;
                                    if (!("millisecond" != null ? !"millisecond".equals(string19) : string19 != null)) {
                                        String x18 = string2;
                                        bl3 = true;
                                    } else {
                                        String string20 = string2;
                                        if (!("milliseconds" != null ? !"milliseconds".equals(string20) : string20 != null)) {
                                            String x19 = string2;
                                            bl3 = true;
                                        } else {
                                            bl3 = false;
                                        }
                                    }
                                }
                            }
                        }
                        if (!bl3) break block64;
                        timeUnit = TimeUnit.MILLISECONDS;
                        break block60;
                    }
                    String string21 = string2;
                    if (!("\u00b5s" != null ? !"\u00b5s".equals(string21) : string21 != null)) {
                        String x20 = string2;
                        bl2 = true;
                    } else {
                        String string22 = string2;
                        if (!("micro" != null ? !"micro".equals(string22) : string22 != null)) {
                            String x21 = string2;
                            bl2 = true;
                        } else {
                            String string23 = string2;
                            if (!("micros" != null ? !"micros".equals(string23) : string23 != null)) {
                                String x22 = string2;
                                bl2 = true;
                            } else {
                                String string24 = string2;
                                if (!("microsecond" != null ? !"microsecond".equals(string24) : string24 != null)) {
                                    String x23 = string2;
                                    bl2 = true;
                                } else {
                                    String string25 = string2;
                                    if (!("microseconds" != null ? !"microseconds".equals(string25) : string25 != null)) {
                                        String x24 = string2;
                                        bl2 = true;
                                    } else {
                                        bl2 = false;
                                    }
                                }
                            }
                        }
                    }
                    if (!bl2) break block65;
                    timeUnit = TimeUnit.MICROSECONDS;
                    break block60;
                }
                String string26 = string2;
                if (!("ns" != null ? !"ns".equals(string26) : string26 != null)) {
                    String x25 = string2;
                    bl = true;
                } else {
                    String string27 = string2;
                    if (!("nano" != null ? !"nano".equals(string27) : string27 != null)) {
                        String x26 = string2;
                        bl = true;
                    } else {
                        String string28 = string2;
                        if (!("nanos" != null ? !"nanos".equals(string28) : string28 != null)) {
                            String x27 = string2;
                            bl = true;
                        } else {
                            String string29 = string2;
                            if (!("nanosecond" != null ? !"nanosecond".equals(string29) : string29 != null)) {
                                String x28 = string2;
                                bl = true;
                            } else {
                                String string30 = string2;
                                if (!("nanoseconds" != null ? !"nanoseconds".equals(string30) : string30 != null)) {
                                    String x29 = string2;
                                    bl = true;
                                } else {
                                    bl = false;
                                }
                            }
                        }
                    }
                }
                if (!bl) break block66;
                timeUnit = TimeUnit.NANOSECONDS;
            }
            return timeUnit;
        }
        throw new MatchError((Object)string2);
    }

    public FiniteDuration Zero() {
        return this.Zero;
    }

    public Duration Undefined() {
        return this.Undefined;
    }

    public Duration Inf() {
        return this.Inf;
    }

    public Duration MinusInf() {
        return this.MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration parse(String s) {
        return this.unapply(s).get();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Duration$() {
        MODULE$ = this;
        this.RE = new StringOps(Predef$.MODULE$.augmentString("^\\s*([\\+|-]?\\d+(?:\\.\\d+)?)\\s*(?:(d|day|days)|(h|hour|hours)|(min|minute|minutes)|(s|sec|second|seconds)|(ms|milli|millis|millisecond|milliseconds)|(\u00b5s|micro|micros|microsecond|microseconds)|(ns|nano|nanos|nanosecond|nanoseconds))\\s*$")).r();
        this.REinf = new StringOps(Predef$.MODULE$.augmentString("^\\s*(?:\\+|Plus)?Inf\\s*$")).r();
        this.REminf = new StringOps(Predef$.MODULE$.augmentString("^\\s*(?:-|Minus)Inf\\s*")).r();
        this.Zero = new FiniteDuration(0L, TimeUnit.NANOSECONDS);
        this.Undefined = new anon.1();
        this.Inf = new anon.2();
        this.MinusInf = new anon.3();
    }
}

