/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable;
import scala.collection.mutable.HashTable$;
import scala.runtime.BoxesRunTime;

public abstract class HashTable$class {
    public static int tableSizeSeed(HashTable $this) {
        return Integer.bitCount($this.table().length - 1);
    }

    public static int initialSize(HashTable $this) {
        return HashTable$.MODULE$.initialSize();
    }

    /*
     * WARNING - void declaration
     */
    public static int scala$collection$mutable$HashTable$$lastPopulatedIndex(HashTable $this) {
        void var1_1;
        for (int idx = $this.table().length - 1; $this.table()[idx] == null && idx > 0; --idx) {
        }
        return (int)var1_1;
    }

    public static void init(HashTable $this, ObjectInputStream in, Function2 f) {
        in.defaultReadObject();
        $this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert($this._loadFactor() > 0);
        int size2 = in.readInt();
        $this.tableSize_$eq(0);
        Predef$.MODULE$.assert(size2 >= 0);
        $this.seedvalue_$eq(in.readInt());
        boolean smDefined = in.readBoolean();
        $this.table_$eq(new HashEntry[HashTable$.MODULE$.capacity(HashTable$.MODULE$.sizeForThreshold($this._loadFactor(), size2))]);
        $this.threshold_$eq(HashTable$.MODULE$.newThreshold($this._loadFactor(), Predef$.MODULE$.refArrayOps((Object[])$this.table()).size()));
        if (smDefined) {
            $this.sizeMapInit($this.table().length);
        } else {
            $this.sizemap_$eq(null);
        }
        for (int index2 = 0; index2 < size2; ++index2) {
            $this.addEntry((HashEntry)f.apply(in.readObject(), in.readObject()));
        }
    }

    public static void serializeTo(HashTable $this, ObjectOutputStream out$1, Function1 value$1) {
        out$1.defaultWriteObject();
        out$1.writeInt($this._loadFactor());
        out$1.writeInt($this.tableSize());
        out$1.writeInt($this.seedvalue());
        out$1.writeBoolean($this.isSizeMapDefined());
        $this.foreachEntry(new Serializable($this, out$1, value$1){
            public static final long serialVersionUID;
            private final ObjectOutputStream out$1;
            private final Function1 value$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Entry entry) {
                this.out$1.writeObject(entry.key());
                this.out$1.writeObject(this.value$1.apply(entry));
            }
            {
                this.out$1 = hashTable;
                this.value$1 = var3_3;
            }
        });
    }

    public static HashEntry findEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = $this.table()[h];
        while (e != null && !$this.elemEquals(e.key(), key)) {
            e = (HashEntry)e.next();
        }
        return e;
    }

    public static void addEntry(HashTable $this, HashEntry e) {
        int h = $this.index($this.elemHashCode(e.key()));
        e.next_$eq($this.table()[h]);
        $this.table()[h] = e;
        $this.tableSize_$eq($this.tableSize() + 1);
        $this.nnSizeMapAdd(h);
        if ($this.tableSize() > $this.threshold()) {
            HashTable$class.resize($this, 2 * $this.table().length);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static HashEntry removeEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = $this.table()[h];
        if (e != null) {
            if ($this.elemEquals(e.key(), key)) {
                $this.table()[h] = (HashEntry)e.next();
                $this.tableSize_$eq($this.tableSize() - 1);
                $this.nnSizeMapRemove(h);
                return e;
            }
            HashEntry e1 = (HashEntry)e.next();
            while (true) {
                if (e1 == null || $this.elemEquals(e1.key(), key)) {
                    if (e1 == null) break;
                    e.next_$eq(e1.next());
                    $this.tableSize_$eq($this.tableSize() - 1);
                    $this.nnSizeMapRemove(h);
                    return e1;
                }
                e = e1;
                e1 = (HashEntry)e1.next();
            }
        }
        return null;
    }

    public static Iterator entriesIterator(HashTable $this) {
        return new AbstractIterator<Entry>($this){
            private final HashEntry<A, Entry>[] iterTable;
            private int idx;
            private HashEntry<A, Entry> es;

            private HashEntry<A, Entry>[] iterTable() {
                return this.iterTable;
            }

            private int idx() {
                return this.idx;
            }

            private void idx_$eq(int n) {
                this.idx = n;
            }

            private HashEntry<A, Entry> es() {
                return this.es;
            }

            private void es_$eq(HashEntry<A, Entry> hashEntry) {
                this.es = hashEntry;
            }

            public boolean hasNext() {
                return this.es() != null;
            }

            /*
             * WARNING - void declaration
             */
            public Entry next() {
                void var1_1;
                HashEntry<A, Entry> res = this.es();
                this.es_$eq((HashEntry)this.es().next());
                while (this.es() == null && this.idx() > 0) {
                    this.idx_$eq(this.idx() - 1);
                    this.es_$eq(this.iterTable()[this.idx()]);
                }
                return var1_1;
            }
            {
                this.iterTable = $outer.table();
                this.idx = HashTable$class.scala$collection$mutable$HashTable$$lastPopulatedIndex($outer);
                this.es = this.iterTable()[this.idx()];
            }
        };
    }

    public static final void foreachEntry(HashTable $this, Function1 f) {
        HashEntry<A, Entry>[] iterTable = $this.table();
        int idx = HashTable$class.scala$collection$mutable$HashTable$$lastPopulatedIndex($this);
        HashEntry es = iterTable[idx];
        block0: while (es != null) {
            f.apply(es);
            es = (HashEntry)es.next();
            while (true) {
                if (es != null || idx <= 0) continue block0;
                es = iterTable[--idx];
            }
            break;
        }
        return;
    }

    public static void clearTable(HashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
        $this.nnSizeMapReset(0);
    }

    private static void resize(HashTable $this, int newSize) {
        HashEntry<A, Entry>[] oldTable = $this.table();
        $this.table_$eq(new HashEntry[newSize]);
        $this.nnSizeMapReset($this.table().length);
        block0: for (int i = oldTable.length - 1; i >= 0; --i) {
            HashEntry e = oldTable[i];
            while (true) {
                if (e == null) {
                    continue block0;
                }
                int h = $this.index($this.elemHashCode(e.key()));
                HashEntry e1 = (HashEntry)e.next();
                e.next_$eq($this.table()[h]);
                $this.table()[h] = e;
                e = e1;
                $this.nnSizeMapAdd(h);
            }
        }
        $this.threshold_$eq(HashTable$.MODULE$.newThreshold($this._loadFactor(), newSize));
    }

    public static void nnSizeMapAdd(HashTable $this, int h) {
        if ($this.sizemap() != null) {
            int[] nArray = $this.sizemap();
            int n = h >> $this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] + 1;
        }
    }

    public static void nnSizeMapRemove(HashTable $this, int h) {
        if ($this.sizemap() != null) {
            int[] nArray = $this.sizemap();
            int n = h >> $this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] - 1;
        }
    }

    public static void nnSizeMapReset(HashTable $this, int tableLength) {
        if ($this.sizemap() != null) {
            int nsize = $this.calcSizeMapSize(tableLength);
            if ($this.sizemap().length != nsize) {
                $this.sizemap_$eq(new int[nsize]);
            } else {
                Arrays.fill($this.sizemap(), 0);
            }
        }
    }

    public static final int totalSizeMapBuckets(HashTable $this) {
        return $this.sizeMapBucketSize() < $this.table().length ? 1 : $this.table().length / $this.sizeMapBucketSize();
    }

    public static int calcSizeMapSize(HashTable $this, int tableLength) {
        return (tableLength >> $this.sizeMapBucketBitSize()) + 1;
    }

    public static void sizeMapInit(HashTable $this, int tableLength) {
        $this.sizemap_$eq(new int[$this.calcSizeMapSize(tableLength)]);
    }

    public static void sizeMapInitAndRebuild(HashTable $this) {
        $this.sizeMapInit($this.table().length);
        int tableidx = 0;
        HashEntry<A, Entry>[] tbl = $this.table();
        int tableuntil = 0;
        tableuntil = tbl.length < $this.sizeMapBucketSize() ? tbl.length : $this.sizeMapBucketSize();
        int totalbuckets = $this.totalSizeMapBuckets();
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsize = 0;
            while (tableidx < tableuntil) {
                for (HashEntry e = tbl[tableidx]; e != null; e = (HashEntry)e.next()) {
                    ++currbucketsize;
                }
                ++tableidx;
            }
            $this.sizemap()[bucketidx] = currbucketsize;
            tableuntil += $this.sizeMapBucketSize();
        }
    }

    public static void printSizeMap(HashTable $this) {
        Predef$.MODULE$.println(Predef$.MODULE$.intArrayOps($this.sizemap()).toList());
    }

    public static void sizeMapDisable(HashTable $this) {
        $this.sizemap_$eq(null);
    }

    public static boolean isSizeMapDefined(HashTable $this) {
        return $this.sizemap() != null;
    }

    public static boolean alwaysInitSizeMap(HashTable $this) {
        return false;
    }

    public static boolean elemEquals(HashTable $this, Object key1, Object key2) {
        return BoxesRunTime.equals(key1, key2);
    }

    public static final int index(HashTable $this, int hcode) {
        int ones = $this.table().length - 1;
        int improved = $this.improve(hcode, $this.seedvalue());
        int shifted = improved >> 32 - Integer.bitCount(ones) & ones;
        return shifted;
    }

    public static void initWithContents(HashTable $this, HashTable.Contents c) {
        if (c != null) {
            $this._loadFactor_$eq(c.loadFactor());
            $this.table_$eq(c.table());
            $this.tableSize_$eq(c.tableSize());
            $this.threshold_$eq(c.threshold());
            $this.seedvalue_$eq(c.seedvalue());
            $this.sizemap_$eq(c.sizemap());
        }
        if ($this.alwaysInitSizeMap()) {
            if ($this.sizemap() == null) {
                $this.sizeMapInitAndRebuild();
            }
        }
    }

    public static HashTable.Contents hashTableContents(HashTable $this) {
        return new HashTable.Contents($this._loadFactor(), $this.table(), $this.tableSize(), $this.threshold(), $this.seedvalue(), $this.sizemap());
    }

    public static void $init$(HashTable $this) {
        $this._loadFactor_$eq(HashTable$.MODULE$.defaultLoadFactor());
        $this.table_$eq(new HashEntry[HashTable$.MODULE$.initialCapacity()]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(HashTable$.MODULE$.initialThreshold($this._loadFactor()));
        $this.sizemap_$eq(null);
        $this.seedvalue_$eq($this.tableSizeSeed());
    }
}

