/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.usability.diagnostics;

public final class DiagnosisUtils {
    private DiagnosisUtils() {
    }

    public static boolean containsInCausality(Throwable error, Class test) {
        for (Throwable cause = error; cause != null; cause = cause.getCause()) {
            if (!test.isInstance(cause)) continue;
            return true;
        }
        return false;
    }

    public static Throwable getRootCause(Throwable error) {
        Throwable nextCause;
        Throwable cause = error;
        while ((nextCause = cause.getCause()) != null) {
            cause = nextCause;
        }
        return cause;
    }

    public static Throwable getFromCausality(Throwable error, Class targetClass) {
        for (Throwable cause = error; cause != null; cause = cause.getCause()) {
            if (!targetClass.isInstance(cause)) continue;
            return cause;
        }
        return null;
    }

    public static void appendRootCauseIfPresentAndUnique(Throwable error, StringBuffer message, boolean includeTypeInfo) {
        String rootMsg;
        if (error == null) {
            return;
        }
        Throwable root = DiagnosisUtils.getRootCause(error);
        if (!(root == null || root.equals(error) || (rootMsg = root.getMessage()) == null || error.getMessage() != null && error.getMessage().indexOf(rootMsg) >= 0)) {
            message.append("\n").append(rootMsg);
            if (includeTypeInfo) {
                message.append("\nRoot error type: ").append(root.getClass().getName());
            }
        }
    }
}

