/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.dotnet.build;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.ant.dotnet.build.AbstractBuildTask;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MSBuildTask
extends AbstractBuildTask {
    private static final String TARGET = "generated-by-ant";
    private static final String ROOT = "Project";
    private static final String MSBUILD_NS = "http://schemas.microsoft.com/developer/msbuild/2003";

    protected String getExecutable() {
        return "MSBuild.exe";
    }

    protected String[] getBuildfileArguments(File buildFile) {
        if (buildFile != null) {
            return new String[]{buildFile.getAbsolutePath()};
        }
        return new String[0];
    }

    protected String[] getTargetArguments(List targets) {
        if (targets.size() > 0) {
            StringBuffer sb = new StringBuffer("/target:");
            Iterator iter = targets.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                AbstractBuildTask.Target t = (AbstractBuildTask.Target)iter.next();
                if (!first) {
                    sb.append(";");
                } else {
                    first = false;
                }
                sb.append(t.getName());
            }
            return new String[]{sb.toString()};
        }
        return new String[0];
    }

    protected String[] getPropertyArguments(List properties) {
        if (properties.size() > 0) {
            StringBuffer sb = new StringBuffer("/property:");
            Iterator iter = properties.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                AbstractBuildTask.Property p = (AbstractBuildTask.Property)iter.next();
                if (!first) {
                    sb.append(";");
                } else {
                    first = false;
                }
                sb.append(p.getName()).append("=").append(p.getValue());
            }
            return new String[]{sb.toString()};
        }
        return new String[0];
    }

    protected Element makeTree(DocumentFragment f) {
        NodeList nl = f.getChildNodes();
        if (nl.getLength() == 1 && nl.item(0).getNodeType() == 1 && nl.item(0).getNodeName().equals(ROOT)) {
            return (Element)nl.item(0);
        }
        Element p = f.getOwnerDocument().createElementNS(MSBUILD_NS, ROOT);
        p.setAttribute("DefaultTargets", TARGET);
        Element t = f.getOwnerDocument().createElementNS(MSBUILD_NS, "Target");
        t.setAttribute("Name", TARGET);
        p.appendChild(t);
        t.appendChild(f);
        return p;
    }
}

