/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001U3Q!\u0001\u0002\u0002\u0002%\u0011A\"\u0012=bGRtU/\\3sS\u000eT!a\u0001\u0003\u0002\u0011\u0011\fG/\u0019;za\u0016T!!\u0002\u0004\u0002\u0007\u0011\u00147MC\u0001\b\u0003\u0015\u00198-\u00197b\u0007\u0001)\"AC\t\u0014\u0007\u0001Y1\u0004E\u0002\r\u001b=i\u0011AA\u0005\u0003\u001d\t\u0011qAT;nKJL7\r\u0005\u0002\u0011#1\u0001A!\u0002\n\u0001\u0005\u0004\u0019\"\u0001\u0002+za\u0016\f\"\u0001\u0006\r\u0011\u0005U1R\"\u0001\u0004\n\u0005]1!a\u0002(pi\"Lgn\u001a\t\u0003+eI!A\u0007\u0004\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\u00169%\u0011QD\u0002\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005 \u0001\t\u0015\r\u0011\"\u0011!\u00031q\u0017\r^5wKRK\b/Z%e+\u0005\t\u0003C\u0001\u0012'\u001d\t\u0019C%D\u0001\u0005\u0013\t)C!\u0001\u0005ECR\fG+\u001f9f\u0013\t9\u0003F\u0001\u0002JI*\u0011Q\u0005\u0002\u0005\tU\u0001\u0011\t\u0011)A\u0005C\u0005ia.\u0019;jm\u0016$\u0016\u0010]3JI\u0002BQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtDC\u0001\u00180!\ra\u0001a\u0004\u0005\u0006?-\u0002\r!\t\u0005\u0006c\u0001!\tAM\u0001\rSN,\u0015/^5wC2,g\u000e\u001e\u000b\u0003gY\u0002\"!\u0006\u001b\n\u0005U2!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0007A\u0002\ra\u000e\t\u0003GaJ!!\u000f\u0003\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQa\u000f\u0001\u0005\u0002q\n1\"[:Tk\n$\u0018\u0010]3PMR\u00111'\u0010\u0005\u0006\u0007i\u0002\ra\u000e\u0005\u0006\u007f\u00011\t\u0001Q\u0001\u0006g\u000e\fG.Z\u000b\u0002\u0003B\u0011QCQ\u0005\u0003\u0007\u001a\u00111!\u00138u\u0011\u0015)\u0005\u0001\"\u0011G\u0003%\u0019\u0018\u000f\\*ue&tw-F\u0001H!\tAU*D\u0001J\u0015\tQ5*\u0001\u0003mC:<'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u0013aa\u0015;sS:<\u0007f\u0001\u0001Q'B\u0011Q#U\u0005\u0003%\u001a\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005!\u0016aY:dC2\fg\u0006\u001a2dA]LG\u000e\u001c\u0011cK\u0002\u0012X-\\8wK\u0012\u0004\u0013M\u001a;fe\u00022XM]:j_:\u0004#GL\u001d/A\u0001*6/\u001a\u0011b]\u0002\n7\r^5wK\u0002\u001a\u0018\u000f\u001c\u0011mS\n\u0014\u0018M]=!gV\u001c\u0007\u000eI1tAM\u001c\u0017\r\\1rk\u0016\u0014\u0018\u0010I5ogR,\u0017\r\u001a\u0018")
public abstract class ExactNumeric<Type>
extends Numeric<Type>
implements ScalaObject {
    private final int nativeTypeId;

    @Override
    public int nativeTypeId() {
        return this.nativeTypeId;
    }

    @Override
    public boolean isEquivalent(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ExactNumeric) {
            ExactNumeric exactNumeric;
            ExactNumeric dt = exactNumeric = (ExactNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() == dt.precision() && this.scale() == dt.scale() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isSubtypeOf(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ExactNumeric) {
            ExactNumeric exactNumeric;
            ExactNumeric dt = exactNumeric = (ExactNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() <= dt.precision() && this.scale() <= dt.scale() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public abstract int scale();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String sqlString() {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.precisionRadix()), (Object)BoxesRunTime.boxToInteger((int)this.precision()), (Object)BoxesRunTime.boxToInteger((int)this.scale()));
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        int n = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int n2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int n3 = BoxesRunTime.unboxToInt((Object)tuple3._3());
        switch (n) {
            default: {
                throw new UnsupportedFeature("SQL-99 does not support the precision of an exact numeric type to be defined in a radix other than 2 or 10");
            }
            case 10: {
                String string;
                if (n3 == 0) {
                    string = new StringBuilder().append((Object)"NUMERIC (").append((Object)((Object)BoxesRunTime.boxToInteger((int)n2)).toString()).append((Object)")").toString();
                    return string;
                }
                string = new StringBuilder().append((Object)"NUMERIC (").append((Object)((Object)BoxesRunTime.boxToInteger((int)n2)).toString()).append((Object)", ").append((Object)((Object)BoxesRunTime.boxToInteger((int)n3)).toString()).append((Object)")").toString();
                return string;
            }
            case 2: {
                if (n2 == 16) {
                    if (n3 != 0) throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    return "SMALLINT";
                }
                if (n2 == 32) {
                    if (n3 != 0) throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    return "INTEGER";
                }
                if (n2 == 64) {
                    if (n3 != 0) throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    return "BIGINT";
                }
                if (n2 != Integer.MAX_VALUE) throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                if (n3 != 0) throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                return "BIGINT";
            }
        }
    }

    public ExactNumeric(int nativeTypeId) {
        this.nativeTypeId = nativeTypeId;
        super(nativeTypeId);
    }
}

