/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2011, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |    http://scala-lang.org/               **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */


package scala.collection.parallel
package mutable



import collection.generic._
import collection.mutable.Builder



/** A template trait for mutable parallel maps. This trait is to be mixed in
 *  with concrete parallel maps to override the representation type.
 *  
 *  $sideeffects
 *  
 *  @tparam K    the key type of the map
 *  @tparam V    the value type of the map
 *  
 *  @author Aleksandar Prokopec
 *  @since 2.9
 */
trait ParMapLike[K,
                 V,
                 +Repr <: ParMapLike[K, V, Repr, Sequential] with ParMap[K, V],
                 +Sequential <: collection.mutable.Map[K, V] with collection.mutable.MapLike[K, V, Sequential]]
extends collection.mutable.MapLike[K, V, Repr]
   with collection.parallel.ParMapLike[K, V, Repr, Sequential] {
  
  // note: should not override toMap
  
  override def clear(): Unit = throw new UnsupportedOperationException("Must be reimplemented for parallel map implementations.")
  
}
   
