/* NEST (New Scala Test)
 * Copyright 2007-2011 LAMP/EPFL
 * @author  Paul Phillips
 */

package scala.tools.cmd
package gen

class Codegen(args: List[String]) extends {
  val parsed = CodegenSpec(args: _*)
} with CodegenSpec with Instance { }

object Codegen {
  def echo(msg: String) = Console println msg

  def main(args0: Array[String]): Unit = {    
    val runner = new Codegen(args0.toList)
    import runner._
    
    if (args0.isEmpty)
      return println (CodegenSpec.helpMsg)

    val out = outDir getOrElse { return println("--out is required.") }
    val all = genall || (!anyvals && !products)
    
    echo("Generating sources into " + out)
    
    if (anyvals || all) {
      val av = new AnyVals {
        override def timestampString = (
          "// DO NOT EDIT, CHANGES WILL BE LOST.\n" + (
            if (stamp) "// Generated by tools/codegen on " + new java.util.Date + "\n" else ""
          )
        )
      }
      
      av.make() foreach { case (name, code ) =>
        val file = out / (name + ".scala") toFile;
        echo("Writing: " + file)
        file writeAll code
      }
    }
  }
}

