/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.Configuration;
import com.sun.midp.lcdui.DisplayAccess;
import com.sun.midp.lcdui.EventHandler;
import com.sun.midp.lcdui.MIDLetMap;
import com.sun.midp.midlet.Scheduler;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DeviceCaps;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class Display {
    static final Object LCDUILock = new Object();
    static final Object calloutLock = new Object();
    static final int WIDTH;
    static final int HEIGHT;
    static final int ERASE_COLOR;
    static final int DISPLAY_DEPTH;
    static final boolean DISPLAY_IS_COLOR;
    static final boolean POINTER_SUPPORTED;
    static final boolean MOTION_SUPPORTED;
    static final boolean REPEAT_SUPPORTED;
    static final boolean IS_DOUBLE_BUFFERED;
    static final int FG_COLOR = 0;
    static final int BG_H_COLOR = 0;
    static final int FG_H_COLOR;
    private static EventHandler eventHandler;
    private static final Graphics screenGraphics;
    private DisplayAccessor accessor = new DisplayAccessor();
    private Displayable current;
    private Displayable nextScreen;
    private Displayable pendingAlert;
    private int alertDelay;
    private boolean hascurrent;
    private int paintRectX1;
    private int paintRectY1;
    private int paintRectX2;
    private int paintRectY2;
    private boolean updatePending;
    private boolean paintSuspended = false;
    private boolean hasForeground = false;
    private static Vector queue1;
    private static Vector queue2;
    private static Vector currentQueue;

    Display() {
    }

    public static Display getDisplay(MIDlet m) {
        Object object = LCDUILock;
        synchronized (object) {
            DisplayAccess a = MIDLetMap.get(m);
            if (a == null) {
                Display d = new Display();
                a = d.accessor;
                MIDLetMap.put(m, a);
            }
            Display display = a.getDisplay();
            return display;
        }
    }

    public boolean isColor() {
        return DISPLAY_IS_COLOR;
    }

    public int numColors() {
        return 1 << DISPLAY_DEPTH;
    }

    public Displayable getCurrent() {
        return this.current;
    }

    public void setCurrent(Displayable nextDisplayable) {
        Object object = LCDUILock;
        synchronized (object) {
            if (nextDisplayable instanceof Alert) {
                Displayable n = this.current;
                if (this.nextScreen != null && !(this.nextScreen instanceof Alert)) {
                    n = this.nextScreen;
                }
                this.setCurrentImpl((Alert)nextDisplayable, n);
                return;
            }
            this.hascurrent = nextDisplayable != null;
            Scheduler.getScheduler().notifyHasCurrent(this.accessor, this.hascurrent);
            if (nextDisplayable == null) {
                return;
            }
            if (nextDisplayable == this.current && !this.paintSuspended) {
                return;
            }
            this.setCurrentImpl(nextDisplayable);
        }
    }

    public void setCurrent(Alert alert, Displayable nextDisplayable) {
        if (alert == null || nextDisplayable == null) {
            throw new NullPointerException();
        }
        if (nextDisplayable instanceof Alert) {
            throw new IllegalArgumentException();
        }
        Object object = LCDUILock;
        synchronized (object) {
            this.setCurrentImpl(alert, nextDisplayable);
        }
    }

    void setCurrentImpl(Displayable nextDisplayable) {
        this.pendingAlert = null;
        this.nextScreen = nextDisplayable;
        if (this.hasForeground) {
            if (this.paintSuspended) {
                eventHandler.clearSystemScreen();
            }
            eventHandler.scheduleTimer(1, 0);
        }
    }

    void setCurrentImpl(Alert alert, Displayable nextDisplayable) {
        this.pendingAlert = alert;
        this.nextScreen = nextDisplayable;
        this.alertDelay = alert.getTimeout();
        if (this.hasForeground) {
            if (this.paintSuspended) {
                eventHandler.clearSystemScreen();
            }
            eventHandler.scheduleTimer(1, 0);
        }
        this.hascurrent = nextDisplayable != null;
        Scheduler.getScheduler().notifyHasCurrent(this.accessor, this.hascurrent);
    }

    void clearAlert() {
        this.pendingAlert = null;
        eventHandler.scheduleTimer(1, 0);
    }

    boolean playAlertSound(AlertType t) {
        if (this.paintSuspended || !this.hasForeground) {
            return false;
        }
        return this.playAlertSound(t.getType());
    }

    private native boolean playAlertSound(int var1);

    private static EventHandler getEventHandler() {
        try {
            String n = Configuration.getProperty("com.sun.lcdui.eventHandler");
            if (n == null) {
                n = Configuration.getProperty("microedition.configuration") != null ? "com.sun.midp.lcdui.DefaultEventHandler" : "com.sun.midp.lcdui.AWTEventHandler";
            }
            Class<?> c = Class.forName(n);
            return (EventHandler)c.newInstance();
        }
        catch (Exception e) {
            throw new Error(e.getMessage());
        }
    }

    MIDlet getMIDLet() {
        return MIDLetMap.get(this.accessor);
    }

    void repaintImpl(Displayable d, int x, int y, int w, int h, int delay) {
        if (d != this.current) {
            return;
        }
        if (this.updatePending) {
            if (x < this.paintRectX1) {
                this.paintRectX1 = x;
            }
            if (y < this.paintRectY1) {
                this.paintRectY1 = y;
            }
            y += h;
            if ((x += w) > this.paintRectX2) {
                this.paintRectX2 = x;
            }
            if (y > this.paintRectY2) {
                this.paintRectY2 = y;
            }
        } else if (w > 0 && h > 0) {
            this.updatePending = true;
            this.paintRectX1 = x;
            this.paintRectY1 = y;
            this.paintRectX2 = x + w;
            this.paintRectY2 = y + h;
            eventHandler.scheduleTimer(2, delay);
        }
    }

    void serviceRepaints() {
        int x2;
        int y1;
        int x1;
        int y2 = 0;
        Object object = LCDUILock;
        synchronized (object) {
            if (this.paintSuspended || !this.hasForeground || !this.updatePending) {
                return;
            }
            x1 = this.paintRectX1;
            y1 = this.paintRectY1;
            x2 = this.paintRectX2;
            y2 = this.paintRectY2;
            this.updatePending = false;
        }
        try {
            Object object2 = calloutLock;
            synchronized (object2) {
                screenGraphics.reset(x1, y1, x2, y2);
                this.current.paint(screenGraphics);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
        this.refresh(x1, y1, x2, y2);
    }

    private native void refresh(int var1, int var2, int var3, int var4);

    static int getKeyCode(int gameAction) {
        return eventHandler.getKeyCode(gameAction);
    }

    int getHorizontalScrollPosition() {
        if (this.current != null) {
            return this.current.getHorizontalScrollPosition();
        }
        return 0;
    }

    int getHorizontalScrollProportion() {
        if (this.current != null) {
            return this.current.getHorizontalScrollProportion();
        }
        return 100;
    }

    native void setHorizontalScroll(int var1, int var2);

    int getVerticalScrollPosition() {
        if (this.current != null) {
            return this.current.getVerticalScrollPosition();
        }
        return 0;
    }

    int getVerticalScrollProportion() {
        if (this.current != null) {
            return this.current.getVerticalScrollProportion();
        }
        return 100;
    }

    native void setVerticalScroll(int var1, int var2);

    native void setInputMode(int var1);

    static int getGameAction(int keyCode) {
        return eventHandler.getGameAction(keyCode);
    }

    static int getSystemKey(int keyCode) {
        return eventHandler.getSystemKey(keyCode);
    }

    static String getKeyName(int keyCode) {
        return eventHandler.getKeyName(keyCode);
    }

    void updateCommandSet() {
        eventHandler.updateCommandSet(this.current.getCommands(), this.current.getCommandCount());
    }

    boolean isShown(Displayable d) {
        return this.hasForeground && !this.paintSuspended && this.current == d;
    }

    static void handleThrowable(Throwable t) {
        t.printStackTrace();
    }

    public void callSerially(Runnable r) {
        if (r == null) {
            throw new NullPointerException();
        }
        Object object = LCDUILock;
        synchronized (object) {
            currentQueue.addElement(r);
            eventHandler.scheduleTimer(3, 0);
        }
    }

    private void getCallSerially() {
        Vector q = null;
        Object object = LCDUILock;
        synchronized (object) {
            q = currentQueue;
            currentQueue = q == queue1 ? queue2 : queue1;
        }
        Object object2 = calloutLock;
        synchronized (object2) {
            int i = 0;
            while (i < q.size()) {
                try {
                    Runnable r = (Runnable)q.elementAt(i);
                    r.run();
                }
                catch (Throwable thr) {
                    Display.handleThrowable(thr);
                }
                ++i;
            }
        }
        q.removeAllElements();
    }

    private void registerNewCurrent(Displayable newCurrent, boolean fgChange) {
        Displayable currentCopy = null;
        if (newCurrent != null) {
            newCurrent.showNotify(this);
        }
        Object object = LCDUILock;
        synchronized (object) {
            AlertType at;
            if (newCurrent == this.pendingAlert) {
                this.pendingAlert = null;
            }
            if (fgChange) {
                this.hasForeground = true;
                if (this.nextScreen != null || this.pendingAlert != null) {
                    eventHandler.scheduleTimer(1, 0);
                }
                if (newCurrent == null) {
                    return;
                }
            }
            this.accessor.sawKeyPress = false;
            this.accessor.sawPointerPress = false;
            this.paintSuspended = false;
            currentCopy = this.current;
            this.current = newCurrent;
            this.updatePending = false;
            this.repaintImpl(this.current, 0, 0, WIDTH, HEIGHT, 0);
            this.setVerticalScroll(this.current.getVerticalScrollPosition(), this.current.getVerticalScrollProportion());
            this.setHorizontalScroll(this.current.getHorizontalScrollPosition(), this.current.getHorizontalScrollProportion());
            eventHandler.updateCommandSet(this.current.getCommands(), this.current.getCommandCount());
            TextBox.imHandler.setFocus(this.current instanceof TextBox);
            if (this.current instanceof Alert && (at = ((Alert)this.current).getType()) != null) {
                this.playAlertSound(at.getType());
            }
        }
        if (currentCopy != null && currentCopy != this.current) {
            currentCopy.hideNotify(this);
        }
    }

    static {
        DeviceCaps c = new DeviceCaps();
        WIDTH = c.width;
        HEIGHT = c.height;
        ERASE_COLOR = c.eraseColor;
        DISPLAY_DEPTH = c.displayDepth;
        DISPLAY_IS_COLOR = c.displayIsColor;
        POINTER_SUPPORTED = c.pointerSupported;
        MOTION_SUPPORTED = c.motionSupported;
        REPEAT_SUPPORTED = c.repeatSupported;
        IS_DOUBLE_BUFFERED = c.isDoubleBuffered;
        Object var0 = null;
        FG_H_COLOR = ERASE_COLOR;
        eventHandler = Display.getEventHandler();
        screenGraphics = Graphics.getGraphics(null);
        queue1 = new Vector();
        queue2 = new Vector();
        currentQueue = queue1;
    }

    class DisplayAccessor
    implements DisplayAccess {
        boolean sawPointerPress;
        boolean sawKeyPress;

        DisplayAccessor() {
        }

        public void suspendPainting() {
            Displayable currentCopy = null;
            Object object = LCDUILock;
            synchronized (object) {
                Display.this.paintSuspended = true;
                currentCopy = Display.this.current;
            }
            if (currentCopy != null) {
                currentCopy.hideNotify(Display.this);
            }
            Display.this.setHorizontalScroll(0, 100);
            Display.this.setVerticalScroll(0, 100);
        }

        public void resumePainting() {
            Display.this.registerNewCurrent(Display.this.current, false);
        }

        public void commandAction(int id) {
            CommandListener listener;
            Command c = null;
            Displayable currentCopy = null;
            Object object = LCDUILock;
            synchronized (object) {
                if (Display.this.current == null) {
                    return;
                }
                Command[] commands = Display.this.current.getCommands();
                if (commands == null) {
                    return;
                }
                listener = Display.this.current.getCommandListener();
                if (listener == null) {
                    return;
                }
                int i = 0;
                while (i < commands.length) {
                    if (commands[i].getID() == id) {
                        c = commands[i];
                        break;
                    }
                    ++i;
                }
                if (c == null) {
                    return;
                }
                currentCopy = Display.this.current;
            }
            try {
                Object i = calloutLock;
                synchronized (i) {
                    listener.commandAction(c, currentCopy);
                }
            }
            catch (Throwable thr) {
                Display.handleThrowable(thr);
            }
        }

        public void pointerEvent(int type, int x, int y) {
            Displayable currentCopy = null;
            int eventType = -1;
            Object object = LCDUILock;
            synchronized (object) {
                if (Display.this.current == null) {
                    return;
                }
                currentCopy = Display.this.current;
                switch (type) {
                    case 1: {
                        this.sawPointerPress = true;
                        eventType = 0;
                        break;
                    }
                    case 2: {
                        if (!this.sawPointerPress) break;
                        eventType = 1;
                        break;
                    }
                    case 3: {
                        if (!this.sawPointerPress) break;
                        eventType = 2;
                    }
                }
            }
            if (eventType == -1) {
                return;
            }
            try {
                Object object2 = calloutLock;
                synchronized (object2) {
                    if (eventType == 0) {
                        currentCopy.pointerPressed(x, y);
                    } else if (eventType == 1) {
                        currentCopy.pointerReleased(x, y);
                    } else {
                        currentCopy.pointerDragged(x, y);
                    }
                }
            }
            catch (Throwable thr) {
                Display.handleThrowable(thr);
            }
        }

        public void keyEvent(int type, int keyCode) {
            Displayable currentCopy = null;
            int eventType = -1;
            Object object = LCDUILock;
            synchronized (object) {
                if (Display.this.current == null) {
                    return;
                }
                currentCopy = Display.this.current;
                switch (type) {
                    case 1: {
                        this.sawKeyPress = true;
                        eventType = 0;
                        break;
                    }
                    case 2: {
                        if (!this.sawKeyPress) break;
                        eventType = 1;
                        break;
                    }
                    case 3: {
                        if (!this.sawKeyPress) break;
                        eventType = 2;
                        break;
                    }
                    case 4: {
                        eventType = 3;
                    }
                }
            }
            if (eventType == -1) {
                return;
            }
            try {
                Object object2 = calloutLock;
                synchronized (object2) {
                    if (eventType == 0) {
                        currentCopy.keyPressed(keyCode);
                    } else if (eventType == 1) {
                        currentCopy.keyReleased(keyCode);
                    } else if (eventType == 2) {
                        currentCopy.keyRepeated(keyCode);
                    } else {
                        currentCopy.keyTyped((char)keyCode);
                    }
                }
            }
            catch (Throwable thr) {
                Display.handleThrowable(thr);
            }
        }

        public void timerEvent(int type) {
            if (type == 3) {
                Display.this.serviceRepaints();
                Display.this.getCallSerially();
            } else if (type == 2) {
                Display.this.serviceRepaints();
            } else if (type == 1) {
                Displayable newCurrent = null;
                Object object = LCDUILock;
                synchronized (object) {
                    newCurrent = Display.this.pendingAlert;
                    if (newCurrent == null) {
                        newCurrent = Display.this.nextScreen;
                    } else if (Display.this.alertDelay != -2) {
                        eventHandler.scheduleTimer(1, Display.this.alertDelay);
                    }
                    if (Display.this.current == newCurrent && !Display.this.paintSuspended) {
                        return;
                    }
                }
                Display.this.registerNewCurrent(newCurrent, false);
            }
        }

        public void setForeground(boolean hasForeground) {
            eventHandler.setEventRecipient(this, hasForeground);
            if (hasForeground) {
                Display.this.registerNewCurrent(Display.this.current, true);
            } else {
                this.suspendPainting();
            }
        }

        public void inputMethodEvent(String str) {
            TextBox textBoxCopy = null;
            Object object = LCDUILock;
            synchronized (object) {
                if (Display.this.current instanceof TextBox) {
                    textBoxCopy = (TextBox)Display.this.current;
                }
            }
            if (textBoxCopy != null) {
                textBoxCopy.insert(str, textBoxCopy.getCaretPosition());
            }
        }

        public boolean hasCurrent() {
            return Display.this.hascurrent;
        }

        public Display getDisplay() {
            return Display.this;
        }
    }
}

