/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.PassTextPolicy;
import javax.microedition.lcdui.PhoneDial;
import javax.microedition.lcdui.PhonePolicy;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringLayout;
import javax.microedition.lcdui.TextBasic;
import javax.microedition.lcdui.TextEditor;

public class TextField
extends Item {
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int PASSWORD = 65536;
    public static final int CONSTRAINT_MASK = 65535;
    static final TextEditor textEditor = new TextEditor();
    TextBasic sD;
    private int width;
    private int labelWidth;
    private int tfWidth;
    private int contentHeight;
    private int height;
    private static final int SPACER = 8;
    private boolean horLayout;

    public TextField(String label, String text, int maxSize, int constraints) {
        super(label, 1);
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.sD = new TextBasic(constraints, maxSize, text);
        }
    }

    public String getString() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            String string = new String(this.sD.buffer, 0, this.sD.numChars);
            return string;
        }
    }

    public void setString(String text) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int deltaHeight = this.sD.setString(text);
            this.contentHeight += deltaHeight;
            this.height += deltaHeight;
            this.contentChanged(0, 0, deltaHeight);
        }
    }

    public int getChars(char[] data) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.sD.getChars(data);
            return n;
        }
    }

    public void setChars(char[] data, int offset, int length) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int deltaHeight = this.sD.setChars(data, offset, length);
            this.contentHeight += deltaHeight;
            this.height += deltaHeight;
            this.contentChanged(0, 0, deltaHeight);
        }
    }

    public void insert(String src, int position) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int deltaHeight = this.sD.insert(src, position);
            this.contentHeight += deltaHeight;
            this.height += deltaHeight;
            this.contentChanged(0, 0, deltaHeight);
        }
    }

    public void insert(char[] data, int offset, int length, int position) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.sD.insert(data, offset, length, position);
        }
    }

    public void delete(int offset, int length) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int deltaHeight = this.sD.deleteChars(offset, length);
            this.contentHeight += deltaHeight;
            this.height += deltaHeight;
            this.contentChanged(0, 0, deltaHeight);
        }
    }

    public int getMaxSize() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.sD.buffer.length;
            return n;
        }
    }

    public int setMaxSize(int maxSize) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int oldHeight = this.height;
            this.sD.setMaxSize(maxSize);
            this.layoutChanged(oldHeight);
            int n = this.sD.buffer.length;
            return n;
        }
    }

    public int size() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.sD.buffer == null) {
                int n = 0;
                return n;
            }
            int n = this.sD.numChars;
            return n;
        }
    }

    public int getCaretPosition() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.sD.numChars;
            return n;
        }
    }

    public void setConstraints(int constraints) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int oldHeight = this.height;
            this.sD.setConstraints(constraints);
            this.sD.setMaxSize(this.sD.buffer.length);
            this.layoutChanged(oldHeight);
        }
    }

    public int getConstraints() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.sD.constraints;
            return n;
        }
    }

    public void setLabel(String label) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.setLabel(label);
            int oldHeight = this.height;
            ((StringLayout)this.layouts[0]).setString(label);
            this.layoutChanged(oldHeight);
        }
    }

    int setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.doLayout();
        }
        return this.height;
    }

    int getHeight() {
        return this.height;
    }

    void paint(Graphics g) {
        int translateX = 0;
        int translateY = 0;
        g.setColor(Display.ERASE_COLOR);
        g.fillRect(0, 0, this.width, this.height);
        if (this.horLayout) {
            g.translate(0, 4);
            this.layouts[0].paint(g, false, false);
            translateX += this.labelWidth;
            g.translate(this.labelWidth, -4);
        } else {
            this.layouts[0].paint(g, false, false);
            int labelHeight = this.layouts[0].getHeight();
            g.translate(0, labelHeight);
            translateY += labelHeight;
        }
        if (this.hasFocus()) {
            g.setColor(0);
        } else {
            g.setColor(0xAFAFAF);
        }
        g.drawRect(2, 2, this.tfWidth + 4, this.contentHeight + 4);
        g.translate(4, 4);
        this.sD.policy.paint(g, this.sD.buffer, this.sD.numChars, false, 0, this.sD.policy instanceof PassTextPolicy);
        g.translate(-(translateX += 4), -(translateY += 4));
    }

    void saveHeight(int newContentHeight) {
        if (!this.horLayout) {
            int deltaHeight = newContentHeight - this.contentHeight;
            this.contentHeight = newContentHeight;
            this.height += deltaHeight;
            this.contentChanged(0, 0, deltaHeight);
        }
    }

    boolean select() {
        textEditor.invoke(this.getOwner(), this, 0, false);
        return false;
    }

    boolean keyPressed(int keyCode) {
        if (Display.getSystemKey(keyCode) == 2) {
            if (this.sD.policy instanceof PhonePolicy) {
                PhoneDial.call(this.getString());
            }
            return false;
        }
        if (Display.getSystemKey(keyCode) == 4) {
            if (this.sD.numChars > 0) {
                this.delete(this.sD.numChars - 1, 1);
            }
            keyCode = 0;
        }
        textEditor.invoke(this.getOwner(), this, keyCode, false);
        return false;
    }

    void keyTyped(char c) {
        textEditor.invoke(this.getOwner(), this, c, true);
    }

    private void doLayout() {
        this.labelWidth = 0;
        this.height = this.layouts[0].setWidth(this.width);
        this.tfWidth = this.sD.getMaxWidth(this.width - 8);
        this.contentHeight = this.sD.setWidth(this.tfWidth);
        this.horLayout = false;
        if (this.height <= Screen.CONTENT_HEIGHT && this.contentHeight <= Screen.CONTENT_HEIGHT) {
            String label = this.getLabel();
            if (label != null) {
                this.labelWidth = Screen.CONTENT_FONT.stringWidth(label);
            }
            if (this.labelWidth + this.tfWidth + 8 < this.width) {
                this.horLayout = true;
                this.height = this.contentHeight + 8;
                return;
            }
        }
        this.height += this.contentHeight + 8;
    }

    private void layoutChanged(int oldHeight) {
        if (this.initLayoutDone()) {
            this.doLayout();
            this.contentChanged(0, 0, this.height - oldHeight);
        }
    }
}

