/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.EventInfo;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.MemberInfo;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.Module;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.PropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Type
extends MemberInfo {
    public static final Type[] EmptyTypes = new Type[0];
    public static final char Delimiter = '.';
    public final String FullName;
    public final String Namespace;
    protected Type baseType;
    public final int Attributes;
    public final Module Module;
    protected FieldInfo[] fields;
    protected MethodInfo[] methods;
    protected ConstructorInfo[] constructors;
    protected PropertyInfo[] properties;
    protected EventInfo[] events;
    protected Type[] interfaces;
    protected Type[] nestedTypes;
    private final Type elemType;
    protected Type underlyingType;
    private int auxAttr;
    private static final Map types = new HashMap();
    protected MemberInfo[] members;
    private boolean initBaseType = true;
    private boolean initInterfaces = true;
    private boolean initNestedTypes = true;
    private boolean initFields = true;
    private boolean initMethods = true;
    private boolean initProperties = true;
    private boolean initEvents = true;
    private static Assembly MSCORLIB;
    private static Module MSCORLIB_DLL;
    private static Type __OBJECT;
    private static Type __STRING;
    private static Type __ARRAY;
    private static Type __VOID;
    private static Type __ENUM;
    private static Type __VALUE_TYPE;

    public final Type BaseType() {
        this.initBaseType();
        return this.baseType;
    }

    public final Assembly Assembly() {
        return this.Module.Assembly;
    }

    public final int MemberType() {
        return this.DeclaringType == null ? 32 : 128;
    }

    protected static Type getType(String name2) {
        return (Type)types.get(name2);
    }

    protected static Type addType(Type t) {
        Type oldType = types.put(t.FullName, t);
        return t;
    }

    protected Type(Module module, int attr, String fullName, Type baseType, Type[] interfaces, Type declType, int auxAttr, Type elemType) {
        super(fullName.lastIndexOf(46) < 0 ? fullName : fullName.substring(fullName.lastIndexOf(46) + 1, fullName.length()), declType);
        this.Module = module;
        this.Attributes = attr;
        this.baseType = baseType;
        if (this.DeclaringType == null) {
            this.FullName = fullName;
            int i = this.FullName.lastIndexOf(46);
            this.Namespace = i < 0 ? "" : this.FullName.substring(0, i);
        } else {
            this.FullName = declType.FullName + "+" + fullName;
            this.Namespace = this.DeclaringType.Namespace;
        }
        this.interfaces = interfaces;
        this.elemType = elemType;
        this.auxAttr = auxAttr;
    }

    public final boolean IsAbstract() {
        return (this.Attributes & 0x80) != 0;
    }

    public final boolean IsPublic() {
        return (this.Attributes & 7) == 1;
    }

    public final boolean IsNotPublic() {
        return (this.Attributes & 7) == 0;
    }

    public final boolean IsNestedPublic() {
        return (this.Attributes & 7) == 2;
    }

    public final boolean IsNestedPrivate() {
        return (this.Attributes & 7) == 3;
    }

    public final boolean IsNestedFamily() {
        return (this.Attributes & 7) == 4;
    }

    public final boolean IsNestedAssembly() {
        return (this.Attributes & 7) == 5;
    }

    public final boolean IsNestedFamORAssem() {
        return (this.Attributes & 7) == 7;
    }

    public final boolean IsNestedFamANDAssem() {
        return (this.Attributes & 7) == 6;
    }

    public final boolean IsSealed() {
        return (this.Attributes & 0x100) != 0;
    }

    public final boolean IsSpecialName() {
        return (this.Attributes & 0x400) != 0;
    }

    public final boolean IsClass() {
        return (this.Attributes & 0x20) == 0;
    }

    public final boolean IsInterface() {
        return (this.Attributes & 0x20) == 32;
    }

    public final boolean IsAutoLayout() {
        return (this.Attributes & 0x18) == 0;
    }

    public final boolean IsExplictitLayout() {
        return (this.Attributes & 0x18) == 16;
    }

    public final boolean IsLayoutSequential() {
        return (this.Attributes & 0x18) == 8;
    }

    public final boolean IsImport() {
        return (this.Attributes & 0x1000) != 0;
    }

    public final boolean IsSerializable() {
        return (this.Attributes & 0x2000) != 0;
    }

    public final boolean IsAnsiClass() {
        return (this.Attributes & 0x30000) == 0;
    }

    public final boolean IsUnicodeClass() {
        return (this.Attributes & 0x30000) == 65536;
    }

    public final boolean IsAutoClass() {
        return (this.Attributes & 0x30000) == 131072;
    }

    public final boolean IsArray() {
        return (this.auxAttr & 1) != 0;
    }

    public final boolean IsByRef() {
        return (this.auxAttr & 2) != 0;
    }

    public final boolean IsPointer() {
        return (this.auxAttr & 8) != 0;
    }

    public final boolean IsPrimitive() {
        return (this.auxAttr & 0x10) != 0;
    }

    public final boolean IsValueType() {
        return this.BaseType() == Type.VALUE_TYPE() || this.IsEnum();
    }

    public final boolean IsEnum() {
        return this.BaseType() == Type.ENUM();
    }

    public final boolean HasElementType() {
        return this.IsArray() || this.IsPointer() || this.IsByRef();
    }

    protected Type(Module module, int attr, String fullName, Type baseType, Type[] interfaces, Type declType, int auxAttr) {
        this(module, attr, fullName, baseType, interfaces, declType, auxAttr, null);
    }

    public static Type mkArray(Type elemType, int rank) {
        StringBuffer arrSig = new StringBuffer("[");
        for (int i = 0; i < rank; ++i) {
            if (i <= 0) continue;
            arrSig.append(',');
        }
        arrSig.append(']');
        Type array = Type.getType(elemType.FullName + arrSig);
        if (array != null) {
            return array;
        }
        array = new PrimitiveType(elemType.Module, 8449, elemType.FullName + arrSig, Type.ARRAY(), EmptyTypes, null, 1, elemType);
        return Type.addType(array);
    }

    public static Type mkPtr(Type elemType) {
        String name2 = elemType.FullName + "*";
        Type type = Type.getType(name2);
        if (type != null) {
            return type;
        }
        type = new PrimitiveType(elemType.Module, 0, name2, null, EmptyTypes, null, 8, elemType);
        return Type.addType(type);
    }

    public static Type GetType(String fullName) {
        Type type = Type.getType(fullName);
        if (type != null) {
            return type;
        }
        int i = fullName.lastIndexOf(91);
        int j = fullName.lastIndexOf(93);
        if (i >= 0) {
            if (j > i && j == fullName.length() - 1) {
                String elementTypeName = fullName.substring(0, i);
                Type elementType = Type.GetType(elementTypeName);
                if (elementType == null) {
                    throw new RuntimeException("Unknown element type '" + elementTypeName + "' for the array type: " + fullName);
                }
                int rank = j - i;
                for (int k = i + 1; k < j; ++k) {
                    if (fullName.charAt(k) == ',') continue;
                    throw new RuntimeException("Malformed type name: " + fullName);
                }
                return Type.mkArray(elementType, rank);
            }
            throw new RuntimeException("Malformed type name: " + fullName);
        }
        if (fullName.charAt(fullName.length() - 1) == '*') {
            return Type.addType(Type.mkPtr(Type.GetType(fullName.substring(0, fullName.length() - 1))));
        }
        i = fullName.lastIndexOf(43);
        if (i > 0) {
            if (i == 0 || i == fullName.length() - 1) {
                throw new RuntimeException("malformedTypeName");
            }
            Type enclosing = Type.GetType(fullName.substring(0, i));
            return enclosing == null ? null : enclosing.GetNestedType(fullName.substring(i + 1));
        }
        Iterator assems = Assembly.assemblies.values().iterator();
        while (type == null && assems.hasNext()) {
            Assembly assem = (Assembly)assems.next();
            type = assem.GetType(fullName);
        }
        Type type2 = Type.getType(fullName);
        if (type == type2) {
            return type;
        }
        return type == null ? null : Type.addType(type);
    }

    public Type GetElementType() {
        return this.elemType;
    }

    public Type getUnderlyingType() {
        if (!this.IsEnum()) {
            return null;
        }
        this.initFields();
        return this.underlyingType;
    }

    public FieldInfo GetField(String name2) {
        this.initFields();
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].Name.equals(name2) || this.fields[i].IsPrivate()) continue;
            return this.fields[i];
        }
        return null;
    }

    public FieldInfo GetField(String name2, int bindingFlags) {
        FieldInfo[] fields = this.GetFields(bindingFlags);
        for (int i = 0; i < fields.length; ++i) {
            if (!name2.equals(fields[i].Name)) continue;
            return fields[i];
        }
        return null;
    }

    public FieldInfo[] GetFields() {
        return this.GetFields(20);
    }

    public FieldInfo[] GetFields(int bindingFlags) {
        this.initFields();
        FieldInfo[] fields = this.getAllFields((bindingFlags & 2) != 0);
        boolean getInstance = (bindingFlags & 4) != 0;
        boolean getStatic = (bindingFlags & 8) != 0;
        boolean getPublic = (bindingFlags & 0x10) != 0;
        boolean getNonPublic = (bindingFlags & 0x20) != 0;
        int cnt = 0;
        for (int i = 0; i < fields.length; ++i) {
            boolean accessible;
            FieldInfo field = fields[i];
            boolean bl = accessible = getPublic && field.IsPublic() || getNonPublic && !field.IsPublic();
            if (!accessible || field.DeclaringType != this && (field.DeclaringType == this || field.IsPrivate()) || (!getInstance || field.IsStatic()) && (!getStatic || !field.IsStatic() || field.DeclaringType != this && (bindingFlags & 0x40) == 0)) continue;
            fields[cnt++] = field;
        }
        FieldInfo[] resFields = new FieldInfo[cnt];
        System.arraycopy(fields, 0, resFields, 0, cnt);
        return resFields;
    }

    protected FieldInfo[] getAllFields(boolean declaredOnly) {
        this.initFields();
        FieldInfo[] inherited = this.BaseType() == null || declaredOnly ? FieldInfo.EMPTY_ARRAY : this.BaseType().getAllFields(declaredOnly);
        FieldInfo[] allFields = new FieldInfo[inherited.length + this.fields.length];
        System.arraycopy(inherited, 0, allFields, 0, inherited.length);
        System.arraycopy(this.fields, 0, allFields, inherited.length, this.fields.length);
        return allFields;
    }

    public ConstructorInfo GetConstructor(Type[] paramTypes2) {
        this.initMethods();
        for (int i = 0; i < this.constructors.length; ++i) {
            if (!Type.equalParameters(this.constructors[i].GetParameters(), paramTypes2)) continue;
            return this.constructors[i];
        }
        return null;
    }

    public ConstructorInfo[] GetConstructors() {
        return this.GetConstructors(20);
    }

    public ConstructorInfo[] GetConstructors(int bindingFlags) {
        this.initMethods();
        boolean getInstance = (bindingFlags & 4) != 0;
        boolean getStatic = (bindingFlags & 8) != 0;
        boolean getPublic = (bindingFlags & 0x10) != 0;
        boolean getNonPublic = (bindingFlags & 0x20) != 0;
        ConstructorInfo[] constrs = new ConstructorInfo[this.constructors.length];
        int cnt = 0;
        for (int i = 0; i < this.constructors.length; ++i) {
            boolean accessible;
            ConstructorInfo constr = this.constructors[i];
            boolean bl = accessible = getPublic && constr.IsPublic() || getNonPublic && !constr.IsPublic();
            if (!accessible || (!getInstance || constr.IsStatic()) && (!getStatic || !constr.IsStatic())) continue;
            constrs[cnt++] = constr;
        }
        ConstructorInfo[] resConstrs = new ConstructorInfo[cnt];
        System.arraycopy(constrs, 0, resConstrs, 0, cnt);
        return resConstrs;
    }

    public MethodInfo GetMethod(String name2, Type[] paramTypes2) {
        return this.GetMethod(name2, paramTypes2, null);
    }

    public MethodInfo GetMethod(String name2, Type[] paramTypes2, Type retType) {
        this.initMethods();
        MethodInfo method = Type.findMethod(this.methods, name2, paramTypes2, retType);
        if (method != null) {
            return method;
        }
        if (this.BaseType() != null && (method = this.BaseType().GetMethod(name2, paramTypes2, retType)) != null) {
            return method;
        }
        return null;
    }

    protected static MethodInfo findMethod(MethodInfo[] methods2, String name2, Type[] paramTypes2, Type retType) {
        for (int i = 0; i < methods2.length; ++i) {
            if (!name2.equals(methods2[i].Name) || !Type.equalParameters(methods2[i].GetParameters(), paramTypes2) || retType != null && methods2[i].ReturnType != retType) continue;
            return methods2[i];
        }
        return null;
    }

    protected static boolean equalParameters(ParameterInfo[] params2, Type[] paramTypes2) {
        if (params2.length != paramTypes2.length) {
            return false;
        }
        for (int i = 0; i < params2.length; ++i) {
            if (params2[i].ParameterType == paramTypes2[i]) continue;
            return false;
        }
        return true;
    }

    public MethodInfo GetMethod(String name2, Type[] paramTypes2, int bindingFlags) {
        MethodInfo[] methods2 = this.GetMethods(bindingFlags);
        MethodInfo method = Type.findMethod(methods2, name2, paramTypes2, null);
        if (method == null) {
            int i;
            StringBuffer str = new StringBuffer(name2);
            str.append('(');
            for (i = 0; i < paramTypes2.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(paramTypes2[i]);
            }
            str.append(')');
            System.out.println("Cannot find method " + str + ":");
            System.out.println("Methods of class " + this);
            for (i = 0; i < methods2.length; ++i) {
                System.out.println("\t" + methods2[i]);
            }
        }
        return method;
    }

    public MethodInfo[] GetMethods() {
        return this.GetMethods(20);
    }

    public MethodInfo[] GetMethods(int bindingFlags) {
        this.initMethods();
        MethodInfo[] methods2 = this.getAllMethods((bindingFlags & 2) != 0);
        boolean getInstance = (bindingFlags & 4) != 0;
        boolean getStatic = (bindingFlags & 8) != 0;
        boolean getPublic = (bindingFlags & 0x10) != 0;
        boolean getNonPublic = (bindingFlags & 0x20) != 0;
        int cnt = 0;
        for (int i = 0; i < methods2.length; ++i) {
            boolean accessible;
            MethodInfo method = methods2[i];
            boolean bl = accessible = getPublic && method.IsPublic() || getNonPublic && !method.IsPublic();
            if (!accessible || method.DeclaringType != this && (method.DeclaringType == this || method.IsPrivate()) || (!getInstance || method.IsStatic()) && (!getStatic || !method.IsStatic() || method.DeclaringType != this && (bindingFlags & 0x40) == 0)) continue;
            methods2[cnt++] = method;
        }
        MethodInfo[] resMethods = new MethodInfo[cnt];
        System.arraycopy(methods2, 0, resMethods, 0, cnt);
        return resMethods;
    }

    protected MethodInfo[] getAllMethods(boolean declaredOnly) {
        this.initMethods();
        MethodInfo[] inherited = this.BaseType() == null || declaredOnly ? MethodInfo.EMPTY_ARRAY : this.BaseType().getAllMethods(declaredOnly);
        MethodInfo[] allMethods = new MethodInfo[inherited.length + this.methods.length];
        System.arraycopy(inherited, 0, allMethods, 0, inherited.length);
        System.arraycopy(this.methods, 0, allMethods, inherited.length, this.methods.length);
        return allMethods;
    }

    public PropertyInfo[] GetProperties() {
        this.initProperties();
        return (PropertyInfo[])this.properties.clone();
    }

    public PropertyInfo[] GetProperties(int bindingFlags) {
        this.initProperties();
        return (PropertyInfo[])this.properties.clone();
    }

    public PropertyInfo GetProperty(String name2) {
        this.initProperties();
        for (int i = 0; i < this.properties.length; ++i) {
            if (!name2.equals(this.properties[i].Name)) continue;
            return this.properties[i];
        }
        return null;
    }

    public PropertyInfo GetProperty(String name2, int bindingFlags) {
        throw new RuntimeException("Method not implemented yet");
    }

    public EventInfo[] GetEvents() {
        this.initEvents();
        return (EventInfo[])this.events.clone();
    }

    public Type GetNestedType(String name2) {
        this.initNestedTypes();
        for (int i = 0; i < this.nestedTypes.length; ++i) {
            if (!this.nestedTypes[i].Name.equals(name2)) continue;
            return this.nestedTypes[i];
        }
        return null;
    }

    public Type[] GetNestedTypes() {
        this.initNestedTypes();
        return (Type[])this.nestedTypes.clone();
    }

    public Type GetInterface(String name2) {
        return this.GetInterface(name2, false);
    }

    public Type GetInterface(String name2, boolean ignoreCase) {
        this.initInterfaces();
        for (int i = 0; i < this.interfaces.length; ++i) {
            Type iface = this.interfaces[i];
            if (ignoreCase) {
                if (name2.equalsIgnoreCase(iface.Name)) {
                    return iface;
                }
                if (!name2.equalsIgnoreCase(iface.FullName)) continue;
                return iface;
            }
            if (name2.equals(iface.Name)) {
                return iface;
            }
            if (!name2.equals(iface.FullName)) continue;
            return iface;
        }
        return this.BaseType() == null ? null : this.BaseType().GetInterface(name2, ignoreCase);
    }

    public Type[] GetInterfaces() {
        this.initInterfaces();
        if (this.BaseType() == null) {
            return this.interfaces;
        }
        Type[] ifaces = this.interfaces;
        int count2 = 0;
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (this.BaseType().GetInterface(this.interfaces[i].FullName) != null) continue;
            ifaces[count2++] = ifaces[i];
        }
        Type[] baseTypeIfaces = this.BaseType().GetInterfaces();
        Type[] res = new Type[baseTypeIfaces.length + count2];
        System.arraycopy(baseTypeIfaces, 0, res, 0, baseTypeIfaces.length);
        System.arraycopy(ifaces, 0, res, baseTypeIfaces.length, count2);
        return res;
    }

    public boolean isSubtypeOf(Type that) {
        if (this == that || this.BaseType() == that || that == Type.OBJECT()) {
            return true;
        }
        this.initInterfaces();
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (!this.interfaces[i].isSubtypeOf(that)) continue;
            return true;
        }
        boolean res = this.BaseType() == null ? false : this.BaseType().isSubtypeOf(that);
        return res;
    }

    private static String formatType(Type t) {
        if (t == null) {
            return "<null>";
        }
        String cname = t.getClass().getName();
        int k = cname.lastIndexOf(".");
        if (k >= 0) {
            cname = cname.substring(k + 1);
        }
        return "[" + t.Assembly().GetName() + "]" + t + "(" + cname + "#" + Integer.toHexString(t.hashCode()) + ")";
    }

    private static String dumpType(Type t) {
        StringBuffer str = new StringBuffer();
        str.append(Type.formatType(t) + " : ");
        str.append(Type.formatType(t.BaseType()));
        Type[] ifaces = t.GetInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            str.append(", " + Type.formatType(ifaces[i]));
        }
        return str.toString();
    }

    public MemberInfo[] GetMember(String name2) {
        this.aggregateMembers();
        ArrayList<MemberInfo> l = new ArrayList<MemberInfo>();
        for (int i = 0; i < this.members.length; ++i) {
            if (!name2.equals(this.members[i].Name)) continue;
            l.add(this.members[i]);
        }
        return l.toArray(MemberInfo.EMPTY_ARRAY);
    }

    protected void aggregateMembers() {
        if (this.members != null) {
            return;
        }
        this.initFields();
        this.initMethods();
        this.initProperties();
        this.initNestedTypes();
        ArrayList<FieldInfo> l = new ArrayList<FieldInfo>(Arrays.asList(this.fields));
        l.addAll(Arrays.asList(this.constructors));
        l.addAll(Arrays.asList(this.methods));
        l.addAll(Arrays.asList(this.properties));
        l.addAll(Arrays.asList(this.nestedTypes));
        this.members = l.toArray(MemberInfo.EMPTY_ARRAY);
    }

    public FieldInfo[] getFields() {
        this.initFields();
        FieldInfo[] fields = new FieldInfo[this.fields.length];
        System.arraycopy(this.fields, 0, fields, 0, fields.length);
        return fields;
    }

    public ConstructorInfo[] getConstructors() {
        this.initMethods();
        ConstructorInfo[] ctors = new ConstructorInfo[this.constructors.length];
        System.arraycopy(this.constructors, 0, ctors, 0, ctors.length);
        return ctors;
    }

    public MethodInfo[] getMethods() {
        this.initMethods();
        MethodInfo[] methods2 = new MethodInfo[this.methods.length];
        System.arraycopy(this.methods, 0, methods2, 0, methods2.length);
        return methods2;
    }

    public PropertyInfo[] getProperties() {
        this.initProperties();
        PropertyInfo[] props = new PropertyInfo[this.properties.length];
        System.arraycopy(this.properties, 0, props, 0, props.length);
        return props;
    }

    public Type[] getInterfaces() {
        this.initInterfaces();
        Type[] ifaces = new Type[this.interfaces.length];
        System.arraycopy(this.interfaces, 0, ifaces, 0, ifaces.length);
        return ifaces;
    }

    public Type[] getNestedTypes() {
        this.initNestedTypes();
        Type[] nested = new Type[this.nestedTypes.length];
        System.arraycopy(this.nestedTypes, 0, nested, 0, nested.length);
        return nested;
    }

    public String toString() {
        return this.FullName;
    }

    protected final void initBaseType() {
        if (this.initBaseType) {
            this.loadBaseType();
            this.initBaseType = false;
        }
    }

    protected void loadBaseType() {
    }

    protected void initInterfaces() {
        if (this.initInterfaces) {
            this.loadInterfaces();
            this.initInterfaces = false;
        }
        assert (this.interfaces != null) : "In type " + this;
    }

    protected void loadInterfaces() {
    }

    protected void initNestedTypes() {
        if (this.initNestedTypes) {
            this.loadNestedTypes();
            this.initNestedTypes = false;
        }
        assert (this.nestedTypes != null) : "In type " + this;
    }

    protected void loadNestedTypes() {
    }

    protected void initFields() {
        if (this.initFields) {
            this.loadFields();
            this.initFields = false;
        }
        assert (this.fields != null) : "In type " + this;
    }

    protected void loadFields() {
    }

    protected void initMethods() {
        if (this.initMethods) {
            this.loadMethods();
            this.initMethods = false;
        }
        assert (this.constructors != null) : "In type " + this;
        assert (this.methods != null) : "In type " + this;
    }

    protected void loadMethods() {
    }

    protected void initProperties() {
        if (this.initProperties) {
            this.initMethods();
            this.loadProperties();
            this.initProperties = false;
        }
        assert (this.properties != null) : "In type " + this;
    }

    protected void loadProperties() {
    }

    protected void initEvents() {
        if (this.initEvents) {
            this.initMethods();
            this.loadEvents();
            this.initEvents = false;
        }
        assert (this.events != null) : "In type " + this;
    }

    protected void loadEvents() {
    }

    public static Type OBJECT() {
        return __OBJECT;
    }

    public static Type STRING() {
        return __STRING;
    }

    public static Type ARRAY() {
        return __ARRAY;
    }

    public static Type VOID() {
        return __VOID;
    }

    public static Type ENUM() {
        return __ENUM;
    }

    public static Type VALUE_TYPE() {
        return __VALUE_TYPE;
    }

    public static void initMSCORLIB(Assembly mscorlib) {
        if (MSCORLIB != null) {
            throw new RuntimeException("mscorlib already initialized");
        }
        MSCORLIB = mscorlib;
        MSCORLIB_DLL = MSCORLIB.GetModules()[0];
        __OBJECT = mscorlib.GetType("System.Object");
        __STRING = mscorlib.GetType("System.String");
        __ARRAY = mscorlib.GetType("System.Array");
        __VOID = mscorlib.GetType("System.Void");
        __ENUM = mscorlib.GetType("System.Enum");
        __VALUE_TYPE = mscorlib.GetType("System.ValueType");
    }

    protected static final class AuxAttr {
        public static final int None = 0;
        public static final int Array = 1;
        public static final int ByRef = 2;
        public static final int Pointer = 8;
        public static final int Primitive = 16;

        protected AuxAttr() {
        }
    }

    static final class PrimitiveType
    extends Type {
        public PrimitiveType(Module module, int attributes, String fullName, Type baseType, Type[] interfaces, Type declType, int auxAttr, Type elemType) {
            super(module, attributes, fullName, baseType, interfaces, declType, auxAttr, elemType);
        }
    }
}

