/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;
import scala.xml.parsing.TokenTests;
import scala.xml.parsing.TokenTests$;

public abstract class TokenTests$class {
    public static final boolean isSpace(TokenTests $this, char ch) {
        boolean bl;
        char c = ch;
        switch (c) {
            default: {
                bl = false;
                break;
            }
            case ' ': {
                bl = true;
                break;
            }
            case '\r': {
                bl = true;
                break;
            }
            case '\n': {
                bl = true;
                break;
            }
            case '\t': {
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isSpace(TokenTests $this, Seq cs) {
        return cs.nonEmpty() && cs.forall(new TokenTests$.anonfun.isSpace.1($this));
    }

    public static boolean isAlpha(TokenTests $this, char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isAlphaDigit(TokenTests $this, char c) {
        return $this.isAlpha(c) || c >= '0' && c <= '9';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNameChar(TokenTests $this, char ch) {
        boolean bl;
        if ($this.isNameStart(ch)) return true;
        byte by2 = (byte)Character.getType(ch);
        switch (by2) {
            default: {
                bl = Predef$.MODULE$.augmentString(".-:").contains(BoxesRunTime.boxToCharacter(ch));
                break;
            }
            case 9: {
                return true;
            }
            case 8: {
                return true;
            }
            case 7: {
                return true;
            }
            case 6: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        if (!bl) return false;
        return true;
    }

    public static boolean isNameStart(TokenTests $this, char ch) {
        boolean bl;
        byte by2 = (byte)Character.getType(ch);
        switch (by2) {
            default: {
                if (ch == '_') {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 10: {
                bl = true;
                break;
            }
            case 5: {
                bl = true;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 1: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isName(TokenTests $this, String s) {
        return Predef$.MODULE$.augmentString(s).nonEmpty() && $this.isNameStart(BoxesRunTime.unboxToChar(Predef$.MODULE$.augmentString(s).head())) && Predef$.MODULE$.augmentString((String)Predef$.MODULE$.augmentString(s).tail()).forall(new TokenTests$.anonfun.isName.1($this));
    }

    public static boolean isPubIDChar(TokenTests $this, char ch) {
        return $this.isAlphaDigit(ch) || $this.isSpace(ch) && ch != '\t' || Predef$.MODULE$.augmentString("-\\()+,./:=?;!*#@$_%").contains(BoxesRunTime.boxToCharacter(ch));
    }

    public static boolean isValidIANAEncoding(TokenTests $this, Seq ianaEncoding) {
        return ianaEncoding.nonEmpty() && $this.isAlpha(BoxesRunTime.unboxToChar(ianaEncoding.head())) && ((IterableLike)ianaEncoding.tail()).forall(new TokenTests$.anonfun.isValidIANAEncoding.1($this));
    }

    public static boolean checkSysID(TokenTests $this, String s$1) {
        return List$.MODULE$.apply(Predef$.MODULE$.wrapCharArray(new char[]{'\"', '\''})).exists(new TokenTests$.anonfun.checkSysID.1($this, s$1));
    }

    public static boolean checkPubID(TokenTests $this, String s) {
        return Predef$.MODULE$.augmentString(s).forall(new TokenTests$.anonfun.checkPubID.1($this));
    }

    public static final boolean charOK$1(TokenTests $this, char c) {
        return $this.isAlphaDigit(c) || Predef$.MODULE$.augmentString("._-").contains(BoxesRunTime.boxToCharacter(c));
    }

    public static void $init$(TokenTests $this) {
    }
}

