/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqOptimized;
import scala.collection.IndexedSeqOptimized$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.mutable.Builder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class IndexedSeqOptimized$class {
    public static boolean isEmpty(IndexedSeqOptimized $this) {
        return $this.length() == 0;
    }

    public static void foreach(IndexedSeqOptimized $this, Function1 f) {
        int len = $this.length();
        for (int i = 0; i < len; ++i) {
            f.apply($this.apply(i));
        }
    }

    public static boolean forall(IndexedSeqOptimized $this, Function1 p$2) {
        return $this.prefixLength(new IndexedSeqOptimized$.anonfun.forall.1($this, p$2)) == $this.length();
    }

    public static boolean exists(IndexedSeqOptimized $this, Function1 p$1) {
        return $this.prefixLength(new IndexedSeqOptimized$.anonfun.exists.1($this, p$1)) != $this.length();
    }

    public static Option find(IndexedSeqOptimized $this, Function1 p$3) {
        int i = $this.prefixLength(new IndexedSeqOptimized$.anonfun.1($this, p$3));
        return i < $this.length() ? new Some($this.apply(i)) : None$.MODULE$;
    }

    private static Object foldl(IndexedSeqOptimized $this, int start2, int end, Object z, Function2 op) {
        while (start2 != end) {
            z = op.apply(z, $this.apply(start2));
            ++start2;
        }
        return z;
    }

    private static Object foldr(IndexedSeqOptimized $this, int start2, int end, Object z, Function2 op) {
        while (start2 != end) {
            z = op.apply($this.apply(end - 1), z);
            --end;
        }
        return z;
    }

    public static Object foldLeft(IndexedSeqOptimized $this, Object z, Function2 op) {
        return IndexedSeqOptimized$class.foldl($this, 0, $this.length(), z, op);
    }

    public static Object foldRight(IndexedSeqOptimized $this, Object z, Function2 op) {
        return IndexedSeqOptimized$class.foldr($this, 0, $this.length(), z, op);
    }

    public static Object reduceLeft(IndexedSeqOptimized $this, Function2 op) {
        return $this.length() > 0 ? IndexedSeqOptimized$class.foldl($this, 1, $this.length(), $this.apply(0), op) : $this.scala$collection$IndexedSeqOptimized$$super$reduceLeft(op);
    }

    public static Object reduceRight(IndexedSeqOptimized $this, Function2 op) {
        return $this.length() > 0 ? IndexedSeqOptimized$class.foldr($this, 0, $this.length() - 1, $this.apply($this.length() - 1), op) : $this.scala$collection$IndexedSeqOptimized$$super$reduceRight(op);
    }

    public static Object zip(IndexedSeqOptimized $this, Iterable that, CanBuildFrom bf) {
        Object object;
        Iterable iterable = that;
        if (iterable instanceof IndexedSeq) {
            IndexedSeq indexedSeq;
            IndexedSeq that2 = indexedSeq = (IndexedSeq)iterable;
            Builder b = bf.apply($this.repr());
            int len = Predef$.MODULE$.intWrapper($this.length()).min(that2.length());
            b.sizeHint(len);
            for (int i = 0; i < len; ++i) {
                b.$plus$eq(new Tuple2($this.apply(i), that2.apply(i)));
            }
            object = b.result();
        } else {
            object = $this.scala$collection$IndexedSeqOptimized$$super$zip(that, bf);
        }
        return object;
    }

    public static Object zipWithIndex(IndexedSeqOptimized $this, CanBuildFrom bf) {
        Builder b = bf.apply($this.repr());
        int len = $this.length();
        b.sizeHint(len);
        for (int i = 0; i < len; ++i) {
            b.$plus$eq(new Tuple2($this.apply(i), BoxesRunTime.boxToInteger(i)));
        }
        return b.result();
    }

    public static Object slice(IndexedSeqOptimized $this, int from2, int until2) {
        int i;
        int end = Predef$.MODULE$.intWrapper(until2).min($this.length());
        Builder b = $this.newBuilder();
        b.sizeHint(end - i);
        for (i = Predef$.MODULE$.intWrapper(from2).max(0); i < end; ++i) {
            b.$plus$eq($this.apply(i));
        }
        return b.result();
    }

    public static Object head(IndexedSeqOptimized $this) {
        return $this.isEmpty() ? $this.scala$collection$IndexedSeqOptimized$$super$head() : $this.apply(0);
    }

    public static Object tail(IndexedSeqOptimized $this) {
        return $this.isEmpty() ? $this.scala$collection$IndexedSeqOptimized$$super$tail() : $this.slice(1, $this.length());
    }

    public static Object last(IndexedSeqOptimized $this) {
        return $this.length() > 0 ? $this.apply($this.length() - 1) : $this.scala$collection$IndexedSeqOptimized$$super$last();
    }

    public static Object init(IndexedSeqOptimized $this) {
        return $this.length() > 0 ? $this.slice(0, $this.length() - 1) : $this.scala$collection$IndexedSeqOptimized$$super$init();
    }

    public static Object take(IndexedSeqOptimized $this, int n) {
        return $this.slice(0, n);
    }

    public static Object drop(IndexedSeqOptimized $this, int n) {
        return $this.slice(n, $this.length());
    }

    public static Object takeRight(IndexedSeqOptimized $this, int n) {
        return $this.slice($this.length() - n, $this.length());
    }

    public static Object dropRight(IndexedSeqOptimized $this, int n) {
        return $this.slice(0, $this.length() - n);
    }

    public static Tuple2 splitAt(IndexedSeqOptimized $this, int n) {
        return new Tuple2($this.take(n), $this.drop(n));
    }

    public static Object takeWhile(IndexedSeqOptimized $this, Function1 p) {
        return $this.take($this.prefixLength(p));
    }

    public static Object dropWhile(IndexedSeqOptimized $this, Function1 p) {
        return $this.drop($this.prefixLength(p));
    }

    public static Tuple2 span(IndexedSeqOptimized $this, Function1 p) {
        return $this.splitAt($this.prefixLength(p));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean sameElements(IndexedSeqOptimized $this, Iterable that) {
        Iterable iterable = that;
        if (iterable instanceof IndexedSeq) {
            int i;
            IndexedSeq indexedSeq;
            IndexedSeq that2 = indexedSeq = (IndexedSeq)iterable;
            int len = $this.length();
            if (len != that2.length()) return false;
            for (i = 0; i < len && BoxesRunTime.equals($this.apply(i), that2.apply(i)); ++i) {
            }
            if (i != len) return false;
            return true;
        }
        boolean bl = $this.scala$collection$IndexedSeqOptimized$$super$sameElements(that);
        return bl;
    }

    public static void copyToArray(IndexedSeqOptimized $this, Object xs, int start2, int len) {
        int i = 0;
        int j = start2;
        int end = Predef$.MODULE$.intWrapper(Predef$.MODULE$.intWrapper($this.length()).min(len)).min(ScalaRunTime$.MODULE$.array_length(xs) - start2);
        while (i < end) {
            ScalaRunTime$.MODULE$.array_update(xs, j, $this.apply(i));
            ++i;
            ++j;
        }
    }

    public static int lengthCompare(IndexedSeqOptimized $this, int len) {
        return $this.length() - len;
    }

    public static int segmentLength(IndexedSeqOptimized $this, Function1 p, int from2) {
        int i;
        int start2 = from2;
        int len = $this.length();
        for (i = start2; i < len && BoxesRunTime.unboxToBoolean(p.apply($this.apply(i))); ++i) {
        }
        return i - start2;
    }

    private static int negLength(IndexedSeqOptimized $this, int n) {
        return n == $this.length() ? -1 : n;
    }

    public static int indexWhere(IndexedSeqOptimized $this, Function1 p$4, int from2) {
        int start2 = Predef$.MODULE$.intWrapper(from2).max(0);
        return IndexedSeqOptimized$class.negLength($this, start2 + $this.segmentLength(new IndexedSeqOptimized$.anonfun.indexWhere.1($this, p$4), start2));
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexWhere(IndexedSeqOptimized $this, Function1 p, int end) {
        void var3_3;
        for (int i = end; i >= 0 && !BoxesRunTime.unboxToBoolean(p.apply($this.apply(i))); --i) {
        }
        return (int)var3_3;
    }

    public static Object reverse(IndexedSeqOptimized $this) {
        Builder b = $this.newBuilder();
        b.sizeHint($this.length());
        int i = $this.length();
        while (0 < i) {
            b.$plus$eq($this.apply(--i));
        }
        return b.result();
    }

    public static Iterator reverseIterator(IndexedSeqOptimized $this) {
        return new IndexedSeqOptimized$.anon.1($this);
    }

    public static boolean startsWith(IndexedSeqOptimized $this, Seq that, int offset) {
        boolean bl;
        Seq seq2 = that;
        if (seq2 instanceof IndexedSeq) {
            int j;
            IndexedSeq indexedSeq;
            IndexedSeq that2 = indexedSeq = (IndexedSeq)seq2;
            int i = offset;
            int thisLen = $this.length();
            int thatLen = that2.length();
            for (j = 0; i < thisLen && j < thatLen && BoxesRunTime.equals($this.apply(i), that2.apply(j)); ++i, ++j) {
            }
            bl = j == thatLen;
        } else {
            int thisLen = $this.length();
            Iterator thatElems = that.iterator();
            for (int i = offset; i < thisLen && thatElems.hasNext(); ++i) {
                if (BoxesRunTime.equals($this.apply(i), thatElems.next())) {
                    continue;
                }
                return false;
            }
            bl = !thatElems.hasNext();
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean endsWith(IndexedSeqOptimized $this, Seq that) {
        Seq seq2 = that;
        if (seq2 instanceof IndexedSeq) {
            IndexedSeq indexedSeq;
            IndexedSeq that2 = indexedSeq = (IndexedSeq)seq2;
            int i = $this.length() - 1;
            int j = that2.length() - 1;
            if (j > i) return false;
            while (j >= 0) {
                if (!BoxesRunTime.equals($this.apply(i), that2.apply(j))) return false;
                --i;
                --j;
            }
            if (!true) return false;
            return true;
        }
        boolean bl = $this.scala$collection$IndexedSeqOptimized$$super$endsWith(that);
        return bl;
    }

    public static void $init$(IndexedSeqOptimized $this) {
    }
}

