/* NSC -- new Scala compiler
 * Copyright 2005-2010 LAMP/EPFL
 * @author  Martin Odersky
 */
// $Id: OfflineCompilerCommand.scala 21367 2010-04-07 13:59:44Z cunei $

package scala.tools.nsc

/** A compiler command for the offline compiler.
 *
 * @author Martin Odersky and Lex Spoon
 */
class OfflineCompilerCommand(
  arguments: List[String],
  settings: Settings)
extends CompilerCommand(arguments, settings) {
  override val cmdName = "fsc"
  import settings._
  
  disable(prompt)
  disable(resident)
  
  BooleanSetting("-reset",    "Reset compile server caches")
  BooleanSetting("-shutdown", "Shutdown compile server")
  StringSetting ("-server",   "hostname:portnumber", "Specify compile server socket", "")
  BooleanSetting("-J<flag>",  "Pass <flag> directly to runtime system")
}
