/* NSC -- new Scala compiler
 * Copyright 2005-2010 LAMP/EPFL
 * @author  Martin Odersky
 */
// $Id: FatalError.scala 21367 2010-04-07 13:59:44Z cunei $

package scala.tools.nsc

import scala.util.control.ControlThrowable

case class FatalError(msg: String) extends Throwable(msg)

class MissingRequirementError(val req: String) extends FatalError(req + " not found.")

object MissingRequirementError {
  def unapply(x: Throwable) = x match {
    case x: MissingRequirementError => Some(x.req)
    case _                          => None
  }
}
