/* NSC -- new Scala compiler
 * Copyright 2005-2010 LAMP/EPFL
 * @author  Martin Odersky
 */
// $Id: Set.scala 20154 2009-12-16 16:07:30Z cunei $

package scala.tools.nsc
package util

/** A common class for lightweight sets.
 */
abstract class Set[T <: AnyRef] {

  def findEntry(x: T): T

  def addEntry(x: T): Unit

  def iterator: Iterator[T]	
  
  @deprecated("use `iterator' instead") def elements = iterator

  def contains(x: T): Boolean =
    findEntry(x) ne null

  def toList = iterator.toList

}
