/* SBaz -- Scala Bazaar
 * Copyright 2005-2010 LAMP/EPFL
 * @author  Lex Spoon
 */

// $Id: Compact.scala 20150 2009-12-16 16:05:58Z cunei $

package sbaz.clui.commands

import sbaz.clui._

object Compact extends Command {
  val name = "compact"
  val oneLineHelp = "clear the download cache to save space"
  val fullHelp: String = (
    "compact\n" +
    "\n" +
    "Compact the managed directory.  Removes all cached downloads.\n")



  def run(args: List[String], settings: Settings) = {
    import settings._
    
    if (!dryrun) {
      dir.compact
    }
  }
}
