/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2010, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |    http://scala-lang.org/               **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: IsolationLevel.scala 20154 2009-12-16 16:07:30Z cunei $


package scala.dbc
package statement


abstract class IsolationLevel {
  def sqlString: String
}

object IsolationLevel {
  case object ReadUncommitted extends IsolationLevel {
    def sqlString = "ISOLATION LEVEL READ UNCOMMITTED"
  }
  case object ReadCommitted extends IsolationLevel {
    def sqlString = "ISOLATION LEVEL READ COMMITTED"
  }
  case object RepeatableRead extends IsolationLevel {
    def sqlString = "ISOLATION LEVEL REPEATABLE READ"
  }
  case object Serializable extends IsolationLevel {
    def sqlString = "ISOLATION LEVEL SERIALIZABLE"
  }
}
