/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.net.URI;
import java.net.URL;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.tools.nsc.io.Directory;
import scala.tools.nsc.io.File;
import scala.tools.nsc.io.File$;
import scala.tools.nsc.io.FileOperationException;
import scala.tools.nsc.io.Path$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements ScalaObject {
    private final String separatorStr;
    private final char separator;
    private final java.io.File jfile;

    public static final Nothing$ fail(String string) {
        return Path$.MODULE$.fail(string);
    }

    public static final String randomPrefix() {
        return Path$.MODULE$.randomPrefix();
    }

    public static final Path apply(java.io.File file) {
        return Path$.MODULE$.apply(file);
    }

    public static final Path apply(String string) {
        return Path$.MODULE$.apply(string);
    }

    public static final List<Path> roots() {
        return Path$.MODULE$.roots();
    }

    public static final Path jfile2path(java.io.File file) {
        return Path$.MODULE$.jfile2path(file);
    }

    public static final Path string2path(String string) {
        return Path$.MODULE$.string2path(string);
    }

    public Path(java.io.File jfile) {
        this.jfile = jfile;
        this.separator = java.io.File.separatorChar;
        this.separatorStr = java.io.File.separator;
    }

    private final /* synthetic */ boolean gd3$1() {
        return this.isAbsolute();
    }

    private final /* synthetic */ boolean gd2$1() {
        return this.path().endsWith("..");
    }

    private final String createRelativePath$1(List baseSegs, List otherSegs) {
        List os;
        List bs;
        block4: {
            while (baseSegs instanceof .colon.colon) {
                .colon.colon temp1 = (.colon.colon)baseSegs;
                String temp2 = (String)temp1.hd$1();
                List temp3 = temp1.tl$1();
                if (otherSegs instanceof .colon.colon) {
                    List temp6;
                    .colon.colon temp4 = (.colon.colon)otherSegs;
                    String temp5 = (String)temp4.hd$1();
                    if (this.gd1$1(temp2, temp3, temp5, temp6 = temp4.tl$1())) {
                        otherSegs = temp6;
                        baseSegs = temp3;
                        continue;
                    }
                    bs = temp1;
                    os = temp4;
                } else {
                    os = otherSegs;
                    bs = temp1;
                }
                break block4;
            }
            os = otherSegs;
            bs = baseSegs;
        }
        char c = this.separator();
        String string = new StringBuilder().append((Object)"..").append((Object)BoxesRunTime.boxToCharacter((char)c)).toString();
        return new StringBuilder().append((Object)new StringOps(string).$times(bs.length())).append((Object)os.mkString(this.separatorStr())).toString();
    }

    private final /* synthetic */ boolean gd1$1(String string, List list2, String string2, List list3) {
        String string3 = string;
        return !(string3 != null ? !string3.equals(string2) : string2 != null);
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    public boolean equals(Object other) {
        boolean bl;
        if (other instanceof Path) {
            Path temp14 = (Path)other;
            String string = this.path();
            String string2 = temp14.path();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return Predef$.MODULE$.augmentString("Path(%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()}));
    }

    public boolean deleteIfExists() {
        return this.jfile().exists() ? this.delete() : false;
    }

    public boolean delete() {
        return this.jfile().delete();
    }

    public File createFile(boolean failIfExists) {
        File file;
        boolean res = this.jfile().createNewFile();
        if (!res && failIfExists && this.exists()) {
            String string = "File '%s' already exists.";
            String string2 = new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()}));
            throw new FileOperationException(string2);
        }
        if (this.isFile()) {
            file = this.toFile();
        } else {
            java.io.File x$8 = this.jfile();
            Codec x$9 = null;
            file = new File(x$8, x$9);
        }
        return file;
    }

    public Directory createDirectory(boolean force, boolean failIfExists) {
        boolean res;
        boolean bl = res = force ? this.jfile().mkdirs() : this.jfile().mkdir();
        if (!res && failIfExists && this.exists()) {
            String string = "Directory '%s' already exists.";
            String string2 = new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()}));
            throw new FileOperationException(string2);
        }
        return this.isDirectory() ? this.toDirectory() : new Directory(this.jfile());
    }

    public boolean isFresher(Path other) {
        return this.lastModified() > other.lastModified();
    }

    public boolean isSame(Path other) {
        Path path = this.normalize();
        Path path2 = other.normalize();
        return !(path != null ? !((Object)path).equals(path2) : path2 != null);
    }

    public boolean startsWith(Path other) {
        return this.segments().startsWith(other.segments());
    }

    public boolean endsWith(Path other) {
        return this.segments().endsWith(other.segments());
    }

    public long length() {
        return this.jfile().length();
    }

    public boolean lastModified_$eq(long time) {
        return this.jfile().setLastModified(time);
    }

    public long lastModified() {
        return this.jfile().lastModified();
    }

    public boolean isEmpty() {
        return this.path().length() == 0;
    }

    public boolean isSymlink() {
        String string = this.name();
        Path$ path$ = Path$.MODULE$;
        Path x2 = this.parent().$div(path$.apply(new java.io.File(string)));
        Path path = x2.normalize();
        Path path2 = x2.toAbsolute();
        return path != null ? !((Object)path).equals(path2) : path2 != null;
    }

    public boolean isHidden() {
        return this.jfile().isHidden();
    }

    public boolean isAbsolute() {
        return this.jfile().isAbsolute();
    }

    public boolean isDirectory() {
        return this.jfile().isDirectory();
    }

    public boolean isFile() {
        return this.jfile().isFile();
    }

    /*
     * WARNING - void declaration
     */
    public boolean notExists() {
        void var1_1;
        boolean exceptionResult1;
        try {
            exceptionResult1 = !this.jfile().exists();
        }
        catch (SecurityException securityException) {
            exceptionResult1 = false;
        }
        return (boolean)var1_1;
    }

    public boolean exists() {
        return this.jfile().exists();
    }

    public boolean canWrite() {
        return this.jfile().canWrite();
    }

    public boolean canRead() {
        return this.jfile().canRead();
    }

    public String extension() {
        String string;
        int temp12 = this.name().lastIndexOf(46);
        if (temp12 == -1) {
            string = "";
        } else {
            String string2 = this.name();
            string = (String)new StringOps(string2).drop(temp12 + 1);
        }
        return string;
    }

    public List<Path> parents() {
        Path p = this.parent();
        return p.isSame(this) ? Nil$.MODULE$ : p.parents().$colon$colon((Object)p);
    }

    public Path parent() {
        String string;
        String temp9;
        String string2 = temp9 = this.path();
        String string3 = "";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            string = "..";
        } else {
            String string4 = temp9;
            String string5 = ".";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                string = "..";
            } else if (this.gd2$1()) {
                char c = this.separator();
                string = new StringBuilder().append((Object)this.path()).append((Object)BoxesRunTime.boxToCharacter((char)c)).append((Object)"..").toString();
            } else {
                String temp7 = this.jfile().getParent();
                string = temp7 == null ? (this.gd3$1() ? this.path() : ".") : temp7;
            }
        }
        String p = string;
        return new Directory(new java.io.File(p));
    }

    public List<String> segments() {
        return (List)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString(this.path()).split(this.separator())).toList().filterNot((Function1)new $anonfun$segments$1(this));
    }

    public Option<Path> root() {
        return Path$.MODULE$.roots().find((Function1)new $anonfun$root$1(this));
    }

    public Path relativize(Path other$1) {
        new $anonfun$relativize$1(this, other$1);
        boolean bl = this.isAbsolute() == other$1.isAbsolute();
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringBuilder().append((Object)"Paths not of same type: ").append((Object)this).append((Object)", ").append((Object)other$1).toString()).toString());
        }
        String string = this.createRelativePath$1(this.segments(), other$1.segments());
        Path$ path$ = Path$.MODULE$;
        return path$.apply(new java.io.File(string));
    }

    public Path resolve(Path other) {
        return other.isAbsolute() || this.isEmpty() ? other : this.$div(other);
    }

    public Path normalize() {
        return Path$.MODULE$.apply(this.jfile().getCanonicalPath());
    }

    public String path() {
        return this.jfile().getPath();
    }

    public String name() {
        return this.jfile().getName();
    }

    public File $div(File child) {
        return this.$div((Path)child).toFile();
    }

    public Directory $div(Directory child) {
        return this.$div((Path)child).toDirectory();
    }

    public Path $div(Path child) {
        return this.isEmpty() ? child : new Path(new java.io.File(this.jfile(), child.path()));
    }

    public URL toURL() {
        return this.toURI().toURL();
    }

    public URI toURI() {
        return this.jfile().toURI();
    }

    public Path toAbsolute() {
        Path path;
        if (this.isAbsolute()) {
            path = this;
        } else {
            String string = this.jfile().getAbsolutePath();
            Path$ path$ = Path$.MODULE$;
            path = path$.apply(new java.io.File(string));
        }
        return path;
    }

    public Directory toDirectory() {
        return new Directory(this.jfile());
    }

    public File toFile() {
        java.io.File x$6 = this.jfile();
        Codec x$7 = File$.MODULE$.init$default$2(x$6);
        return new File(x$6, x$7);
    }

    public boolean isValid() {
        return true;
    }

    public String separatorStr() {
        return this.separatorStr;
    }

    public char separator() {
        return this.separator;
    }

    public java.io.File jfile() {
        return this.jfile;
    }

    public /* synthetic */ boolean createDirectory$default$1() {
        return true;
    }

    public /* synthetic */ boolean createDirectory$default$2() {
        return false;
    }

    public /* synthetic */ boolean createFile$default$1() {
        return false;
    }
}

