/* NSC -- new Scala compiler
 * Copyright 2006-2010 LAMP/EPFL
 * @author  Martin Odersky
 */
// $Id: ConsoleWriter.scala 20154 2009-12-16 16:07:30Z cunei $

package scala.tools.nsc

import java.io.Writer

/** A Writer that writes onto the Scala Console.
 *
 *  @author  Lex Spoon
 *  @version 1.0
 */
class ConsoleWriter extends Writer {
  def close = flush
  
  def flush = Console.flush
  
  def write(cbuf: Array[Char], off: Int, len: Int) {
    if (len > 0)
      write(new String(cbuf.slice(off, off+len)))
  }

  override def write(str: String) { Console.print(str) }
}
