/*
 * Decompiled with CFR 0.152.
 */
package scala.io;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$class;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.compat.Platform$;
import scala.io.Codec;
import scala.io.Position$;
import scala.io.Source$;
import scala.io.Source$LineIterator$;
import scala.io.Source$NoPositioner$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Source
implements Iterator<Character>,
ScalaObject {
    private /* synthetic */ Source$NoPositioner$ NoPositioner$module;
    private Positioner positioner;
    private Function0<Object> closeFunction;
    private Function0<Source> resetFunction;
    private int nwarnings;
    private int nerrors;
    private String descr;

    public static final Codec fromURL$default$2(URL uRL) {
        return Source$.MODULE$.fromURL$default$2(uRL);
    }

    public static final Codec fromURI$default$2(URI uRI) {
        return Source$.MODULE$.fromURI$default$2(uRI);
    }

    public static final Codec fromFile$default$3(File file, int n) {
        return Source$.MODULE$.fromFile$default$3(file, n);
    }

    public static final int fromFile$default$2() {
        return Source$.MODULE$.fromFile$default$2();
    }

    public static final Codec fromPath$default$2(String string2) {
        return Source$.MODULE$.fromPath$default$2(string2);
    }

    public static final Codec fromBytes$default$2(byte[] byArray) {
        return Source$.MODULE$.fromBytes$default$2(byArray);
    }

    public static final Codec fromInputStream$default$5(InputStream inputStream, int n, Function0 function0, Function0 function02) {
        return Source$.MODULE$.fromInputStream$default$5(inputStream, n, function0, function02);
    }

    public static final Function0 fromInputStream$default$4() {
        return Source$.MODULE$.fromInputStream$default$4();
    }

    public static final Function0 fromInputStream$default$3() {
        return Source$.MODULE$.fromInputStream$default$3();
    }

    public static final int fromInputStream$default$2() {
        return Source$.MODULE$.fromInputStream$default$2();
    }

    public static final Source fromInputStream(InputStream inputStream, int n, Function0<Source> function0, Function0<Object> function02, Codec codec) {
        return Source$.MODULE$.fromInputStream(inputStream, n, function0, function02, codec);
    }

    public static final Source fromFile(File file, int n, Codec codec) {
        return Source$.MODULE$.fromFile(file, n, codec);
    }

    public static final Source fromURL(URL uRL, Codec codec) {
        return Source$.MODULE$.fromURL(uRL, codec);
    }

    public static final Source fromURI(URI uRI, Codec codec) {
        return Source$.MODULE$.fromURI(uRI, codec);
    }

    public static final Source fromPath(String string2, Codec codec) {
        return Source$.MODULE$.fromPath(string2, codec);
    }

    public static final Source fromRawBytes(byte[] byArray) {
        return Source$.MODULE$.fromRawBytes(byArray);
    }

    public static final Source fromBytes(byte[] byArray, Codec codec) {
        return Source$.MODULE$.fromBytes(byArray, codec);
    }

    public static final Source fromString(String string2) {
        return Source$.MODULE$.fromString(string2);
    }

    public static final Source fromChars(char[] cArray) {
        return Source$.MODULE$.fromChars(cArray);
    }

    public static final Source fromChar(char c) {
        return Source$.MODULE$.fromChar(c);
    }

    public static final Source fromIterable(Iterable<Character> iterable) {
        return Source$.MODULE$.fromIterable(iterable);
    }

    public static final Source stdin() {
        return Source$.MODULE$.stdin();
    }

    public static final int DefaultBufSize() {
        return Source$.MODULE$.DefaultBufSize();
    }

    public Source() {
        Iterator$class.$init$(this);
        this.descr = "";
        this.nerrors = 0;
        this.nwarnings = 0;
        this.resetFunction = null;
        this.closeFunction = null;
        this.positioner = new Positioner();
    }

    public Source reset() {
        Function0<Source> function0 = this.resetFunction;
        if (function0 == null || function0.equals(null)) {
            throw new UnsupportedOperationException("Source's reset() method was not set.");
        }
        return this.resetFunction.apply();
    }

    public void close() {
        Function0<Object> function0 = this.closeFunction;
        if (function0 != null && !function0.equals(null)) {
            this.closeFunction.apply();
        }
    }

    public Source withPositioning(boolean on) {
        this.positioner = on ? new Positioner() : this.NoPositioner();
        return this;
    }

    public Source withDescription(String text2) {
        this.descr_$eq(text2);
        return this;
    }

    public Source withClose(Function0<Object> f) {
        this.closeFunction = f;
        return this;
    }

    public Source withReset(Function0<Source> f) {
        this.resetFunction = f;
        return this;
    }

    public void reportWarning(int pos, String msg, PrintStream out) {
        this.nwarnings_$eq(this.nwarnings() + 1);
        this.report(pos, new StringBuilder().append((Object)"warning! ").append((Object)msg).toString(), out);
    }

    public void report(int pos, String msg, PrintStream out) {
        int line = Position$.MODULE$.line(pos);
        int col = Position$.MODULE$.column(pos);
        out.println(Predef$.MODULE$.augmentString("%s:%d:%d: %s%s%s^").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{this.descr(), BoxesRunTime.boxToInteger(line), BoxesRunTime.boxToInteger(col), msg, this.getLine(line), this.spaces(col - 1)})));
    }

    private String spaces(int n) {
        return List$.MODULE$.fill(n, new $anonfun$spaces$1(this)).mkString();
    }

    public void reportError(int pos, String msg, PrintStream out) {
        this.nerrors_$eq(this.nerrors() + 1);
        this.report(pos, msg, out);
    }

    public int pos() {
        return this.positioner.pos();
    }

    public char ch() {
        return this.positioner.ch();
    }

    public final Source$NoPositioner$ NoPositioner() {
        if (this.NoPositioner$module == null) {
            this.NoPositioner$module = new Source$NoPositioner$(this);
        }
        return this.NoPositioner$module;
    }

    @Override
    public char next() {
        return this.positioner.next();
    }

    @Override
    public boolean hasNext() {
        return this.iter().hasNext();
    }

    public Iterator<String> getLines(String separator) {
        return new LineIterator(this, separator);
    }

    public String getLine(int line) {
        return this.getLines(this.getLines$default$1()).drop(line - 1).next();
    }

    public void nwarnings_$eq(int n) {
        this.nwarnings = n;
    }

    public int nwarnings() {
        return this.nwarnings;
    }

    public void nerrors_$eq(int n) {
        this.nerrors = n;
    }

    public int nerrors() {
        return this.nerrors;
    }

    public void descr_$eq(String string2) {
        this.descr = string2;
    }

    public String descr() {
        return this.descr;
    }

    public abstract Iterator<Character> iter();

    public /* synthetic */ String getLines$default$1() {
        return Platform$.MODULE$.EOL();
    }

    public /* synthetic */ PrintStream reportError$default$3() {
        return Console$.MODULE$.err();
    }

    public /* synthetic */ PrintStream reportWarning$default$3() {
        return Console$.MODULE$.out();
    }

    @Override
    public /* synthetic */ int sliding$default$2() {
        return Iterator$class.sliding$default$2(this);
    }

    public void readInto(Object xs) {
        Iterator$class.readInto(this, xs);
    }

    public void readInto(Object xs, int start) {
        Iterator$class.readInto(this, xs, start);
    }

    public void readInto(Object xs, int start, int sz) {
        Iterator$class.readInto(this, xs, start, sz);
    }

    @Override
    public Object counted() {
        return Iterator$class.counted(this);
    }

    @Override
    public Seq collect() {
        return Iterator$class.collect(this);
    }

    @Override
    public int findIndexOf(Function1 p) {
        return Iterator$class.findIndexOf(this, p);
    }

    @Override
    public Iterator append(Iterator that) {
        return Iterator$class.append(this, that);
    }

    @Override
    public String toString() {
        return Iterator$class.toString(this);
    }

    @Override
    public StringBuilder addString(StringBuilder buf) {
        return Iterator$class.addString(this, buf);
    }

    @Override
    public StringBuilder addString(StringBuilder buf, String sep) {
        return Iterator$class.addString(this, buf, sep);
    }

    @Override
    public StringBuilder addString(StringBuilder buf, String start, String sep, String end) {
        return Iterator$class.addString(this, buf, start, sep, end);
    }

    @Override
    public String mkString() {
        return Iterator$class.mkString(this);
    }

    @Override
    public String mkString(String sep) {
        return Iterator$class.mkString(this, sep);
    }

    @Override
    public String mkString(String start, String sep, String end) {
        return Iterator$class.mkString(this, start, sep, end);
    }

    @Override
    public boolean sameElements(Iterator that) {
        return Iterator$class.sameElements(this, that);
    }

    @Override
    public Seq toSeq() {
        return Iterator$class.toSeq(this);
    }

    @Override
    public Stream toStream() {
        return Iterator$class.toStream(this);
    }

    @Override
    public List toList() {
        return Iterator$class.toList(this);
    }

    @Override
    public void copyToBuffer(Buffer dest) {
        Iterator$class.copyToBuffer(this, dest);
    }

    public void copyToArray(Object xs) {
        Iterator$class.copyToArray(this, xs);
    }

    public void copyToArray(Object xs, int start) {
        Iterator$class.copyToArray(this, xs, start);
    }

    public void copyToArray(Object xs, int start, int len) {
        Iterator$class.copyToArray(this, xs, start, len);
    }

    @Override
    public Object patch(int from2, Iterator patchElems, int replaced) {
        return Iterator$class.patch(this, from2, patchElems, replaced);
    }

    @Override
    public Tuple2 duplicate() {
        return Iterator$class.duplicate(this);
    }

    @Override
    public int length() {
        return Iterator$class.length(this);
    }

    @Override
    public Iterator.GroupedIterator sliding(int size2, int step) {
        return Iterator$class.sliding(this, size2, step);
    }

    @Override
    public Iterator.GroupedIterator grouped(int size2) {
        return Iterator$class.grouped(this, size2);
    }

    @Override
    public Object buffered() {
        return Iterator$class.buffered(this);
    }

    @Override
    public Option reduceRightOption(Function2 op) {
        return Iterator$class.reduceRightOption(this, op);
    }

    @Override
    public Option reduceLeftOption(Function2 op) {
        return Iterator$class.reduceLeftOption(this, op);
    }

    @Override
    public Object reduceRight(Function2 op) {
        return Iterator$class.reduceRight(this, op);
    }

    @Override
    public Object reduceLeft(Function2 op) {
        return Iterator$class.reduceLeft(this, op);
    }

    @Override
    public Object $colon$bslash(Object z, Function2 op) {
        return Iterator$class.$colon$bslash(this, z, op);
    }

    @Override
    public Object $div$colon(Object z, Function2 op) {
        return Iterator$class.$div$colon(this, z, op);
    }

    @Override
    public Object foldRight(Object z, Function2 op) {
        return Iterator$class.foldRight(this, z, op);
    }

    @Override
    public Object foldLeft(Object z, Function2 op) {
        return Iterator$class.foldLeft(this, z, op);
    }

    @Override
    public int indexOf(Object elem2) {
        return Iterator$class.indexOf(this, elem2);
    }

    @Override
    public int indexWhere(Function1 p) {
        return Iterator$class.indexWhere(this, p);
    }

    @Override
    public Option find(Function1 p) {
        return Iterator$class.find(this, p);
    }

    @Override
    public boolean contains(Object elem2) {
        return Iterator$class.contains(this, elem2);
    }

    @Override
    public boolean exists(Function1 p) {
        return Iterator$class.exists(this, p);
    }

    @Override
    public boolean forall(Function1 p) {
        return Iterator$class.forall(this, p);
    }

    @Override
    public void foreach(Function1 f) {
        Iterator$class.foreach(this, f);
    }

    @Override
    public Object zipAll(Iterator that, Object thisElem, Object thatElem) {
        return Iterator$class.zipAll(this, that, thisElem, thatElem);
    }

    @Override
    public Object zipWithIndex() {
        return Iterator$class.zipWithIndex(this);
    }

    @Override
    public Object padTo(int len, Object elem2) {
        return Iterator$class.padTo(this, len, elem2);
    }

    @Override
    public Object zip(Iterator that) {
        return Iterator$class.zip(this, that);
    }

    @Override
    public Iterator dropWhile(Function1 p) {
        return Iterator$class.dropWhile(this, p);
    }

    @Override
    public Tuple2 partition(Function1 p) {
        return Iterator$class.partition(this, p);
    }

    @Override
    public Iterator takeWhile(Function1 p) {
        return Iterator$class.takeWhile(this, p);
    }

    @Override
    public Iterator partialMap(PartialFunction pf) {
        return Iterator$class.partialMap(this, pf);
    }

    @Override
    public Iterator filterNot(Function1 p) {
        return Iterator$class.filterNot(this, p);
    }

    @Override
    public Iterator.WithFilter withFilter(Function1 p) {
        return Iterator$class.withFilter(this, p);
    }

    @Override
    public Iterator filter(Function1 p) {
        return Iterator$class.filter(this, p);
    }

    @Override
    public Iterator flatMap(Function1 f) {
        return Iterator$class.flatMap(this, f);
    }

    @Override
    public Iterator $plus$plus(Function0 that) {
        return Iterator$class.$plus$plus(this, that);
    }

    @Override
    public Iterator map(Function1 f) {
        return Iterator$class.map(this, f);
    }

    @Override
    public Iterator slice(int from2, int until2) {
        return Iterator$class.slice(this, from2, until2);
    }

    @Override
    public Iterator drop(int n) {
        return Iterator$class.drop(this, n);
    }

    @Override
    public Iterator take(int n) {
        return Iterator$class.take(this, n);
    }

    public class Positioner
    implements ScalaObject {
        private int tabinc;
        private int ccol;
        private int cline;
        private int pos;
        private char ch;

        public Positioner() {
            if (Source.this == null) {
                throw new NullPointerException();
            }
            this.pos = 0;
            this.cline = 1;
            this.ccol = 1;
            this.tabinc = 4;
        }

        public /* synthetic */ Source scala$io$Source$Positioner$$$outer() {
            return Source.this;
        }

        public char next() {
            char temp1;
            block6: {
                this.ch_$eq(BoxesRunTime.unboxToChar(this.scala$io$Source$Positioner$$$outer().iter().next()));
                this.pos_$eq(Position$.MODULE$.encode(this.cline(), this.ccol()));
                temp1 = this.ch();
                switch (temp1) {
                    default: {
                        if (true) {
                            this.ccol_$eq(this.ccol() + 1);
                            break;
                        }
                        throw new MatchError(((Object)BoxesRunTime.boxToCharacter(temp1)).toString());
                    }
                    case '\n': {
                        if (true) {
                            this.ccol_$eq(1);
                            this.cline_$eq(this.cline() + 1);
                            break;
                        }
                        throw new MatchError(((Object)BoxesRunTime.boxToCharacter(temp1)).toString());
                    }
                    case '\t': {
                        if (!true) break block6;
                        this.ccol_$eq(this.ccol() + this.tabinc());
                    }
                }
                return this.ch();
            }
            throw new MatchError(((Object)BoxesRunTime.boxToCharacter(temp1)).toString());
        }

        public void tabinc_$eq(int n) {
            this.tabinc = n;
        }

        public int tabinc() {
            return this.tabinc;
        }

        public void ccol_$eq(int n) {
            this.ccol = n;
        }

        public int ccol() {
            return this.ccol;
        }

        public void cline_$eq(int n) {
            this.cline = n;
        }

        public int cline() {
            return this.cline;
        }

        public void pos_$eq(int n) {
            this.pos = n;
        }

        public int pos() {
            return this.pos;
        }

        public void ch_$eq(char c) {
            this.ch = c;
        }

        public char ch() {
            return this.ch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LineIterator
    implements Iterator<String>,
    ScalaObject {
        public volatile int bitmap$0;
        public final /* synthetic */ Source $outer;
        private final StringBuilder sb;
        private final Function1<Character, Boolean> isNewline;
        private BufferedIterator<Character> iter;
        public final String scala$io$Source$LineIterator$$separator;

        public LineIterator(Source $outer, String separator) {
            this.scala$io$Source$LineIterator$$separator = separator;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Iterator$class.$init$(this);
            Predef$.MODULE$.require(separator.length() == 1 || separator.length() == 2, new LineIterator$$anonfun$2(this));
            char firstCh$1 = Predef$.MODULE$.augmentString(separator).apply(0);
            this.isNewline = separator.length() == 1 ? new LineIterator$$anonfun$3(this, firstCh$1) : new LineIterator$$anonfun$4(this, firstCh$1);
            this.sb = new StringBuilder();
        }

        public /* synthetic */ Source scala$io$Source$LineIterator$$$outer() {
            return this.$outer;
        }

        @Override
        public String next() {
            this.sb.clear();
            while (this.getc()) {
            }
            return this.sb.toString();
        }

        @Override
        public boolean hasNext() {
            return this.iter().hasNext();
        }

        private boolean getc() {
            boolean bl;
            if (this.iter().hasNext()) {
                char ch = BoxesRunTime.unboxToChar(this.iter().next());
                if (BoxesRunTime.unboxToBoolean(this.isNewline().apply(BoxesRunTime.boxToCharacter(ch)))) {
                    bl = false;
                } else {
                    this.sb.append(ch);
                    bl = true;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public Function1<Character, Boolean> isNewline() {
            return this.isNewline;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public BufferedIterator<Character> iter() {
            if ((this.bitmap$0 & 1) != 0) return this.iter;
            LineIterator lineIterator = this;
            synchronized (lineIterator) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.iter = (BufferedIterator)this.scala$io$Source$LineIterator$$$outer().iter().buffered();
                    this.bitmap$0 |= 1;
                }
                return this.iter;
            }
        }

        @Override
        public /* synthetic */ int sliding$default$2() {
            return Iterator$class.sliding$default$2(this);
        }

        public void readInto(Object xs) {
            Iterator$class.readInto(this, xs);
        }

        public void readInto(Object xs, int start) {
            Iterator$class.readInto(this, xs, start);
        }

        public void readInto(Object xs, int start, int sz) {
            Iterator$class.readInto(this, xs, start, sz);
        }

        @Override
        public Object counted() {
            return Iterator$class.counted(this);
        }

        @Override
        public Seq collect() {
            return Iterator$class.collect(this);
        }

        @Override
        public int findIndexOf(Function1 p) {
            return Iterator$class.findIndexOf(this, p);
        }

        @Override
        public Iterator append(Iterator that) {
            return Iterator$class.append(this, that);
        }

        @Override
        public String toString() {
            return Iterator$class.toString(this);
        }

        @Override
        public StringBuilder addString(StringBuilder buf) {
            return Iterator$class.addString(this, buf);
        }

        @Override
        public StringBuilder addString(StringBuilder buf, String sep) {
            return Iterator$class.addString(this, buf, sep);
        }

        @Override
        public StringBuilder addString(StringBuilder buf, String start, String sep, String end) {
            return Iterator$class.addString(this, buf, start, sep, end);
        }

        @Override
        public String mkString() {
            return Iterator$class.mkString(this);
        }

        @Override
        public String mkString(String sep) {
            return Iterator$class.mkString(this, sep);
        }

        @Override
        public String mkString(String start, String sep, String end) {
            return Iterator$class.mkString(this, start, sep, end);
        }

        @Override
        public boolean sameElements(Iterator that) {
            return Iterator$class.sameElements(this, that);
        }

        @Override
        public Seq toSeq() {
            return Iterator$class.toSeq(this);
        }

        @Override
        public Stream toStream() {
            return Iterator$class.toStream(this);
        }

        @Override
        public List toList() {
            return Iterator$class.toList(this);
        }

        @Override
        public void copyToBuffer(Buffer dest) {
            Iterator$class.copyToBuffer(this, dest);
        }

        public void copyToArray(Object xs) {
            Iterator$class.copyToArray(this, xs);
        }

        public void copyToArray(Object xs, int start) {
            Iterator$class.copyToArray(this, xs, start);
        }

        public void copyToArray(Object xs, int start, int len) {
            Iterator$class.copyToArray(this, xs, start, len);
        }

        @Override
        public Object patch(int from2, Iterator patchElems, int replaced) {
            return Iterator$class.patch(this, from2, patchElems, replaced);
        }

        @Override
        public Tuple2 duplicate() {
            return Iterator$class.duplicate(this);
        }

        @Override
        public int length() {
            return Iterator$class.length(this);
        }

        @Override
        public Iterator.GroupedIterator sliding(int size2, int step) {
            return Iterator$class.sliding(this, size2, step);
        }

        @Override
        public Iterator.GroupedIterator grouped(int size2) {
            return Iterator$class.grouped(this, size2);
        }

        @Override
        public Object buffered() {
            return Iterator$class.buffered(this);
        }

        @Override
        public Option reduceRightOption(Function2 op) {
            return Iterator$class.reduceRightOption(this, op);
        }

        @Override
        public Option reduceLeftOption(Function2 op) {
            return Iterator$class.reduceLeftOption(this, op);
        }

        @Override
        public Object reduceRight(Function2 op) {
            return Iterator$class.reduceRight(this, op);
        }

        @Override
        public Object reduceLeft(Function2 op) {
            return Iterator$class.reduceLeft(this, op);
        }

        @Override
        public Object $colon$bslash(Object z, Function2 op) {
            return Iterator$class.$colon$bslash(this, z, op);
        }

        @Override
        public Object $div$colon(Object z, Function2 op) {
            return Iterator$class.$div$colon(this, z, op);
        }

        @Override
        public Object foldRight(Object z, Function2 op) {
            return Iterator$class.foldRight(this, z, op);
        }

        @Override
        public Object foldLeft(Object z, Function2 op) {
            return Iterator$class.foldLeft(this, z, op);
        }

        @Override
        public int indexOf(Object elem2) {
            return Iterator$class.indexOf(this, elem2);
        }

        @Override
        public int indexWhere(Function1 p) {
            return Iterator$class.indexWhere(this, p);
        }

        @Override
        public Option find(Function1 p) {
            return Iterator$class.find(this, p);
        }

        @Override
        public boolean contains(Object elem2) {
            return Iterator$class.contains(this, elem2);
        }

        @Override
        public boolean exists(Function1 p) {
            return Iterator$class.exists(this, p);
        }

        @Override
        public boolean forall(Function1 p) {
            return Iterator$class.forall(this, p);
        }

        @Override
        public void foreach(Function1 f) {
            Iterator$class.foreach(this, f);
        }

        @Override
        public Object zipAll(Iterator that, Object thisElem, Object thatElem) {
            return Iterator$class.zipAll(this, that, thisElem, thatElem);
        }

        @Override
        public Object zipWithIndex() {
            return Iterator$class.zipWithIndex(this);
        }

        @Override
        public Object padTo(int len, Object elem2) {
            return Iterator$class.padTo(this, len, elem2);
        }

        @Override
        public Object zip(Iterator that) {
            return Iterator$class.zip(this, that);
        }

        @Override
        public Iterator dropWhile(Function1 p) {
            return Iterator$class.dropWhile(this, p);
        }

        @Override
        public Tuple2 partition(Function1 p) {
            return Iterator$class.partition(this, p);
        }

        @Override
        public Iterator takeWhile(Function1 p) {
            return Iterator$class.takeWhile(this, p);
        }

        @Override
        public Iterator partialMap(PartialFunction pf) {
            return Iterator$class.partialMap(this, pf);
        }

        @Override
        public Iterator filterNot(Function1 p) {
            return Iterator$class.filterNot(this, p);
        }

        @Override
        public Iterator.WithFilter withFilter(Function1 p) {
            return Iterator$class.withFilter(this, p);
        }

        @Override
        public Iterator filter(Function1 p) {
            return Iterator$class.filter(this, p);
        }

        @Override
        public Iterator flatMap(Function1 f) {
            return Iterator$class.flatMap(this, f);
        }

        @Override
        public Iterator $plus$plus(Function0 that) {
            return Iterator$class.$plus$plus(this, that);
        }

        @Override
        public Iterator map(Function1 f) {
            return Iterator$class.map(this, f);
        }

        @Override
        public Iterator slice(int from2, int until2) {
            return Iterator$class.slice(this, from2, until2);
        }

        @Override
        public Iterator drop(int n) {
            return Iterator$class.drop(this, n);
        }

        @Override
        public Iterator take(int n) {
            return Iterator$class.take(this, n);
        }
    }
}

