/*
 * Decompiled with CFR 0.152.
 */
package sbaz.clui.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sbaz.AvailablePackage;
import sbaz.FileUtils$;
import sbaz.Package;
import sbaz.PackageUtil$;
import sbaz.Version;
import sbaz.VersionUtil$;
import sbaz.clui.Command;
import sbaz.clui.Settings;
import sbaz.clui.commands.Pack;
import sbaz.clui.commands.Pack$;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pack$
extends Command
implements ScalaObject {
    public static final Pack$ MODULE$;
    private final String fullHelp;
    private final String oneLineHelp;
    private final String name;

    static {
        new Pack$();
    }

    private Pack$() {
        MODULE$ = this;
        this.name = "pack";
        this.oneLineHelp = "create an sbaz package";
        this.fullHelp = "pack name directory [options]\n\nOptions (defaults):\n  --version version (0.0)\n  --description description (no description)\n  --descfile description-file (no description)\n  --depends dependencies seperated by a comma (none)\n  --outdir directory (current directory)\n  --linkbase url (none)\n  --pack200\n\nCreate an sbaz package and, if a link base is specified, an\nadvertisement file.  The package file is named name-version.sbp.\nThe advertisement file is named name-version.advert.  The URL\nin the advertisement file is the URL base with the package\nfilename appended. If the pack200 flag is given, all jar files\nwill have the pack200 encoding applied.";
    }

    public final void lp$1(File file, String path$1, Function2 function2) {
        function2.apply((Object)file, (Object)path$1);
        if (file.isDirectory()) {
            Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).toList().foreach((Function1)new anonfun.lp.1.1(function2, path$1));
        }
    }

    @Override
    public void run(List<String> args, Settings sbazSettings) {
        Option<String> temp37;
        block9: {
            block10: {
                Option<String> temp41;
                block14: {
                    block15: {
                        Pack.Settings packSettings;
                        block13: {
                            block11: {
                                block12: {
                                    String temp43;
                                    block8: {
                                        block6: {
                                            block7: {
                                                String temp39;
                                                packSettings = this.parseArguments(args);
                                                temp37 = PackageUtil$.MODULE$.checkName(packSettings.name());
                                                if (!(temp37 instanceof Some)) break block6;
                                                Some temp38 = (Some)temp37;
                                                String problem = temp39 = (String)temp38.x();
                                                if (!true) break block7;
                                                problem = temp39;
                                                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Warning: ").append((Object)problem).toString());
                                                break block8;
                                            }
                                            throw new MatchError(temp37.toString());
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option<String> option = temp37;
                                        if (none$ != null ? !none$.equals(option) : option != null) break block9;
                                        if (!true) break block10;
                                    }
                                    temp41 = VersionUtil$.MODULE$.check(packSettings.version().toString());
                                    if (!(temp41 instanceof Some)) break block11;
                                    Some temp42 = (Some)temp41;
                                    String problem = temp43 = (String)temp42.x();
                                    if (!true) break block12;
                                    problem = temp43;
                                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Warning: ").append((Object)problem).toString());
                                    break block13;
                                }
                                throw new MatchError(temp41.toString());
                            }
                            None$ none$ = None$.MODULE$;
                            Option<String> option = temp41;
                            if (none$ != null ? !none$.equals(option) : option != null) break block14;
                            if (!true) break block15;
                        }
                        try {
                            this.writeSBP(sbazSettings, packSettings);
                            if (!packSettings.linkBase().isEmpty()) {
                                this.writeAdvert(sbazSettings, packSettings);
                            }
                            return;
                        }
                        catch (IOException iOException) {
                            Predef$.MODULE$.println((Object)iOException);
                            throw Predef$.MODULE$.exit(2);
                        }
                    }
                    throw new MatchError(temp41.toString());
                }
                throw new MatchError(temp41.toString());
            }
            throw new MatchError(temp37.toString());
        }
        throw new MatchError(temp37.toString());
    }

    public void writeAdvert(Settings sbazSettings, Pack.Settings packSettings) {
        String link = new StringBuilder().append((Object)((String)packSettings.linkBase().get())).append((Object)packSettings.name()).append((Object)"-").append((Object)packSettings.version()).append((Object)".sbp").toString();
        File advertFile = new File(new StringBuilder().append((Object)packSettings.name()).append((Object)"-").append((Object)packSettings.version()).append((Object)".advert").toString());
        if (sbazSettings.verbose()) {
            Console$.MODULE$.println((Object)new StringBuilder().append((Object)"writing ").append((Object)advertFile).append((Object)"...").toString());
        }
        AvailablePackage advert = new AvailablePackage(this.packageFor(packSettings), new URL(link));
        FileWriter out = new FileWriter(advertFile);
        out.write(advert.toXML().toString());
        out.close();
    }

    public void writeSBP(Settings sbazSettings$1, Pack.Settings packSettings$1) {
        String sbpName = new StringBuilder().append((Object)packSettings$1.name()).append((Object)"-").append((Object)packSettings$1.version()).append((Object)".sbp").toString();
        File sbpFile = new File(packSettings$1.outdir(), sbpName);
        if (sbazSettings$1.verbose()) {
            Console$.MODULE$.println((Object)new StringBuilder().append((Object)"Writing ").append((Object)sbpFile).append((Object)"...").toString());
        }
        ZipOutputStream zip$1 = new ZipOutputStream(new FileOutputStream(sbpFile));
        this.withDirTree(packSettings$1.packdir(), new anonfun.writeSBP.1(sbazSettings$1, packSettings$1, zip$1));
        if (sbazSettings$1.verbose()) {
            Predef$.MODULE$.println((Object)"Writing meta/description");
        }
        zip$1.putNextEntry(new ZipEntry("meta/description"));
        zip$1.write(this.packageFor(packSettings$1).toXML().toString().getBytes());
        zip$1.closeEntry();
        zip$1.close();
        if (sbazSettings$1.verbose()) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Finished with ").append((Object)sbpFile).append((Object)".").toString());
        }
    }

    public Package packageFor(Pack.Settings settings) {
        return new Package(settings.name(), settings.version(), (Set<String>)((Set)ListSet$.MODULE$.empty().$plus$plus(settings.depends())), settings.description());
    }

    public void withDirTree(File root, Function2<File, String, Object> handler$1) {
        this.lp$1(root, "", handler$1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pack.Settings parseArguments(List<String> args) {
        List argsLeft = args;
        ObjectRef nameArg$1 = new ObjectRef(null);
        ObjectRef packdirArg$1 = new ObjectRef(null);
        ObjectRef outdirArg$1 = new ObjectRef(null);
        ObjectRef linkBaseArg$1 = new ObjectRef((Object)None$.MODULE$);
        ObjectRef versionArg$1 = new ObjectRef((Object)new Version("0.0"));
        ObjectRef descriptionArg$1 = new ObjectRef((Object)"(no description)");
        ObjectRef dependsArg$1 = new ObjectRef((Object)Nil$.MODULE$);
        BooleanRef applyPack200Arg$1 = new BooleanRef(false);
        List temp1 = args;
        if (!(temp1 instanceof .colon.colon)) throw this.usageExit();
        .colon.colon temp2 = (.colon.colon)temp1;
        String temp3 = (String)temp2.hd$1();
        List temp4 = temp2.tl$1();
        if (!(temp4 instanceof .colon.colon)) throw this.usageExit();
        .colon.colon temp5 = (.colon.colon)temp4;
        String temp6 = (String)temp5.hd$1();
        List temp7 = temp5.tl$1();
        String name0 = temp3;
        List rest = temp7;
        String packdir0 = temp6;
        name0 = temp3;
        packdir0 = temp6;
        rest = temp7;
        nameArg$1.elem = name0;
        packdirArg$1.elem = new File(packdir0);
        argsLeft = rest;
        while (true) {
            List list = argsLeft;
            Nil$ nil$ = Nil$.MODULE$;
            if (list == null) {
                if (nil$ == null) return new anon.1(nameArg$1, packdirArg$1, outdirArg$1, linkBaseArg$1, versionArg$1, descriptionArg$1, dependsArg$1, applyPack200Arg$1);
            } else if (list.equals(nil$)) {
                return new anon.1(nameArg$1, packdirArg$1, outdirArg$1, linkBaseArg$1, versionArg$1, descriptionArg$1, dependsArg$1, applyPack200Arg$1);
            }
            List temp8 = argsLeft;
            if (!(temp8 instanceof .colon.colon)) throw this.usageExit();
            .colon.colon temp9 = (.colon.colon)temp8;
            String temp10 = (String)temp9.hd$1();
            List temp11 = temp9.tl$1();
            String string = temp10;
            String string2 = "--version";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                List temp15;
                if (!(temp11 instanceof .colon.colon)) throw this.usageExit();
                .colon.colon temp13 = (.colon.colon)temp11;
                String temp14 = (String)temp13.hd$1();
                List rest2 = temp15 = temp13.tl$1();
                String ver = temp14;
                ver = temp14;
                List rest3 = temp15;
                versionArg$1.elem = new Version(ver);
                argsLeft = rest3;
                continue;
            }
            String string3 = temp10;
            String string4 = "--description";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                List temp19;
                if (!(temp11 instanceof .colon.colon)) throw this.usageExit();
                .colon.colon temp17 = (.colon.colon)temp11;
                String temp18 = (String)temp17.hd$1();
                List rest3 = temp19 = temp17.tl$1();
                String desc = temp18;
                desc = temp18;
                List rest4 = temp19;
                descriptionArg$1.elem = desc;
                argsLeft = rest4;
                continue;
            }
            String string5 = temp10;
            String string6 = "--descfile";
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                List temp23;
                if (!(temp11 instanceof .colon.colon)) throw this.usageExit();
                .colon.colon temp21 = (.colon.colon)temp11;
                String temp22 = (String)temp21.hd$1();
                List rest4 = temp23 = temp21.tl$1();
                String df = temp22;
                df = temp22;
                List rest5 = temp23;
                BoxedUnit exceptionResult1 = null;
                try {
                    descriptionArg$1.elem = FileUtils$.MODULE$.readFile(df);
                    BoxedUnit str = exceptionResult1 = BoxedUnit.UNIT;
                    argsLeft = rest5;
                }
                catch (IOException iOException) {
                    Console$.MODULE$.println((Object)new StringBuilder().append((Object)"Error reading ").append((Object)df).append((Object)": ").append((Object)iOException).toString());
                    throw Predef$.MODULE$.exit(1);
                }
            }
            String string7 = temp10;
            String string8 = "--depends";
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                List temp27;
                if (!(temp11 instanceof .colon.colon)) throw this.usageExit();
                .colon.colon temp25 = (.colon.colon)temp11;
                String temp26 = (String)temp25.hd$1();
                List rest5 = temp27 = temp25.tl$1();
                String dep = temp26;
                dep = temp26;
                List rest6 = temp27;
                dependsArg$1.elem = Predef$.MODULE$.refArrayOps((Object[])dep.split(",")).toList();
                argsLeft = rest6;
                continue;
            }
            String string9 = temp10;
            String string10 = "--outdir";
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                List temp31;
                if (!(temp11 instanceof .colon.colon)) throw this.usageExit();
                .colon.colon temp29 = (.colon.colon)temp11;
                String temp30 = (String)temp29.hd$1();
                List rest6 = temp31 = temp29.tl$1();
                String outd = temp30;
                outd = temp30;
                List rest7 = temp31;
                outdirArg$1.elem = new File(outd);
                argsLeft = rest7;
                continue;
            }
            String string11 = temp10;
            String string12 = "--linkbase";
            if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                List temp35;
                if (!(temp11 instanceof .colon.colon)) throw this.usageExit();
                .colon.colon temp33 = (.colon.colon)temp11;
                String temp34 = (String)temp33.hd$1();
                List rest7 = temp35 = temp33.tl$1();
                String lb = temp34;
                lb = temp34;
                List rest8 = temp35;
                linkBaseArg$1.elem = new Some((Object)lb);
                argsLeft = rest8;
                continue;
            }
            String string13 = temp10;
            String string14 = "--pack200";
            if (string13 == null) {
                if (string14 != null) {
                    throw this.usageExit();
                }
            } else if (!string13.equals(string14)) throw this.usageExit();
            List rest8 = temp11;
            List rest9 = temp11;
            applyPack200Arg$1.elem = true;
            argsLeft = rest9;
        }
    }

    @Override
    public String fullHelp() {
        return this.fullHelp;
    }

    @Override
    public String oneLineHelp() {
        return this.oneLineHelp;
    }

    @Override
    public String name() {
        return this.name;
    }
}

