/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import sbaz.AvailableList;
import sbaz.AvailablePackage;
import sbaz.Message;
import sbaz.PackageSpec;
import sbaz.ServletRequestHandler$;
import sbaz.SimpleUniverse;
import sbaz.Universe;
import sbaz.keys.Key;
import sbaz.keys.KeyRing;
import sbaz.keys.KeyUtil$;
import sbaz.keys.MessagePattern;
import sbaz.messages.AddPackage;
import sbaz.messages.KeyCreate;
import sbaz.messages.KeyCreated;
import sbaz.messages.KeyList;
import sbaz.messages.KeyRevoke;
import sbaz.messages.LatestPackages;
import sbaz.messages.NotOK;
import sbaz.messages.OK;
import sbaz.messages.RemovePackage;
import sbaz.messages.SendKeyList$;
import sbaz.messages.SendPackageList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.ScalaObject;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRequestHandler
implements ScalaObject {
    private final List<MessagePattern> keylessRequests;
    private final KeyRing keyring;
    private AvailableList packages;
    private final SimpleUniverse universe;
    private final File directory;

    public static final ServletRequestHandler handlerFor(String string) {
        return ServletRequestHandler$.MODULE$.handlerFor(string);
    }

    public static final ServletRequestHandler handlerFor(File file) {
        return ServletRequestHandler$.MODULE$.handlerFor(file);
    }

    public ServletRequestHandler(File directory) {
        this.directory = directory;
        Universe temp1 = (Universe)this.loadXML("universe", new $anonfun$2(this), new $anonfun$1(this));
        if (temp1 instanceof SimpleUniverse) {
            SimpleUniverse temp2;
            SimpleUniverse univ = temp2 = (SimpleUniverse)temp1;
            if (true) {
                this.universe = univ = temp2;
                this.packages = (AvailableList)this.loadXML("packages", new $anonfun$4(this), new $anonfun$3(this));
                this.keyring = (KeyRing)this.loadXML("keyring", new $anonfun$6(this), new $anonfun$5(this));
                this.keylessRequests = (List)this.loadXML("keylessRequests", new $anonfun$8(this), new $anonfun$7(this));
                return;
            }
            throw new MatchError(temp1.toString());
        }
        if (true) {
            throw new Error("this universe is not a simple universe");
        }
        throw new MatchError(temp1.toString());
    }

    public final List fromXML$1(Node xml) {
        return (List)xml.child().toList().withFilter((Function1)new $anonfun$fromXML$1$1(this)).map((Function1)new $anonfun$fromXML$1$2(this), List$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message handleRequest(Message req0) {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            Message message;
            Message req$1 = req0.sansKeys();
            List keys = (List)req0.authKeys().filter((Function1)new $anonfun$9(this));
            if (this.keylessRequests().exists((Function1)new $anonfun$handleRequest$1(this, req$1)) || keys.exists((Function1)new $anonfun$handleRequest$2(this, req$1))) {
                Message temp3 = req$1;
                if (temp3 instanceof SendPackageList) {
                    if (!true) throw new MatchError(temp3.toString());
                    message = new LatestPackages(this.packages());
                } else if (temp3 instanceof AddPackage) {
                    AvailablePackage temp6;
                    AddPackage temp5 = (AddPackage)temp3;
                    AvailablePackage pack$1 = temp6 = temp5.pack();
                    if (!true) throw new MatchError(temp3.toString());
                    pack$1 = temp6;
                    List packsMinus = (List)this.packages().available().filter((Function1)new $anonfun$10(this, pack$1));
                    AvailablePackage availablePackage = pack$1;
                    List newPacks = packsMinus.$colon$colon((Object)availablePackage);
                    this.packages_$eq(new AvailableList((List<AvailablePackage>)newPacks));
                    this.savePackages();
                    message = new OK();
                } else if (temp3 instanceof RemovePackage) {
                    PackageSpec temp8;
                    RemovePackage temp7 = (RemovePackage)temp3;
                    PackageSpec spec$1 = temp8 = temp7.spec();
                    if (!true) throw new MatchError(temp3.toString());
                    spec$1 = temp8;
                    List packsMinus = (List)this.packages().available().filter((Function1)new $anonfun$11(this, spec$1));
                    this.packages_$eq(new AvailableList((List<AvailablePackage>)packsMinus));
                    this.savePackages();
                    message = new OK();
                } else if (temp3 instanceof KeyCreate) {
                    String temp11;
                    KeyCreate temp9 = (KeyCreate)temp3;
                    MessagePattern temp10 = temp9.messages();
                    String description = temp11 = temp9.description();
                    MessagePattern messages = temp10;
                    if (!true) throw new MatchError(temp3.toString());
                    messages = temp10;
                    description = temp11;
                    String data = KeyUtil$.MODULE$.genKeyData();
                    Key key = new Key(messages, description, data);
                    this.keyring().addKey(key);
                    this.saveKeyring();
                    message = new KeyCreated(key);
                } else if (temp3 instanceof KeyRevoke) {
                    Key temp13;
                    KeyRevoke temp12 = (KeyRevoke)temp3;
                    Key key = temp13 = temp12.key();
                    if (!true) throw new MatchError(temp3.toString());
                    key = temp13;
                    this.keyring().removeKey(key);
                    this.saveKeyring();
                    message = new OK();
                } else {
                    SendKeyList$ sendKeyList$ = SendKeyList$.MODULE$;
                    Message message2 = temp3;
                    if (!(sendKeyList$ != null ? !sendKeyList$.equals(message2) : message2 != null)) {
                        if (!true) throw new MatchError(temp3.toString());
                        message = new KeyList(this.keyring().keys());
                    } else {
                        if (!true) throw new MatchError(temp3.toString());
                        message = new NotOK(new StringBuilder().append((Object)"unhandled message type.  full message: ").append((Object)req$1).toString());
                    }
                }
            } else {
                message = new NotOK("Permission denied");
            }
            return message;
        }
    }

    public String responseForGET() {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            StringWriter out$1 = new StringWriter();
            out$1.write("This is a Scala Bazaar.  The bazaar descriptor is:\n");
            out$1.write(this.universe().toXML().toString());
            out$1.write("\n\n");
            out$1.write("The packages included are:\n");
            this.packages().sortedSpecs().foreach((Function1)new $anonfun$responseForGET$1(this, out$1));
            return out$1.toString();
        }
    }

    public List<MessagePattern> keylessRequests() {
        return this.keylessRequests;
    }

    public boolean saveKeyring() {
        return this.saveXML(this.keyring().toXML(), "keyring");
    }

    public KeyRing keyring() {
        return this.keyring;
    }

    public boolean savePackages() {
        return this.saveXML((Node)this.packages().toXML(), "packages");
    }

    public void packages_$eq(AvailableList availableList) {
        this.packages = availableList;
    }

    public AvailableList packages() {
        return this.packages;
    }

    public SimpleUniverse universe() {
        return this.universe;
    }

    private boolean saveXML(Node xml, String filename) {
        File tmpFile = new File(this.directory, new StringBuilder().append((Object)filename).append((Object)".tmp").toString());
        FileWriter str = new FileWriter(tmpFile);
        str.write(xml.toString());
        str.close();
        return this.renameFile(tmpFile, new File(this.directory, filename));
    }

    private boolean renameFile(File from, File to) {
        to.delete();
        return from.renameTo(to);
    }

    public <A> A loadXML(String baseName, Function1<Node, A> loader, Function0<A> ifmissing) {
        Object object;
        File file = new File(this.directory, baseName);
        if (file.exists()) {
            Elem xml = (Elem)XML$.MODULE$.load(file.getAbsolutePath());
            object = loader.apply((Object)xml);
        } else {
            object = ifmissing.apply();
        }
        return (A)object;
    }
}

