/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;

public final class FileUtils$
implements ScalaObject {
    public static final FileUtils$ MODULE$;

    static {
        new FileUtils$();
    }

    private FileUtils$() {
        MODULE$ = this;
    }

    private final void lp$3(MessageDigest messageDigest, FileInputStream fileInputStream, byte[] byArray) {
        int numread;
        while ((numread = fileInputStream.read(byArray)) >= 0) {
            messageDigest.update(byArray, 0, numread);
        }
    }

    private final void lp$2(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        int numread;
        while ((numread = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, numread);
        }
    }

    private final void lp$1(Reader reader, char[] cArray, StringBuilder stringBuilder) {
        int numread;
        while ((numread = reader.read(cArray)) >= 0) {
            stringBuilder.appendAll(cArray, 0, numread);
        }
    }

    public String md5(File file) {
        MessageDigest digester$1 = MessageDigest.getInstance("MD5");
        FileInputStream in$3 = new FileInputStream(file);
        byte[] buf$3 = new byte[1024];
        this.lp$3(digester$1, in$3, buf$3);
        in$3.close();
        String md5 = new BigInteger(1, digester$1.digest()).toString(16);
        return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("0").$times(32 - md5.length())).append((Object)md5).toString();
    }

    public void pack200(File in, File out) {
        Pack200.Packer packer = Pack200.newPacker();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));
        packer.pack(new JarFile(in), (OutputStream)os);
        os.close();
    }

    /*
     * WARNING - void declaration
     */
    public File pack200(File in) {
        void var2_2;
        File out = this.renameFile(in, ".jar", ".pack");
        this.pack200(in, out);
        return var2_2;
    }

    public void unpack200(File in, File out) {
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        JarOutputStream jout = new JarOutputStream(new FileOutputStream(out));
        unpacker.unpack(in, jout);
        jout.close();
    }

    public File renameFile(File file, String fromSuffix, String toSuffix) {
        String fromName = file.getName();
        String toName = this.rename(fromName, fromSuffix, toSuffix);
        return new File(file.getParent(), toName);
    }

    public String rename(String name, String fromSuffix, String toSuffix) {
        Predef$.MODULE$.require(name.endsWith(fromSuffix));
        String baseName = name.substring(0, name.lastIndexOf(fromSuffix));
        return new StringBuilder().append((Object)baseName).append((Object)toSuffix).toString();
    }

    public boolean isJar(String name) {
        return name.endsWith(".jar");
    }

    public boolean isPack200(String name) {
        return name.endsWith(".pack");
    }

    public void pipeStream(InputStream in$1, OutputStream out$1) {
        byte[] buf$2 = new byte[1024];
        this.lp$2(in$1, out$1, buf$2);
    }

    private String readReader(Reader in$2) {
        char[] buf$1 = new char[1024];
        StringBuilder sb$1 = new StringBuilder();
        boolean n = false;
        this.lp$1(in$2, buf$1, sb$1);
        return sb$1.toString();
    }

    public String readFile(String filename) {
        return this.readReader(new FileReader(filename));
    }

    public String readFile(File file) {
        return this.readReader(new FileReader(file));
    }

    public void copyFile(File file, OutputStream out) {
        FileInputStream in = new FileInputStream(file);
        this.pipeStream(in, out);
        in.close();
    }

    public void copyFile(File from, File to) {
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        this.pipeStream(in, out);
        in.close();
        out.close();
    }
}

